/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.repository;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;
import jp.co.intellilink.hinemos.importtool.util.StringListComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportScope {
    private static Log log = LogFactory.getLog(ImportScope.class);
    private ArrayList<Property> scopeList = null;
    private ArrayList<ArrayList<String>> scopeInfos = null;

    public void importScope() {
        log.info((Object)Messages.getMsg("ImportTool.Scope.Start"));
        this.scopeInfos = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/SCOPE.csv");
        this.scopeList = this.getScopeList();
        Collections.sort(this.scopeInfos, new StringListComparator(0));
        Collections.sort(this.scopeInfos, new StringListComparator(3));
        for (ArrayList<String> arrayList : this.scopeInfos) {
            String string = arrayList.get(0);
            if (string.matches("(INTERNAL|REGISTERED|UNREGISTERED)")) continue;
            Property property = this.createScopeInfo(arrayList);
            String string2 = "";
            if (arrayList.size() >= 4) {
                string2 = arrayList.get(3);
            }
            this.registerScopeInfo(string2, property);
        }
    }

    public Property createScopeInfo(ArrayList<String> arrayList) {
        Property property = this.getScopeProperty();
        ArrayList arrayList2 = null;
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"facilityId");
        ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(0));
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"facilityName");
        ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(1));
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"notes");
        ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(2));
        return property;
    }

    protected Property checkScopeList(String string) {
        ArrayList arrayList = null;
        for (Property property : this.scopeList) {
            arrayList = PropertyUtil.getProperty((Property)property, (String)"facilityId");
            String string2 = (String)((Property)arrayList.get(0)).getValue();
            if (string2.compareTo(string) != 0) continue;
            return property;
        }
        return null;
    }

    protected void registerScopeInfo(String string, Property property) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        ArrayList arrayList = null;
        arrayList = PropertyUtil.getProperty((Property)property, (String)"facilityId");
        String string2 = (String)((Property)arrayList.get(0)).getValue();
        try {
            Property property2 = this.checkScopeList(string2);
            if (property2 instanceof Property) {
                Object[] objectArray = new Object[]{string2};
                log.info((Object)(Messages.getMsg("ImportTool.FacilityID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                repositoryController.modifyScope(property);
            } else {
                Object[] objectArray = new Object[]{string2};
                log.info((Object)(Messages.getMsg("ImportTool.FacilityID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                repositoryController.addScope(string, property);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{string2};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected Property getScopeProperty() {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        Property property = null;
        try {
            property = repositoryController.getScopeProperty("", 0, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return property;
    }

    protected ArrayList getScopeList() {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        ArrayList<Property> arrayList = new ArrayList<Property>();
        try {
            ArrayList arrayList2 = repositoryController.getScopeList("");
            if (arrayList2 instanceof ArrayList) {
                for (ArrayList arrayList3 : arrayList2) {
                    String string = (String)arrayList3.get(0);
                    Property property = repositoryController.getScopeProperty(string, 2, Locale.getDefault());
                    arrayList.add(property);
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

