/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.PortRunCountConstant;
import com.clustercontrol.bean.PortRunIntervalConstant;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.port.bean.MonitorPortInfo;
import com.clustercontrol.port.ejb.session.MonitorPortController;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitorNumeric;
import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorPort
extends ImportMonitorNumeric {
    private static Log log = LogFactory.getLog(ImportMonitorPort.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importPort() {
        log.info((Object)Messages.getMsg("ImportTool.Port.Start"));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/PORT.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("ImportTool.Port.End"));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        this.createMonitorBase(arrayList, monitorInfo);
        this.createMonitorRule(arrayList.subList(3, 5), monitorInfo);
        this.createMonitorCheck(arrayList.subList(5, 10), monitorInfo);
        this.createMonitorBlock(arrayList.subList(10, 11), monitorInfo);
        this.createMonitorJudgement(arrayList.subList(11, 16), monitorInfo);
        this.createMonitorNotify(arrayList.subList(16, 21), monitorInfo);
        this.createMonitorApplication(arrayList.subList(21, 22), monitorInfo);
        this.createMonitorVaild(arrayList.subList(22, 23), monitorInfo);
        return monitorInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        MonitorPortInfo monitorPortInfo = new MonitorPortInfo();
        if (list.get(0) instanceof String && list.get(0).compareTo(com.clustercontrol.util.Messages.getString((String)"tcp.connect.only")) == 0) {
            monitorPortInfo.setServiceId("001");
        } else {
            monitorPortInfo.setServiceId("");
        }
        monitorPortInfo.setPortNo(Integer.valueOf(Integer.parseInt(list.get(1))));
        monitorPortInfo.setRunCount(Integer.valueOf(PortRunCountConstant.stringToType((String)list.get(2))));
        monitorPortInfo.setRunInterval(Integer.valueOf(PortRunIntervalConstant.stringToType((String)list.get(3))));
        monitorPortInfo.setTimeout(Integer.valueOf(Integer.parseInt(list.get(4))));
        monitorInfo.setCheckInfo((MonitorCheckInfo)monitorPortInfo);
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorPortController monitorPortController = EjbConnectionManager.getConnectionManager().getMonitorPortController();
        try {
            ArrayList arrayList = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (arrayList instanceof ArrayList) {
                Date date = (Date)arrayList.get(8);
                String string = (String)arrayList.get(7);
                monitorInfo.setRegDate(new Timestamp(date.getTime()));
                monitorInfo.setRegUser(string);
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("ImportTool.MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorPortController.modifyPort(monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("ImportTool.MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorPortController.addPort(monitorInfo);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{monitorInfo.getMonitorId()};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMonitorList() {
        MonitorPortController monitorPortController = EjbConnectionManager.getConnectionManager().getMonitorPortController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorPortController.getPortList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

