/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.job;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.ScheduleInfo;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.JobUtil;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportSchedule {
    private static Log log = LogFactory.getLog(ImportSchedule.class);
    private ArrayList<ArrayList<String>> scheduleInfo = null;
    private ArrayList scheduleList = null;
    private JobTreeItem jobTreeItem = null;

    public void importSchedule() {
        log.info((Object)Messages.getMsg("ImportTool.Job.Schedule.Start"));
        this.scheduleInfo = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/JOB_SCHEDULE.csv");
        this.jobTreeItem = this.getJobTree();
        this.scheduleList = this.getScheduleList();
        for (ArrayList<String> arrayList : this.scheduleInfo) {
            ScheduleInfo scheduleInfo = this.createScheduleInfo(arrayList);
            this.registerSchedule(scheduleInfo);
        }
        log.info((Object)Messages.getMsg("ImportTool.Job.Schedule.End"));
    }

    public ScheduleInfo createScheduleInfo(ArrayList<String> arrayList) {
        Schedule schedule;
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setId(arrayList.get(0));
        scheduleInfo.setName(arrayList.get(1));
        scheduleInfo.setJobId(arrayList.get(2));
        if (!JobUtil.findJobId(scheduleInfo.getJobId(), this.jobTreeItem)) {
            schedule = new Schedule[]{scheduleInfo.getId(), scheduleInfo.getJobId()};
            log.error((Object)Messages.getMsg("ImportTool.Job.5", (Object[])schedule));
            System.exit(20);
        }
        scheduleInfo.setJobName(arrayList.get(3));
        scheduleInfo.setCalendarId(arrayList.get(4));
        schedule = new Schedule();
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        Integer n5 = null;
        if (arrayList.get(5).compareTo(com.clustercontrol.util.Messages.getString((String)"time")) == 0) {
            if (arrayList.get(6).length() > 0) {
                n = Integer.parseInt(arrayList.get(6));
            }
            if (arrayList.get(7).length() > 0) {
                n2 = Integer.parseInt(arrayList.get(7));
            }
            if (arrayList.get(8).length() > 0) {
                n3 = Integer.parseInt(arrayList.get(8));
            }
            if (arrayList.get(9).length() > 0) {
                n4 = Integer.parseInt(arrayList.get(9));
            }
            if (arrayList.get(6).length() == 0 && arrayList.get(7).length() == 0 && arrayList.get(8).length() == 0) {
                schedule.setType(3);
            } else if (arrayList.get(6).length() == 0 && arrayList.get(7).length() == 0) {
                schedule.setType(2);
            } else if (arrayList.get(6).length() == 0) {
                schedule.setType(1);
            } else {
                schedule.setType(0);
            }
            if (!(n instanceof Integer) && schedule.getType() == 0) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.26"));
                return null;
            }
            if (!(n2 instanceof Integer || schedule.getType() != 0 && schedule.getType() != 1)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.27"));
                return null;
            }
            if (!(n3 instanceof Integer || schedule.getType() != 0 && schedule.getType() != 1 && schedule.getType() != 2)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.28"));
                return null;
            }
            if (!(n4 instanceof Integer)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.29"));
                return null;
            }
        } else {
            schedule.setType(4);
            if (arrayList.get(10).length() > 0) {
                n5 = new Integer(DayOfWeekConstant.stringToType((String)arrayList.get(10)));
            }
            if (arrayList.get(11).length() > 0) {
                n3 = Integer.parseInt(arrayList.get(11));
            }
            if (arrayList.get(12).length() > 0) {
                n4 = Integer.parseInt(arrayList.get(12));
            }
            if (!(n5 instanceof Integer)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.37"));
                return null;
            }
            if (!(n3 instanceof Integer)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.28"));
                return null;
            }
            if (!(n4 instanceof Integer)) {
                log.error((Object)com.clustercontrol.util.Messages.getString((String)"message.job.29"));
                return null;
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 0);
        if (n instanceof Integer) {
            calendar.set(2, n - 1);
        }
        if (n2 instanceof Integer) {
            calendar.set(5, n2);
        }
        if (n3 instanceof Integer) {
            calendar.set(11, n3);
        }
        if (n5 instanceof Integer) {
            calendar.set(7, n5);
            schedule.setDayOfWeek(n5.intValue());
        }
        calendar.set(12, n4);
        calendar.set(13, 0);
        schedule.setDate(calendar.getTime());
        scheduleInfo.setSchedule(schedule);
        scheduleInfo.setValid(ValidConstant.stringToType((String)arrayList.get(13)));
        return scheduleInfo;
    }

    protected void registerSchedule(ScheduleInfo scheduleInfo) {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        try {
            ArrayList arrayList = this.checkScheduleList(scheduleInfo.getId());
            if (arrayList instanceof ArrayList) {
                Date date = (Date)arrayList.get(8);
                String string = (String)arrayList.get(7);
                scheduleInfo.setCreateTime(date);
                scheduleInfo.setCreateUser(string);
                Object[] objectArray = new Object[]{scheduleInfo.getId()};
                log.info((Object)(Messages.getMsg("ImportTool.ScheduleID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                jobController.modifySchedule(scheduleInfo);
            } else {
                Object[] objectArray = new Object[]{scheduleInfo.getId()};
                log.info((Object)(Messages.getMsg("ImportTool.ScheduleID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                jobController.addSchedule(scheduleInfo);
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList checkScheduleList(String string) {
        if (this.scheduleList instanceof ArrayList) {
            for (ArrayList arrayList : this.scheduleList) {
                String string2 = (String)arrayList.get(0);
                if (string2.compareTo(string) != 0) continue;
                return arrayList;
            }
        }
        return null;
    }

    protected ArrayList getScheduleList() {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        ArrayList arrayList = null;
        try {
            arrayList = jobController.getScheduleList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected JobTreeItem getJobTree() {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        JobTreeItem jobTreeItem = null;
        try {
            jobTreeItem = jobController.getJobTree(false, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return jobTreeItem;
    }
}

