/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.PortRunCountConstant;
import com.clustercontrol.bean.PortRunIntervalConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.port.bean.PortCheckInfo;
import com.clustercontrol.port.ejb.session.MonitorPortController;
import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitorNumeric;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorPort
extends ImportMonitorNumeric {
    private static Log log = LogFactory.getLog(ImportMonitorPort.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importPort() {
        log.info((Object)Messages.getMsg("Port.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/PORT.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("Port.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        this.createMonitorBase(arrayList, monitorInfo);
        this.createMonitorRule(arrayList.subList(3, 5), monitorInfo);
        this.createMonitorCheck(arrayList.subList(5, 10), monitorInfo);
        this.createMonitorBlock(arrayList.subList(10, 11), monitorInfo);
        this.createMonitorJudgement(arrayList.subList(11, 16), monitorInfo);
        this.createMonitorNotify(arrayList.subList(16, 22), monitorInfo);
        this.createMonitorApplication(arrayList.subList(22, 23), monitorInfo);
        this.createMonitorVaild(arrayList.subList(23, 24), monitorInfo);
        return monitorInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        PortCheckInfo portCheckInfo = new PortCheckInfo();
        if (list.get(0) instanceof String && list.get(0).compareTo(com.clustercontrol.util.Messages.getString((String)"tcp.connect.only")) == 0) {
            portCheckInfo.setServiceId("001");
        } else {
            portCheckInfo.setServiceId("");
        }
        portCheckInfo.setPortNo(Integer.valueOf(Integer.parseInt(list.get(1))));
        portCheckInfo.setRunCount(Integer.valueOf(PortRunCountConstant.stringToType((String)list.get(2))));
        portCheckInfo.setRunInterval(Integer.valueOf(PortRunIntervalConstant.stringToType((String)list.get(3))));
        portCheckInfo.setTimeout(Integer.valueOf(Integer.parseInt(list.get(4))));
        monitorInfo.setPortCheckInfo(portCheckInfo);
        monitorInfo.setMonitorType(1);
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorPortController monitorPortController = EjbConnectionManager.getConnectionManager().getMonitorPortController();
        try {
            MonitorInfo monitorInfo2 = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (monitorInfo2 instanceof MonitorInfo) {
                monitorInfo.setRegDate(monitorInfo2.getRegDate());
                monitorInfo.setRegUser(monitorInfo2.getRegUser());
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorPortController.modifyPort(monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorPortController.addPort(monitorInfo);
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMonitorList() {
        MonitorPortController monitorPortController = EjbConnectionManager.getConnectionManager().getMonitorPortController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorPortController.getPortList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

