/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.session.MonitorSyslogNGController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitor;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.IntegerListComparator;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorSyslogng
extends ExportMonitor {
    private static Log log = LogFactory.getLog(ExportMonitorSyslogng.class);

    public void exportSyslogng() {
        log.info((Object)Messages.getMsg("Syslogng.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<LogFilterInfo> arrayList2 = this.getSyslogngList();
        if (arrayList2 instanceof ArrayList) {
            for (LogFilterInfo object2 : arrayList2) {
                Object[] objectArray = new Object[]{object2.getMonitorId()};
                log.info((Object)Messages.getMsg("MonitorID", objectArray));
                arrayList.add(this.createCsvFormat((MonitorInfo)object2));
            }
            Collections.sort(arrayList, new IntegerListComparator(0));
        }
        Object object = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            object = "_" + simpleDateFormat.format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/SYSLOGNG" + (String)object + ".csv", arrayList);
        log.info((Object)Messages.getMsg("Syslogng.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    @Override
    public ArrayList<String> createCsvFormat(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.createMonitorBase(monitorInfo));
        arrayList.addAll(this.createMonitorRule(monitorInfo));
        arrayList.addAll(this.createMonitorInfo(monitorInfo));
        arrayList.addAll(this.createMonitorNotify(monitorInfo));
        if (monitorInfo.getApplication() != null) {
            arrayList.add(monitorInfo.getApplication());
        } else {
            arrayList.add("");
        }
        LogFilterInfo logFilterInfo = (LogFilterInfo)monitorInfo;
        arrayList.add(PriorityConstant.typeToString((int)logFilterInfo.getPriority()));
        if (logFilterInfo.getMessageId() != null) {
            arrayList.add(logFilterInfo.getMessageId());
        } else {
            arrayList.add("");
        }
        if (logFilterInfo.getMessage() != null) {
            arrayList.add(logFilterInfo.getMessage());
        } else {
            arrayList.add("");
        }
        arrayList.add(ValidConstant.typeToString((int)monitorInfo.getValid()));
        return arrayList;
    }

    @Override
    protected ArrayList<String> createMonitorBase(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        LogFilterInfo logFilterInfo = (LogFilterInfo)monitorInfo;
        arrayList.add(String.valueOf(logFilterInfo.getOrderNo()));
        arrayList.add(monitorInfo.getMonitorId());
        if (monitorInfo.getDescription() != null) {
            arrayList.add(monitorInfo.getDescription());
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    @Override
    protected ArrayList<String> createMonitorRule(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (monitorInfo.getCalendarId() != null) {
            arrayList.add(monitorInfo.getCalendarId());
        } else {
            arrayList.add("");
        }
        arrayList.add(monitorInfo.getFacilityId());
        return arrayList;
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        LogFilterInfo logFilterInfo = (LogFilterInfo)monitorInfo;
        if (logFilterInfo.getPattern() != null) {
            arrayList.add(logFilterInfo.getPattern());
        } else {
            arrayList.add("");
        }
        arrayList.add(ProcessConstant.typeToString((int)logFilterInfo.getProcessType()));
        return arrayList;
    }

    protected ArrayList<LogFilterInfo> getSyslogngList() {
        MonitorSyslogNGController monitorSyslogNGController = EjbConnectionManager.getConnectionManager().getMonitorSyslogNGController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSyslogNGController.getFilterInfoList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

