/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common.util;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class DJUnitUtil {
    public static final String PROJECTS_SOURCE_DIR_KEY = "jp.co.dgic.eclipse.project.source.dir";
    public static final String JUNIT_EXCLUDES_PATHS_KEY = "jp.co.dgic.eclipse.junit.excluded.paths";
    public static final String TRACE_INCLUDE_PATTERNS_KEY = "jp.co.dgic.eclipse.trace.include.patterns";
    public static final String BYTECODE_LIBRARY_KEY = "jp.co.dgic.eclipse.classloader.bytecodelibrary";
    public static final String BYTECODE_LIBRARY_ASM = "ASM";
    public static final String BYTECODE_LIBRARY_BCEL = "BCEL";
    private static String[] DEFAULT_EXCLUSIONS = new String[]{"junit.framework.", "org.objectweb.asm.", "junit.extensions.", "junit.runner.", "com.jcoverage.", "jp.co.dgic.testing.", "org.eclipse.", "org.apache.oro."};

    public static boolean isDJUnitSystemClass(String className) {
        return className.startsWith("jp.co.dgic.testing.common") || className.startsWith("jp.co.dgic.testing.framework");
    }

    private static String[] getSourceDirectories() {
        String directriesValue = System.getProperty(PROJECTS_SOURCE_DIR_KEY);
        if (directriesValue == null) {
            return null;
        }
        return DJUnitUtil.splitValue(directriesValue);
    }

    public static boolean isProjectsSource(String className) {
        String[] dirs = DJUnitUtil.getSourceDirectories();
        if (dirs == null) {
            return false;
        }
        String pathString = null;
        File f = null;
        int idx = 0;
        while (idx < dirs.length) {
            pathString = String.valueOf(dirs[idx]) + "/" + DJUnitUtil.toClassName(className) + ".java";
            f = new File(pathString);
            if (f.exists()) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    private static String toClassName(String className) {
        String name = className.replace('.', '/');
        if (name.indexOf(36) < 0) {
            return name;
        }
        String simpleName = DJUnitUtil.getSimpleName(name);
        if (simpleName.indexOf(36) < 0) {
            return name;
        }
        int lastIndex = name.indexOf(36);
        return name.substring(0, lastIndex);
    }

    private static String getSimpleName(String className) {
        int lastIndex = className.lastIndexOf(46);
        return className.substring(lastIndex + 1);
    }

    public static String[] splitValue(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value, ";");
        String[] values = new String[st.countTokens()];
        int index = 0;
        while (index < values.length) {
            values[index] = st.nextToken();
            ++index;
        }
        return values;
    }

    private static String[] getDefaultExclusions() {
        return DEFAULT_EXCLUSIONS;
    }

    public static boolean isDefaultExcludedPath(String className) {
        String[] defaultExcluded = DJUnitUtil.getDefaultExclusions();
        int idx = 0;
        while (idx < defaultExcluded.length) {
            if (className.startsWith(defaultExcluded[idx])) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public static boolean isExcluded(String className) {
        if (DJUnitUtil.isDefaultExcludedPath(className)) {
            return true;
        }
        return DJUnitUtil.isExcludedForClassloader(className);
    }

    public static boolean isExcludedForClassloader(String className) {
        String paths = System.getProperty(JUNIT_EXCLUDES_PATHS_KEY);
        String[] excluded = DJUnitUtil.splitValue(paths);
        if (excluded == null) {
            return false;
        }
        int idx = 0;
        while (idx < excluded.length) {
            if (className.startsWith(DJUnitUtil.removeAsterisk(excluded[idx]))) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public static boolean isInclude(String className) {
        String[] patterns = DJUnitUtil.getTraceIncludPatterns();
        if (patterns == null) {
            return false;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        int index = 0;
        while (index < patterns.length) {
            try {
                if (matcher.matches(className, compiler.compile(patterns[index]))) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++index;
        }
        return false;
    }

    private static String[] getTraceIncludPatterns() {
        String excludedPatterns = System.getProperty(TRACE_INCLUDE_PATTERNS_KEY);
        if (excludedPatterns == null) {
            return null;
        }
        return DJUnitUtil.splitValue(excludedPatterns);
    }

    public static String getJavaProjectType(String key) {
        if (key == null) {
            return key;
        }
        int index = key.indexOf(36);
        if (index < 0) {
            return key;
        }
        String className = key.substring(index + 1);
        if (!DJUnitUtil.isDigit(className)) {
            return key.replace('$', '.');
        }
        String type = key.substring(0, index);
        return DJUnitUtil.getJavaProjectType(type);
    }

    private static boolean isDigit(String string) {
        if (string == null) {
            return false;
        }
        char[] chars = string.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Character.isDigit(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String removeAsterisk(String pathString) {
        if (pathString == null) {
            return null;
        }
        if (!pathString.endsWith("*")) {
            return pathString;
        }
        return pathString.substring(0, pathString.length() - 1);
    }
}

