/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.job;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.util.PropertyUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckResultSchedule {
    private Date fromDate;
    private Date toDate;
    private static Log log = LogFactory.getLog(CheckResultSchedule.class);

    public CheckResultSchedule(Date date, Date date2) {
        this.fromDate = date;
        this.toDate = date2;
    }

    public void checkResult() {
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.Job.Schedule.Start")));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getScheduleList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(0)};
                log.info((Object)Messages.getMsg("TestTool.ScheduleID", objectArray));
                arrayList.add(this.createCheckResult(arrayList3));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Check.Output.Dir") + "/JOB_SCHEDULE_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.Job.Schedule.End")));
    }

    public ArrayList<String> createCheckResult(ArrayList arrayList) {
        ArrayList<String> arrayList2;
        block2: {
            Date date;
            Iterator iterator;
            arrayList2 = new ArrayList<String>();
            arrayList2.add(this.getStringValue(arrayList, 0));
            arrayList2.add(this.getStringValue(arrayList, 1));
            arrayList2.add(this.getStringValue(arrayList, 2));
            arrayList2.add(this.getStringValue(arrayList, 3));
            arrayList2.add(this.createSchedule((Schedule)arrayList.get(5)));
            ViewListInfo viewListInfo = this.getSessionList(this.getStringValue(arrayList, 2));
            if (!(viewListInfo.getList() instanceof ArrayList) || !(iterator = viewListInfo.getList().iterator()).hasNext()) break block2;
            ArrayList arrayList3 = (ArrayList)iterator.next();
            String string = "";
            String string2 = "";
            if (arrayList3.get(9) instanceof Date) {
                date = (Date)arrayList3.get(9);
                string = DateFormat.getDateTimeInstance().format(date);
            }
            if (arrayList3.get(11) instanceof Date) {
                date = (Date)arrayList3.get(11);
                string2 = DateFormat.getDateTimeInstance().format(date);
            }
            arrayList2.add(string);
            arrayList2.add(string2);
        }
        return arrayList2;
    }

    protected String createSchedule(Schedule schedule) {
        String string = "";
        if (schedule.getType() == 0) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd HH:mm");
            if (schedule.getDate() instanceof Date) {
                string = simpleDateFormat.format(schedule.getDate());
            }
        } else if (schedule.getType() == 1) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd'" + com.clustercontrol.util.Messages.getString((String)"monthday") + "' HH:mm");
            if (schedule.getDate() instanceof Date) {
                string = simpleDateFormat.format(schedule.getDate());
            }
        } else if (schedule.getType() == 2) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
            if (schedule.getDate() instanceof Date) {
                string = simpleDateFormat.format(schedule.getDate());
            }
        } else if (schedule.getType() == 3) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm'" + com.clustercontrol.util.Messages.getString((String)"minute") + "'");
            if (schedule.getDate() instanceof Date) {
                string = simpleDateFormat.format(schedule.getDate());
            }
        } else if (schedule.getType() == 4) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(" HH:mm");
            if (schedule.getDate() instanceof Date) {
                string = DayOfWeekConstant.typeToString((int)schedule.getDayOfWeek()) + simpleDateFormat.format(schedule.getDate());
            }
        }
        return string;
    }

    public String getStringValue(ArrayList arrayList, int n) {
        if (arrayList.size() > n - 1 && arrayList.get(n) instanceof String) {
            return (String)arrayList.get(n);
        }
        return "";
    }

    protected ViewListInfo getSessionList(String string) {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        ViewListInfo viewListInfo = null;
        try {
            ArrayList arrayList = null;
            Property property = jobController.getHistoryFilterProperty(Locale.getDefault());
            if (string instanceof String) {
                arrayList = PropertyUtil.getProperty((Property)property, (String)"jobId");
                ((Property)arrayList.get(0)).setValue((Object)string);
            }
            if (this.fromDate instanceof Date) {
                arrayList = PropertyUtil.getProperty((Property)property, (String)"startFromDate");
                ((Property)arrayList.get(0)).setValue((Object)this.fromDate);
            }
            if (this.toDate instanceof Date) {
                arrayList = PropertyUtil.getProperty((Property)property, (String)"startToDate");
                ((Property)arrayList.get(0)).setValue((Object)this.toDate);
            }
            int n = Integer.parseInt(Config.getConfig("history.job.max.list"));
            viewListInfo = jobController.getHistoryList(property, n);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("TestTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return viewListInfo;
    }

    protected ArrayList getScheduleList() {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        ArrayList arrayList = null;
        try {
            arrayList = jobController.getScheduleList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("TestTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

