/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.job;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportTestCaseJob {
    private static Log log = LogFactory.getLog(ExportTestCaseJob.class);

    public void exportTestCase() {
        log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.Job.Start")));
        JobTreeItem jobTreeItem = this.getJobTree();
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        this.getJobData(jobTreeItem, arrayList);
        Collections.sort(arrayList, new StringListComparator(0));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Testcase.Output.Dir") + "/JOB_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.Job.End")));
    }

    public void getJobData(JobTreeItem jobTreeItem, ArrayList<ArrayList<String>> arrayList) {
        JobTreeItem[] jobTreeItemArray;
        if (jobTreeItem.getData() instanceof JobInfo && (jobTreeItemArray = jobTreeItem.getData()).getId() != null && jobTreeItemArray.getId().compareTo("") != 0) {
            JobInfo jobInfo;
            log.info((Object)(Messages.getMsg("TestTool.JobUnitID", new String[]{jobTreeItemArray.getJobunitId()}) + ", " + Messages.getMsg("TestTool.JobID", new String[]{jobTreeItemArray.getId()})));
            ArrayList<String> arrayList2 = this.createCsvFormat((JobInfo)jobTreeItemArray);
            String string = "";
            if (jobTreeItem.getParent() != null && jobTreeItem.getParent().getData() instanceof JobInfo && (jobInfo = jobTreeItem.getParent().getData()).getId() != null && jobInfo.getId().compareTo("") != 0) {
                string = jobInfo.getId();
            }
            arrayList2.add(4, string);
            arrayList.add(arrayList2);
        }
        jobTreeItemArray = jobTreeItem.getChildrenArray();
        for (JobTreeItem jobTreeItem2 : jobTreeItemArray) {
            this.getJobData(jobTreeItem2, arrayList);
        }
    }

    public ArrayList<String> createCsvFormat(JobInfo jobInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(jobInfo.getJobunitId());
        arrayList.add(jobInfo.getId());
        arrayList.add(jobInfo.getName());
        arrayList.add(JobConstant.typeToString((int)jobInfo.getType()));
        arrayList.add("");
        arrayList.add("");
        arrayList.add("");
        return arrayList;
    }

    protected JobTreeItem getJobTree() {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        JobTreeItem jobTreeItem = null;
        try {
            jobTreeItem = jobController.getJobTree(true, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("TestTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return jobTreeItem;
    }
}

