/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.notify;

import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoData;
import com.clustercontrol.notify.mail.ejb.session.MailTemplateController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMailTemplate {
    private static Log log = LogFactory.getLog(ExportMailTemplate.class);

    public void exportMailTemplate() {
        log.info((Object)Messages.getMsg("MailTemplate.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getMailTemplateIdList();
        if (arrayList2 instanceof ArrayList) {
            for (String string : arrayList2) {
                Object[] objectArray = new Object[]{string};
                log.info((Object)Messages.getMsg("MailTemplateID", objectArray));
                MailTemplateInfoData mailTemplateInfoData = this.getMailTemplate(string);
                arrayList.add(this.createCsvFormat(mailTemplateInfoData));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/MAILTEMPLATE_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)Messages.getMsg("MailTemplate.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    public ArrayList<String> createCsvFormat(MailTemplateInfoData mailTemplateInfoData) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(mailTemplateInfoData.getMailTemplateId());
        if (mailTemplateInfoData.getDescription() != null) {
            arrayList.add(mailTemplateInfoData.getDescription());
        } else {
            arrayList.add("");
        }
        if (mailTemplateInfoData.getSubject() != null) {
            arrayList.add(mailTemplateInfoData.getSubject());
        } else {
            arrayList.add("");
        }
        if (mailTemplateInfoData.getBody() != null) {
            arrayList.add(CheckString.checkReturn(mailTemplateInfoData.getBody()));
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    protected MailTemplateInfoData getMailTemplate(String string) {
        MailTemplateController mailTemplateController = EjbConnectionManager.getConnectionManager().getMailTemplateController();
        MailTemplateInfoData mailTemplateInfoData = null;
        try {
            mailTemplateInfoData = mailTemplateController.getMailTemplateInfo(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return mailTemplateInfoData;
    }

    protected ArrayList getMailTemplateIdList() {
        MailTemplateController mailTemplateController = EjbConnectionManager.getConnectionManager().getMailTemplateController();
        ArrayList arrayList = null;
        try {
            arrayList = mailTemplateController.getMailTemplateIdList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

