/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.sql.bean.MonitorSqlInfo;
import com.clustercontrol.sql.ejb.session.MonitorSqlController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorString;
import jp.co.intellilink.hinemos.export.conf.monitor.JdbcDriverUtil;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.IntegerListComparator;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorSqlString
extends ExportMonitorString {
    private static Log log = LogFactory.getLog(ExportMonitorSqlString.class);

    public void exportSql() {
        log.info((Object)Messages.getMsg("Sql.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        ArrayList arrayList3 = this.getSnmpList();
        if (arrayList3 instanceof ArrayList) {
            for (ArrayList arrayList4 : arrayList3) {
                int n = MonitorTypeConstant.stringToType((String)((String)arrayList4.get(3)));
                if (n != 2) continue;
                Object[] objectArray = new Object[]{(String)arrayList4.get(0)};
                log.info((Object)Messages.getMsg("MonitorID", objectArray));
                MonitorInfo monitorInfo = this.getSnmp((String)arrayList4.get(0), n);
                arrayList.add(this.createCsvFormat(monitorInfo));
                arrayList2.addAll(this.createMonitorJudgement(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(0));
            Collections.sort(arrayList2, new IntegerListComparator(1));
            Collections.sort(arrayList2, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/SQL_STR_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/SQL_STR_RULE_" + simpleDateFormat.format(new Date()) + ".csv", arrayList2);
        log.info((Object)Messages.getMsg("Sql.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MonitorSqlInfo monitorSqlInfo = (MonitorSqlInfo)monitorInfo.getCheckInfo();
        if (monitorSqlInfo == null) {
            monitorSqlInfo = new MonitorSqlInfo();
        }
        if (monitorSqlInfo.getConnectionUrl() != null) {
            arrayList.add(monitorSqlInfo.getConnectionUrl());
        } else {
            arrayList.add("");
        }
        if (monitorSqlInfo.getJdbcDriver() != null) {
            List<List<String>> list = JdbcDriverUtil.getJdbcDriver();
            for (int i = 0; i < list.size(); ++i) {
                List<String> list2 = list.get(i);
                String string = list2.get(1);
                if (!string.equals(monitorSqlInfo.getJdbcDriver())) continue;
                arrayList.add(list2.get(0));
                break;
            }
        } else {
            arrayList.add("");
        }
        if (monitorSqlInfo.getUser() != null) {
            arrayList.add(monitorSqlInfo.getUser().toString());
        } else {
            arrayList.add("");
        }
        if (monitorSqlInfo.getPassword() != null) {
            arrayList.add(monitorSqlInfo.getPassword());
        } else {
            arrayList.add("");
        }
        if (monitorSqlInfo.getQuery() != null) {
            arrayList.add(monitorSqlInfo.getQuery());
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    protected MonitorInfo getSnmp(String string, int n) {
        MonitorSqlController monitorSqlController = EjbConnectionManager.getConnectionManager().getMonitorSqlController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorSqlController.getSqlInfo(string, n);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getSnmpList() {
        MonitorSqlController monitorSqlController = EjbConnectionManager.getConnectionManager().getMonitorSqlController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSqlController.getSqlList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

