/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.process.bean.MonitorProcessInfo;
import com.clustercontrol.process.ejb.session.MonitorProcessController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorNumeric;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorProcess
extends ExportMonitorNumeric {
    private static Log log = LogFactory.getLog(ExportMonitorProcess.class);

    public ExportMonitorProcess() {
        super(2);
    }

    public void exportProcess() {
        log.info((Object)Messages.getMsg("Process.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getProcessList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(0)};
                log.info((Object)Messages.getMsg("MonitorID", objectArray));
                MonitorInfo monitorInfo = this.getProcess((String)arrayList3.get(0));
                arrayList.add(this.createCsvFormat(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/PROCESS_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)Messages.getMsg("Process.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MonitorProcessInfo monitorProcessInfo = (MonitorProcessInfo)monitorInfo.getCheckInfo();
        if (monitorProcessInfo == null) {
            monitorProcessInfo = new MonitorProcessInfo();
        }
        if (monitorProcessInfo.getCommand() != null) {
            arrayList.add(monitorProcessInfo.getCommand());
        } else {
            arrayList.add("");
        }
        if (monitorProcessInfo.getParam() != null) {
            arrayList.add(monitorProcessInfo.getParam());
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    protected MonitorInfo getProcess(String string) {
        MonitorProcessController monitorProcessController = EjbConnectionManager.getConnectionManager().getMonitorProcessController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorProcessController.getProcess(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getProcessList() {
        MonitorProcessController monitorProcessController = EjbConnectionManager.getConnectionManager().getMonitorProcessController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorProcessController.getProcessList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

