/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.junit.ui;

import java.util.StringTokenizer;
import jp.co.dgic.eclipse.jdt.internal.junit.ui.DJUnitMessages;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ExcludePropertyPanel
extends Composite {
    public static final String INVALID_MARK = "{{INVALID}}";
    public static final String PATH_DELIMITOR = ";";
    private Label titleLabel;
    private Table propertyTable;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button useDefaultButton;
    private boolean hasDefaultCheck;
    private String defaultValues;

    public ExcludePropertyPanel(Composite parent) {
        this(parent, false);
    }

    public ExcludePropertyPanel(Composite parent, int width, int height) {
        this(parent, false, width, height);
    }

    public ExcludePropertyPanel(Composite parent, boolean hasDefaultCheck) {
        this(parent, hasDefaultCheck, 300, 300);
    }

    public ExcludePropertyPanel(Composite parent, boolean hasDefaultCheck, int width, int height) {
        super(parent, 0);
        this.hasDefaultCheck = hasDefaultCheck;
        this.initialize(width, height);
    }

    private void initialize(int width, int height) {
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.setLayout((Layout)gl);
        this.titleLabel = new Label((Composite)this, 0);
        if (this.hasDefaultCheck) {
            this.useDefaultButton = new Button((Composite)this, 32);
            this.useDefaultButton.setText(DJUnitMessages.getString("ExcludePropertyPanel.label.usedefault"));
            this.useDefaultButton.setSelection(true);
            this.useDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = ((Button)e.getSource()).getSelection();
                    ExcludePropertyPanel.this.setUseDefault(isSelected);
                }
            });
        } else {
            new Label((Composite)this, 0);
        }
        this.propertyTable = new Table((Composite)this, 67620);
        this.propertyTable.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.widthHint = width;
        gd.heightHint = height;
        gd.verticalSpan = 4;
        this.propertyTable.setLayoutData((Object)gd);
        TableColumn column = new TableColumn(this.propertyTable, 0);
        column.setText(DJUnitMessages.getString("ExcludePropertyPanel.label.excluded"));
        column.setWidth(300);
        this.addButton = new Button((Composite)this, 0);
        this.addButton.setText(DJUnitMessages.getString("ExcludePropertyPanel.label.add"));
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog input = new InputDialog(ExcludePropertyPanel.this.addButton.getShell(), DJUnitMessages.getString("ExcludePropertyPanel.label.add"), DJUnitMessages.getString("ExcludePropertyPanel.message.add"), "", null);
                int code = input.open();
                if (code == 1) {
                    return;
                }
                if (input.getValue() != null && !"".equals(input.getValue())) {
                    TableItem newItem = new TableItem(ExcludePropertyPanel.this.propertyTable, 0);
                    newItem.setChecked(true);
                    newItem.setText(0, input.getValue());
                }
            }
        });
        this.editButton = new Button((Composite)this, 0);
        this.editButton.setText(DJUnitMessages.getString("ExcludePropertyPanel.label.edit"));
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ExcludePropertyPanel.this.propertyTable.getSelectionIndex();
                if (index < 0) {
                    return;
                }
                String text = ExcludePropertyPanel.this.propertyTable.getItem(index).getText();
                InputDialog input = new InputDialog(ExcludePropertyPanel.this.editButton.getShell(), DJUnitMessages.getString("ExcludePropertyPanel.label.edit"), DJUnitMessages.getString("ExcludePropertyPanel.message.edit"), text, null);
                int code = input.open();
                if (code == 1) {
                    return;
                }
                if (input.getValue() != null && !"".equals(input.getValue())) {
                    ExcludePropertyPanel.this.propertyTable.getItem(index).setText(0, input.getValue());
                } else {
                    ExcludePropertyPanel.this.propertyTable.remove(index);
                }
            }
        });
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setText(DJUnitMessages.getString("ExcludePropertyPanel.label.remove"));
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ExcludePropertyPanel.this.propertyTable.getSelectionIndex();
                if (index < 0) {
                    return;
                }
                ExcludePropertyPanel.this.propertyTable.remove(index);
            }
        });
        this.setEnabled(!this.hasDefaultCheck);
    }

    public void setText(String text) {
        this.titleLabel.setText(text);
    }

    public void setDefaultValues(String defaultValues) {
        this.defaultValues = defaultValues;
    }

    public void setEnabled(boolean isEnable) {
        this.propertyTable.setEnabled(isEnable);
        this.addButton.setEnabled(isEnable);
        this.editButton.setEnabled(isEnable);
        this.removeButton.setEnabled(isEnable);
    }

    public void clear() {
        this.propertyTable.removeAll();
    }

    public boolean getUseDefault() {
        if (this.useDefaultButton == null) {
            return false;
        }
        return this.useDefaultButton.getSelection();
    }

    public void setUseDefault(boolean isDefault) {
        if (this.useDefaultButton != null) {
            this.useDefaultButton.setSelection(isDefault);
        }
        this.setEnabled(!isDefault);
        if (isDefault) {
            this.setValue(this.defaultValues);
        }
    }

    public void setValue(String[] values) {
        this.propertyTable.removeAll();
        if (values == null) {
            return;
        }
        String value = null;
        boolean invalid = false;
        int index = 0;
        while (index < values.length) {
            TableItem item = new TableItem(this.propertyTable, 0);
            invalid = false;
            value = values[index];
            if (values[index].startsWith(INVALID_MARK)) {
                invalid = true;
                value = values[index].substring(INVALID_MARK.length());
            }
            item.setChecked(!invalid);
            item.setText(0, value);
            ++index;
        }
    }

    public void setValue(String value) {
        this.setValue(this.splitValue(value));
    }

    public String getValue() {
        TableItem[] items = this.propertyTable.getItems();
        if (items == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (index < items.length) {
            if (!items[index].getChecked()) {
                sb.append(INVALID_MARK);
            }
            sb.append(items[index].getText(0));
            sb.append(PATH_DELIMITOR);
            ++index;
        }
        return sb.toString();
    }

    private String[] splitValue(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value, PATH_DELIMITOR);
        String[] values = new String[st.countTokens()];
        int index = 0;
        while (index < values.length) {
            values[index] = st.nextToken();
            ++index;
        }
        return values;
    }
}

