/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.performance;

import com.clustercontrol.performance.bean.CollectedDataInfo;
import com.clustercontrol.performance.bean.CollectedDataSet;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.bean.CollectorProperty;
import com.clustercontrol.performance.ejb.bmp.RecordCollectorData;
import com.clustercontrol.performance.ejb.session.CollectorController;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jp.co.intellilink.hinemos.test.performance.CollectorItemCodeFactory;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckRecordData {
    private CollectorProperty property;
    private String facilityID;
    private File file;
    private FileOutputStream fos;
    private OutputStreamWriter osw;
    private BufferedWriter bw;
    private Date lastDate = null;
    private int getSize = 100;
    private long collectStartTime;
    private long collectStopTime;
    private HashMap<String, Date> checkResultMap;

    public CheckRecordData(CollectorProperty collectorProperty, String string) {
        this.property = collectorProperty;
        this.facilityID = string;
        this.checkResultMap = new HashMap();
    }

    private void openFile() throws FileNotFoundException {
        this.fos = new FileOutputStream(this.file);
        this.osw = new OutputStreamWriter(this.fos);
        this.bw = new BufferedWriter(this.osw);
    }

    private void closeFile() throws IOException {
        this.bw.close();
        this.osw.close();
        this.fos.close();
    }

    public ArrayList<ArrayList<String>> check() {
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        RecordCollectorData recordCollectorData = this.property.getCollectorData();
        for (int i = 0; i < this.property.getItemList().size(); ++i) {
            CollectorItemInfo collectorItemInfo = (CollectorItemInfo)this.property.getItemList().get(i);
            String string = CollectorItemCodeFactory.getFullItemName(collectorItemInfo.getItemCode(), collectorItemInfo.getDeviceName());
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(recordCollectorData.getCollectorID());
            arrayList2.add(this.facilityID);
            arrayList2.add(string);
            if (this.checkResultMap.get(string) instanceof Date) {
                arrayList2.add(DateFormat.getDateTimeInstance().format(this.checkResultMap.get(string)));
            } else {
                arrayList2.add("NG");
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string) {
        try {
            this.file = new File(string);
            this.openFile();
            RecordCollectorData recordCollectorData = this.property.getCollectorData();
            this.collectStartTime = recordCollectorData.getStartDate().getTime();
            this.collectStopTime = recordCollectorData.getStopDate() == null ? System.currentTimeMillis() : recordCollectorData.getStopDate().getTime();
            int n = recordCollectorData.getIntervalSec();
            int n2 = n * 1000 * this.getSize;
            long l = n * 3 * 1000;
            long l2 = this.collectStartTime;
            long l3 = 0L;
            int n3 = (int)(this.collectStopTime - this.collectStartTime) / n2 + 1;
            int n4 = 0;
            while (l2 < this.collectStopTime) {
                l3 = l2 + (long)n2;
                Date date = new Date(l2 - l);
                Date date2 = new Date(l3);
                CollectorController collectorController = EjbConnectionManager.getConnectionManager().getCollectorController();
                if (collectorController == null) {
                    throw new RemoteException("Can't connect to manager.");
                }
                CollectedDataSet collectedDataSet = new CollectedDataSet();
                List list = this.property.getItemList();
                for (int i = 0; i < this.property.getItemList().size(); ++i) {
                    String[] stringArray = new String[]{this.facilityID};
                    CollectorItemInfo[] collectorItemInfoArray = new CollectorItemInfo[]{(CollectorItemInfo)list.get(i)};
                    CollectedDataSet collectedDataSet2 = collectorController.getRecordCollectedData(stringArray, collectorItemInfoArray, date, date2);
                    if (collectedDataSet2 == null) {
                        throw new RemoteException("Get performance data failed.");
                    }
                    collectedDataSet.addCollectedDataList(collectedDataSet2);
                }
                this.write(collectedDataSet);
                l2 = l3;
                ++n4;
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                this.closeFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void write(CollectedDataSet collectedDataSet) throws IOException {
        String string;
        int n;
        Object object;
        int n2;
        int n3;
        Object object2;
        List list = this.property.getItemList();
        List list2 = this.property.getItemList();
        if (this.lastDate == null) {
            object2 = Messages.getMsg("EXPORT_COLUMN_TIME");
            for (n3 = 0; n3 < list2.size(); ++n3) {
                for (n2 = 0; n2 < list.size(); ++n2) {
                    CollectorItemInfo collectorItemInfo = (CollectorItemInfo)list.get(n2);
                    if (!collectorItemInfo.getItemCode().equals(((CollectorItemInfo)list2.get(n3)).getItemCode()) || !collectorItemInfo.getDeviceName().equals(((CollectorItemInfo)list2.get(n3)).getDeviceName())) continue;
                    object = CollectorItemCodeFactory.getFullItemName(collectorItemInfo.getItemCode(), collectorItemInfo.getDeviceName());
                    object2 = (String)object2 + ", " + (String)object;
                    n2 = list.size();
                }
            }
            this.bw.write((String)object2);
            this.bw.newLine();
        }
        if (((List[])(object2 = new List[collectedDataSet.getDataListNum(this.facilityID)])).length != list2.size()) {
            this.bw.write(Messages.getMsg("INVALID_DATA_IN_DB"));
            this.bw.newLine();
            return;
        }
        for (n3 = 0; n3 < list2.size(); ++n3) {
            object2[n3] = collectedDataSet.getCollectedDataList(this.facilityID, (CollectorItemInfo)list2.get(n3));
        }
        n3 = object2[0].size();
        for (n2 = 1; n2 < list2.size(); ++n2) {
            if (n3 == object2[n2].size()) continue;
            this.bw.write(Messages.getMsg("INVALID_DATA_IN_DB"));
            this.bw.newLine();
            return;
        }
        CollectedDataInfo collectedDataInfo = null;
        for (n = 0; n < n3; ++n) {
            object = (CollectedDataInfo)object2[0].get(n);
            if (this.lastDate != null && object.getDate().getTime() <= this.lastDate.getTime()) continue;
            string = null;
            for (int i = 0; i < list2.size(); ++i) {
                collectedDataInfo = (CollectedDataInfo)object2[i].get(n);
                string = i == 0 ? DateFormat.getDateTimeInstance().format(collectedDataInfo.getDate()) + ", " + Double.toString(collectedDataInfo.getValue()) : string + ", " + Double.toString(collectedDataInfo.getValue());
            }
            this.bw.write(string);
            this.bw.newLine();
        }
        for (n = 0; n < list2.size(); ++n) {
            object = (CollectorItemInfo)list2.get(n);
            string = CollectorItemCodeFactory.getFullItemName(object.getItemCode(), object.getDeviceName());
            CollectedDataInfo collectedDataInfo2 = null;
            for (int i = 0; i < n3; ++i) {
                CollectedDataInfo collectedDataInfo3 = (CollectedDataInfo)object2[0].get(i);
                if (this.lastDate != null && collectedDataInfo3.getDate().getTime() <= this.lastDate.getTime() || Double.isNaN((collectedDataInfo2 = (CollectedDataInfo)object2[n].get(i)).getValue()) || this.checkResultMap.get(string) != null && !this.checkResultMap.get(string).before(collectedDataInfo2.getDate())) continue;
                this.checkResultMap.put(string, collectedDataInfo2.getDate());
            }
        }
        if (collectedDataInfo != null) {
            this.lastDate = collectedDataInfo.getDate();
        }
    }
}

