/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.coverage.report;

import java.util.Iterator;
import java.util.Map;
import jp.co.dgic.eclipse.jdt.internal.coverage.report.CoverageCanvas;
import jp.co.dgic.eclipse.jdt.internal.coverage.report.ICoverageLabel;
import jp.co.dgic.eclipse.jdt.internal.coverage.ui.CoverageReportView;
import jp.co.dgic.eclipse.jdt.internal.coverage.util.CoverageUtil;
import jp.co.dgic.testing.common.coverage.CoverageEntry;
import jp.co.dgic.testing.common.util.DJUnitUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;

public class FilesCanvas
extends CoverageCanvas {
    private static final int[] WIDTHS;
    private int minLineNumber = -1;
    private int maxLineNumber = -1;

    static {
        int[] nArray = new int[7];
        nArray[0] = 600;
        nArray[2] = 100;
        nArray[3] = 60;
        nArray[4] = 150;
        nArray[5] = 60;
        nArray[6] = 150;
        WIDTHS = nArray;
    }

    public FilesCanvas(CoverageReportView coverageView, int minLineNumber, int maxLineNumber) {
        super(coverageView, "file");
        this.minLineNumber = minLineNumber;
        this.maxLineNumber = maxLineNumber;
        this.init();
    }

    protected void buildContents() {
        int lineCount = -1;
        Map entries = CoverageUtil.getFileCoverage();
        Iterator it = entries.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            CoverageEntry entry = (CoverageEntry)me.getValue();
            if (this.isFilteredPackage(entry)) continue;
            if (++lineCount >= this.maxLineNumber) break;
            if (lineCount < this.minLineNumber) continue;
            this.addRow(entry);
        }
    }

    private boolean isFilteredPackage(CoverageEntry entry) {
        String packageName = this.coverageView.getPackageNameFilter();
        if (packageName == null) {
            return false;
        }
        if (packageName.equalsIgnoreCase("default")) {
            return entry.getName().indexOf(46) >= 0;
        }
        return !entry.getName().startsWith(String.valueOf(packageName) + ".");
    }

    protected int[] getFieldWidths() {
        return WIDTHS;
    }

    protected void mouseClick(ICoverageLabel label) {
        IJavaProject project = this.coverageView.getJavaProject();
        if (project == null) {
            return;
        }
        try {
            IType element = project.findType(DJUnitUtil.getJavaProjectType(label.getText()));
            EditorUtility.openInEditor((Object)element, (boolean)true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

