/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.logtransfer;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.ejb.session.LogTransferController;
import com.clustercontrol.monitor.bean.ReportEventInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckResultLogTransfer {
    private Date fromDate;
    private Date toDate;
    private static Log log = LogFactory.getLog(CheckResultLogTransfer.class);

    public CheckResultLogTransfer(Date date, Date date2) {
        this.fromDate = date;
        this.toDate = date2;
    }

    public void checkResult() {
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.LogTransfer.Start")));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getLogTransferIdList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(0)};
                log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.TransferID", objectArray)));
                LogTransferInfo logTransferInfo = this.getLogTransfer((String)arrayList3.get(0));
                arrayList.addAll(this.createCheckResult(logTransferInfo));
            }
            Collections.sort(arrayList, new StringListComparator(2));
            Collections.sort(arrayList, new StringListComparator(1));
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Check.Output.Dir") + "/LOGTRANSFER_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.LogTransfer.End")));
    }

    public ArrayList<ArrayList<String>> createCheckResult(LogTransferInfo logTransferInfo) {
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(this.getNodeList(logTransferInfo.getFacilityId()));
        for (String string : arrayList2) {
            Iterator iterator = logTransferInfo.getFileInfo().iterator();
            if (!iterator.hasNext()) continue;
            LogTransferFileInfo logTransferFileInfo = (LogTransferFileInfo)iterator.next();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add(logTransferInfo.getTransferId());
            arrayList3.add(string);
            arrayList3.add(logTransferFileInfo.getFilePath());
            arrayList3.addAll(this.checkEvent(logTransferInfo, string, logTransferFileInfo));
            arrayList.add(arrayList3);
        }
        return arrayList;
    }

    protected ArrayList<String> checkEvent(LogTransferInfo logTransferInfo, String string, LogTransferFileInfo logTransferFileInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "-";
        String string3 = "-";
        String string4 = "-";
        String string5 = "-";
        if (logTransferInfo.getValid() == 0 || logTransferFileInfo.getValid() == 0) {
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            arrayList.add(string5);
            return arrayList;
        }
        string2 = this.checkEventByPriority(logTransferInfo, string, logTransferFileInfo.getFilePath(), 3, this.fromDate, this.toDate);
        string3 = this.checkEventByPriority(logTransferInfo, string, logTransferFileInfo.getFilePath(), 2, this.fromDate, this.toDate);
        string4 = this.checkEventByPriority(logTransferInfo, string, logTransferFileInfo.getFilePath(), 0, this.fromDate, this.toDate);
        string5 = this.checkEventByPriority(logTransferInfo, string, logTransferFileInfo.getFilePath(), 1, this.fromDate, this.toDate);
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string4);
        arrayList.add(string5);
        return arrayList;
    }

    protected String checkEventByPriority(LogTransferInfo logTransferInfo, String string, String string2, int n, Date date, Date date2) {
        String string3 = "";
        ArrayList<ReportEventInfo> arrayList = EjbConnectionManager.getConnectionManager().getEvent(string, date, date2);
        Date date3 = null;
        for (ReportEventInfo reportEventInfo : arrayList) {
            int n2 = PriorityConstant.stringToType((String)reportEventInfo.getPriority());
            if (n2 != n || !(reportEventInfo.getMessageOrg() instanceof String) || !reportEventInfo.getMessageOrg().matches(".*hinemos_log_agent\\(" + string2 + "\\).*")) continue;
            if (date3 instanceof Date) {
                if (!date3.before(reportEventInfo.getGenerationDate())) continue;
                date3 = reportEventInfo.getGenerationDate();
                continue;
            }
            date3 = reportEventInfo.getGenerationDate();
        }
        if (date3 instanceof Date) {
            string3 = DateFormat.getDateTimeInstance().format(date3);
        }
        return string3;
    }

    protected ArrayList<String> getNodeList(String string) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (repositoryController.isNode(string)) {
                arrayList.add(string);
            } else {
                arrayList.addAll(repositoryController.getExecTargetFacilityIdList(string));
            }
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected LogTransferInfo getLogTransfer(String string) {
        LogTransferController logTransferController = EjbConnectionManager.getConnectionManager().getLogTransferController();
        LogTransferInfo logTransferInfo = null;
        try {
            logTransferInfo = logTransferController.getLogTransfer(string);
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return logTransferInfo;
    }

    protected ArrayList getLogTransferIdList() {
        LogTransferController logTransferController = EjbConnectionManager.getConnectionManager().getLogTransferController();
        ArrayList arrayList = null;
        try {
            arrayList = logTransferController.getLogTransferList();
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

