/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.junit.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorActionBarContributor;

public class DJUnitTestRunnerClient {
    private ServerSocket fServerSocket;
    private Socket fSocket;
    private int fPort = -1;
    private PrintWriter fWriter;
    private BufferedReader fBufferedReader;
    private boolean fDebug = false;

    public synchronized void startListening(int port) {
        this.fPort = port;
        ServerConnection connection = new ServerConnection(port);
        connection.start();
    }

    public synchronized void stopTest() {
        if (this.isRunning()) {
            this.fWriter.println(">STOP   ");
            this.fWriter.flush();
        }
    }

    public synchronized void shutDown() {
        this.clearInfo();
        if (this.fDebug) {
            System.out.println("shutdown " + this.fPort);
        }
        if (this.fWriter != null) {
            this.fWriter.close();
            this.fWriter = null;
        }
        try {
            if (this.fBufferedReader != null) {
                this.fBufferedReader.close();
                this.fBufferedReader = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.fSocket != null) {
                this.fSocket.close();
                this.fSocket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.fServerSocket != null) {
                this.fServerSocket.close();
                this.fServerSocket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isRunning() {
        return this.fSocket != null;
    }

    private String readMessage(BufferedReader in) throws IOException {
        return in.readLine();
    }

    private void receiveMessage(String message) {
        this.postInfo(message);
    }

    private void clearInfo() {
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                IStatusLineManager statusLine = DJUnitTestRunnerClient.this.getStatusLine();
                if (statusLine == null) {
                    return;
                }
                statusLine.setErrorMessage(null);
                statusLine.setMessage(null);
            }
        });
    }

    private void postInfo(final String message) {
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                IStatusLineManager statusLine = DJUnitTestRunnerClient.this.getStatusLine();
                if (statusLine == null) {
                    return;
                }
                statusLine.setErrorMessage(null);
                statusLine.setMessage(message);
            }
        });
    }

    private void postAsyncRunnable(Runnable r) {
        this.getDisplay().syncExec(r);
    }

    private IStatusLineManager getStatusLine() {
        IEditorPart activeEditorPart;
        IEditorActionBarContributor contributor;
        IWorkbenchPart activePart = this.getWorkbenchWindow().getActivePage().getActivePart();
        if (activePart instanceof IViewPart) {
            IViewPart activeViewPart = (IViewPart)activePart;
            IViewSite activeViewSite = activeViewPart.getViewSite();
            return activeViewSite.getActionBars().getStatusLineManager();
        }
        if (activePart instanceof IEditorPart && (contributor = (activeEditorPart = (IEditorPart)activePart).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    private IWorkbenchWindow getWorkbenchWindow() {
        return PlatformUI.getWorkbench().getWorkbenchWindows()[0];
    }

    private Display getDisplay() {
        return this.getWorkbenchWindow().getShell().getDisplay();
    }

    private class ServerConnection
    extends Thread {
        int fPort;

        public ServerConnection(int port) {
            super("ServerConnection");
            this.fPort = port;
        }

        public void run() {
            try {
                String message;
                if (DJUnitTestRunnerClient.this.fDebug) {
                    System.out.println("Creating server socket " + this.fPort);
                }
                DJUnitTestRunnerClient.this.fServerSocket = new ServerSocket(this.fPort);
                DJUnitTestRunnerClient.this.fSocket = DJUnitTestRunnerClient.this.fServerSocket.accept();
                DJUnitTestRunnerClient.this.fBufferedReader = new BufferedReader(new InputStreamReader(DJUnitTestRunnerClient.this.fSocket.getInputStream()));
                DJUnitTestRunnerClient.this.fWriter = new PrintWriter(DJUnitTestRunnerClient.this.fSocket.getOutputStream(), true);
                while (DJUnitTestRunnerClient.this.fBufferedReader != null && (message = DJUnitTestRunnerClient.this.readMessage(DJUnitTestRunnerClient.this.fBufferedReader)) != null) {
                    DJUnitTestRunnerClient.this.receiveMessage(message);
                }
            }
            catch (SocketException socketException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            DJUnitTestRunnerClient.this.shutDown();
        }
    }
}

