/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.repository;

import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.repository.bean.NodeHostnameInfo;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportNode {
    private static Log log = LogFactory.getLog(ExportNode.class);

    public void exportNode() {
        log.info((Object)Messages.getMsg("Node.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getNodeList();
        if (arrayList2 instanceof ArrayList) {
            for (Object object2 : arrayList2) {
                Object[] objectArray = new Object[]{object2};
                log.info((Object)Messages.getMsg("FacilityID", objectArray));
                NodeInfo nodeInfo = this.getNode((String)object2);
                arrayList.add(this.createCsvFormat(nodeInfo));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        Object object = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            Object object2;
            object2 = new SimpleDateFormat("yyyyMMdd_HHmmss");
            object = "_" + ((DateFormat)object2).format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/NODE" + (String)object + ".csv", arrayList);
        log.info((Object)Messages.getMsg("Node.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    public ArrayList<String> createCsvFormat(NodeInfo nodeInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getStringValue(nodeInfo.getFacilityId()));
        arrayList.add(this.getStringValue(nodeInfo.getFacilityName()));
        arrayList.add(this.getStringValue(nodeInfo.getDescription()));
        arrayList.add(this.getStringValue(nodeInfo.getPlatformFamily()));
        arrayList.add(this.getStringValue(nodeInfo.getHardwareType()));
        arrayList.add(this.getStringValue(nodeInfo.getIconImage()));
        arrayList.add(this.getBooleanValue(nodeInfo.isValid()));
        arrayList.add(this.getIntegerValue(nodeInfo.getSnmpPort()));
        arrayList.add(this.getStringValue(nodeInfo.getSnmpCommunity()));
        String string = this.getStringValue(nodeInfo.getSnmpVersion());
        if (!string.equals(SnmpVersionConstant.STRING_V1) && !string.equals(SnmpVersionConstant.STRING_V2)) {
            string = "";
        }
        arrayList.add(string);
        arrayList.add(this.getIntegerValue(nodeInfo.getSnmpTimeout()));
        arrayList.add(this.getIntegerValue(nodeInfo.getSnmpRetryCount()));
        arrayList.add(this.getStringValue(nodeInfo.getSnmpProxy()));
        arrayList.add(this.getStringValue(nodeInfo.getWbemUser()));
        arrayList.add(this.getStringValue(nodeInfo.getWbemUserPassword()));
        arrayList.add(this.getIntegerValue(nodeInfo.getWbemPort()));
        arrayList.add(this.getStringValue(nodeInfo.getWbemProtocol()));
        arrayList.add(this.getIntegerValue(nodeInfo.getWbemTimeout()));
        arrayList.add(this.getIntegerValue(nodeInfo.getWbemRetryCount()));
        arrayList.add(this.getBooleanValue(nodeInfo.getDhcpClient()));
        arrayList.add(this.getIntegerValue(nodeInfo.getIpAddressType()));
        arrayList.add(this.getIntegerValue(nodeInfo.getIpAddressVersion()));
        arrayList.add(this.getStringValue(nodeInfo.getIpAddressV4()));
        arrayList.add(this.getStringValue(nodeInfo.getIpAddressV6()));
        ArrayList arrayList2 = nodeInfo.getNodeHostnameInfo();
        arrayList.add(this.getStringValue(((NodeHostnameInfo)arrayList2.get(0)).getHostname()));
        arrayList.add(this.getStringValue(nodeInfo.getNodeName()));
        arrayList.add(this.getStringValue(nodeInfo.getOsName()));
        arrayList.add(this.getStringValue(nodeInfo.getOsRelease()));
        arrayList.add(CheckString.checkReturn(this.getStringValue(nodeInfo.getOsVersion())));
        arrayList.add(this.getStringValue(nodeInfo.getCharacterSet()));
        arrayList.add(this.getStringValue(nodeInfo.getVirtualizationNodeType()));
        arrayList.add(this.getStringValue(nodeInfo.getVmManagementNode()));
        arrayList.add(this.getIntegerValue(nodeInfo.getVmIndex()));
        arrayList.add(this.getStringValue(nodeInfo.getVmName()));
        arrayList.add(this.getStringValue(nodeInfo.getVirtualizationSolution()));
        arrayList.add(this.getStringValue(nodeInfo.getVmId()));
        arrayList.add(this.getStringValue(nodeInfo.getVmUser()));
        arrayList.add(this.getStringValue(nodeInfo.getVmUserPassword()));
        arrayList.add(this.getStringValue(nodeInfo.getVmProtocol()));
        return arrayList;
    }

    public String getStringValue(String string) {
        return string;
    }

    public String getIntegerValue(Integer n) {
        return n.toString();
    }

    public String getBooleanValue(Boolean bl) {
        if (bl.booleanValue()) {
            return YesNoConstant.typeToString((int)1);
        }
        return YesNoConstant.typeToString((int)0);
    }

    protected NodeInfo getNode(String string) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        NodeInfo nodeInfo = null;
        try {
            nodeInfo = repositoryController.getNode(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return nodeInfo;
    }

    protected ArrayList getNodeList() {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        ArrayList arrayList = null;
        try {
            arrayList = repositoryController.getNodeFacilityIdList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

