/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.job;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.jobmanagement.bean.JobSchedule;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportSchedule {
    private static Log log = LogFactory.getLog(ExportSchedule.class);

    public void exportSchedule() {
        log.info((Object)Messages.getMsg("Job.Schedule.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getScheduleList();
        if (arrayList2 instanceof ArrayList) {
            for (Object object2 : arrayList2) {
                Object[] objectArray = new Object[]{object2.getId()};
                log.info((Object)Messages.getMsg("ScheduleID", objectArray));
                arrayList.add(this.createCsvFormat((JobSchedule)object2));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        Object object = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            Object object2;
            object2 = new SimpleDateFormat("yyyyMMdd_HHmmss");
            object = "_" + ((DateFormat)object2).format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/JOB_SCHEDULE" + (String)object + ".csv", arrayList);
        log.info((Object)Messages.getMsg("Job.Schedule.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    public ArrayList<String> createCsvFormat(JobSchedule jobSchedule) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(jobSchedule.getId());
        arrayList.add(jobSchedule.getName());
        arrayList.add(jobSchedule.getJobId());
        arrayList.add(jobSchedule.getJobName());
        arrayList.add(jobSchedule.getJobunitId());
        arrayList.add(jobSchedule.getCalendarId());
        arrayList.addAll(this.createSchedule(jobSchedule.getSchedule()));
        arrayList.add(ValidConstant.typeToString((int)jobSchedule.getValid()));
        return arrayList;
    }

    protected ArrayList<String> createSchedule(Schedule schedule) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (schedule.getType() == 4) {
            arrayList.add(com.clustercontrol.util.Messages.getString((String)"weekday"));
        } else {
            arrayList.add(com.clustercontrol.util.Messages.getString((String)"time"));
        }
        if (schedule.getDate() instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(schedule.getDate());
            DecimalFormat decimalFormat = new DecimalFormat("00");
            if (schedule.getType() == 0) {
                arrayList.add(decimalFormat.format(calendar.get(2) + 1));
                arrayList.add(decimalFormat.format(calendar.get(5)));
                arrayList.add(decimalFormat.format(calendar.get(11)));
                arrayList.add(decimalFormat.format(calendar.get(12)));
            } else if (schedule.getType() == 1) {
                arrayList.add("");
                arrayList.add(decimalFormat.format(calendar.get(5)));
                arrayList.add(decimalFormat.format(calendar.get(11)));
                arrayList.add(decimalFormat.format(calendar.get(12)));
            } else if (schedule.getType() == 2) {
                arrayList.add("");
                arrayList.add("");
                arrayList.add(decimalFormat.format(calendar.get(11)));
                arrayList.add(decimalFormat.format(calendar.get(12)));
            } else if (schedule.getType() == 3) {
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add(decimalFormat.format(calendar.get(12)));
            } else {
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
            }
            if (schedule.getType() == 4) {
                arrayList.add(DayOfWeekConstant.typeToString((int)schedule.getDayOfWeek()));
                arrayList.add(decimalFormat.format(calendar.get(11)));
                arrayList.add(decimalFormat.format(calendar.get(12)));
            } else {
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
            }
        } else {
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
        }
        return arrayList;
    }

    public String getStringValue(ArrayList arrayList, int n) {
        if (arrayList.size() > n - 1 && arrayList.get(n) instanceof String) {
            return (String)arrayList.get(n);
        }
        return "";
    }

    protected ArrayList getScheduleList() {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        ArrayList arrayList = null;
        try {
            arrayList = jobController.getScheduleList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

