/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common.virtualmock;

import jp.co.dgic.testing.common.virtualmock.IgnoreMethodValue;
import jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager;
import jp.co.dgic.testing.common.virtualmock.NullReturnValue;
import junit.framework.Assert;

public class MockObjectManager {
    public static void initialize() {
        InternalMockObjectManager.initialize();
    }

    public static void addReturnValue(String className, String methodName, Object returnValue) {
        InternalMockObjectManager.getTestData().put(MockObjectManager.makeKey(className, methodName), returnValue);
    }

    public static void addReturnValue(Class cls, String methodName, Object returnValue) {
        MockObjectManager.addReturnValue(cls.getName(), methodName, returnValue);
    }

    public static void addReturnValue(String className, String methodName) {
        MockObjectManager.addReturnValue(className, methodName, (Object)new IgnoreMethodValue());
    }

    public static void addReturnValue(Class cls, String methodName) {
        MockObjectManager.addReturnValue(cls.getName(), methodName);
    }

    public static void addReturnNull(String className, String methodName) {
        MockObjectManager.addReturnValue(className, methodName, (Object)new NullReturnValue());
    }

    public static void addReturnNull(Class cls, String methodName) {
        MockObjectManager.addReturnNull(cls.getName(), methodName);
    }

    public static void setReturnValueAt(String className, String methodName, int index, Object returnValue) {
        InternalMockObjectManager.getTestData().setAt(MockObjectManager.makeKey(className, methodName), index, returnValue);
    }

    public static void setReturnValueAt(Class cls, String methodName, int index, Object returnValue) {
        MockObjectManager.setReturnValueAt(cls.getName(), methodName, index, returnValue);
    }

    public static void setReturnValueAt(String className, String methodName, int index) {
        MockObjectManager.setReturnValueAt(className, methodName, index, (Object)new IgnoreMethodValue());
    }

    public static void setReturnValueAt(Class cls, String methodName, int index) {
        MockObjectManager.setReturnValueAt(cls.getName(), methodName, index);
    }

    public static void setReturnNullAt(String className, String methodName, int index) {
        MockObjectManager.setReturnValueAt(className, methodName, index, (Object)new NullReturnValue());
    }

    public static void setReturnNullAt(Class cls, String methodName, int index) {
        MockObjectManager.setReturnNullAt(cls.getName(), methodName, index);
    }

    public static void setReturnValueAtAllTimes(String className, String methodName, Object returnValue) {
        InternalMockObjectManager.getTestData().putValueAtAllTimes(MockObjectManager.makeKey(className, methodName), returnValue);
    }

    public static void setReturnValueAtAllTimes(Class cls, String methodName, Object returnValue) {
        MockObjectManager.setReturnValueAtAllTimes(cls.getName(), methodName, returnValue);
    }

    public static void setReturnValueAtAllTimes(String className, String methodName) {
        MockObjectManager.setReturnValueAtAllTimes(className, methodName, (Object)new IgnoreMethodValue());
    }

    public static void setReturnValueAtAllTimes(Class cls, String methodName) {
        MockObjectManager.setReturnValueAtAllTimes(cls.getName(), methodName);
    }

    public static void setReturnNullAtAllTimes(String className, String methodName) {
        MockObjectManager.setReturnValueAtAllTimes(className, methodName, (Object)new NullReturnValue());
    }

    public static void setReturnNullAtAllTimes(Class cls, String methodName) {
        MockObjectManager.setReturnNullAtAllTimes(cls.getName(), methodName);
    }

    public static Object getReturnValue(String className, String methodName) {
        return MockObjectManager.getReturnValue(MockObjectManager.makeKey(className, methodName));
    }

    public static Object getReturnValue(String classAndMethodName) {
        InternalMockObjectManager.printGetReturnValue(classAndMethodName);
        return InternalMockObjectManager.getTestData().get(classAndMethodName);
    }

    public static Object getReturnValue(Class cls, String methodName) {
        return MockObjectManager.getReturnValue(cls.getName(), methodName);
    }

    public static void assertCalled(String className, String methodName) {
        if (!MockObjectManager.isCalled(className, methodName)) {
            Assert.fail((String)("The method '" + methodName + "' in class '" + className + "' was expected to be called but it wasn't"));
        }
    }

    public static void assertCalled(Class cls, String methodName) {
        MockObjectManager.assertCalled(cls.getName(), methodName);
    }

    public static void assertNotCalled(String className, String methodName) {
        if (MockObjectManager.isCalled(className, methodName)) {
            Assert.fail((String)("The method '" + methodName + "' in class '" + className + "' was expected to be not called but it was"));
        }
    }

    public static void assertNotCalled(Class cls, String methodName) {
        MockObjectManager.assertNotCalled(cls.getName(), methodName);
    }

    public static int getCallCount(String className, String methodName) {
        return InternalMockObjectManager.getCallsMade().size(MockObjectManager.makeKey(className, methodName));
    }

    public static int getCallCount(Class cls, String methodName) {
        return MockObjectManager.getCallCount(cls.getName(), methodName);
    }

    public static Object getArgument(String className, String methodName, int argumentIndex) {
        return MockObjectManager.getArgument(className, methodName, 0, argumentIndex);
    }

    public static Object getArgument(Class cls, String methodName, int argumentIndex) {
        return MockObjectManager.getArgument(cls.getName(), methodName, argumentIndex);
    }

    public static Object getArgument(String className, String methodName, int methodIndex, int argumentIndex) {
        Object argument = null;
        Object[] arguments = (Object[])InternalMockObjectManager.getCallsMade().get(MockObjectManager.makeKey(className, methodName), methodIndex);
        if (arguments != null) {
            argument = arguments[argumentIndex];
        }
        return argument;
    }

    public static Object getArgument(Class cls, String methodName, int methodIndex, int argumentIndex) {
        return MockObjectManager.getArgument(cls.getName(), methodName, methodIndex, argumentIndex);
    }

    public static boolean isCalled(String className, String methodName) {
        return InternalMockObjectManager.getCallsMade().get(MockObjectManager.makeKey(className, methodName)) != null;
    }

    public static boolean isCalled(Class cls, String methodName) {
        return MockObjectManager.isCalled(cls.getName(), methodName);
    }

    public static void assertArgumentPassed(String className, String methodName, int argumentIndex, Object argumentValue) {
        Object argument = MockObjectManager.getArgument(className, methodName, argumentIndex);
        if (argument == null && argumentValue == null) {
            return;
        }
        if (argument == null || !argument.equals(argumentValue)) {
            Assert.fail((String)("The argument index[" + argumentIndex + "] of method '" + methodName + "' in class '" + className + "' should have the value '" + argumentValue + "' but it was '" + argument + "'!"));
        }
    }

    public static void assertArgumentPassed(Class cls, String methodName, int argumentIndex, Object argumentValue) {
        MockObjectManager.assertArgumentPassed(cls.getName(), methodName, argumentIndex, argumentValue);
    }

    private static String makeKey(String className, String methodName) {
        return String.valueOf(className) + "." + methodName;
    }
}

