/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common;

import jp.co.dgic.testing.common.AbstractBcelModifier;
import jp.co.dgic.testing.common.util.DJUnitUtil;
import jp.co.dgic.testing.common.virtualmock.VirtualMockUtil;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;

public abstract class AbstractBcelImplementer
extends AbstractBcelModifier {
    protected static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    protected static final String MANAGER_PACKAGE_NAME = "jp.co.dgic.testing.common.virtualmock.";
    protected static final String MANAGER_CLASS_NAME = "jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager";

    public AbstractBcelImplementer(String name) {
        super(name);
    }

    protected boolean isConstructor(MethodGen mg) {
        return this.isConstructor(mg.getName());
    }

    protected boolean isConstructor(String methodName) {
        return CONSTRUCTOR_METHOD_NAME.equals(methodName);
    }

    protected boolean isSuperOrThis(ClassGen cg, MethodGen mg) {
        return this.isSuperOrThis(cg, mg.getClassName(), mg.getName());
    }

    protected boolean isSuperOrThis(ClassGen cg, String className, String methodName) {
        if (!this.isConstructor(methodName)) {
            return false;
        }
        String superClassName = cg.getSuperclassName();
        if (superClassName.equals(className)) {
            return true;
        }
        return cg.getClassName().equals(className);
    }

    protected boolean isAfterDup(int index, InstructionHandle[] handles) {
        if (index == 0) {
            return false;
        }
        short op = 0;
        int i = index - 1;
        while (i >= 0) {
            op = handles[i].getInstruction().getOpcode();
            if (op == 89 || op == 90) {
                return true;
            }
            if (op == 187) break;
            --i;
        }
        return false;
    }

    protected boolean isPrimitive(Type type) {
        if (Type.BOOLEAN.equals((Object)type)) {
            return true;
        }
        if (Type.BYTE.equals((Object)type)) {
            return true;
        }
        if (Type.CHAR.equals((Object)type)) {
            return true;
        }
        if (Type.DOUBLE.equals((Object)type)) {
            return true;
        }
        if (Type.FLOAT.equals((Object)type)) {
            return true;
        }
        if (Type.INT.equals((Object)type)) {
            return true;
        }
        if (Type.LONG.equals((Object)type)) {
            return true;
        }
        return Type.SHORT.equals((Object)type);
    }

    protected String toWrapperType(Type type) {
        if (Type.BOOLEAN.equals((Object)type)) {
            return "java.lang.Boolean";
        }
        if (Type.BYTE.equals((Object)type)) {
            return "java.lang.Byte";
        }
        if (Type.CHAR.equals((Object)type)) {
            return "java.lang.Character";
        }
        if (Type.DOUBLE.equals((Object)type)) {
            return "java.lang.Double";
        }
        if (Type.FLOAT.equals((Object)type)) {
            return "java.lang.Float";
        }
        if (Type.INT.equals((Object)type)) {
            return "java.lang.Integer";
        }
        if (Type.LONG.equals((Object)type)) {
            return "java.lang.Long";
        }
        if (Type.SHORT.equals((Object)type)) {
            return "java.lang.Short";
        }
        return "java.lang.Object";
    }

    protected boolean isTwoEntryType(Type type) {
        return "long".equals(type.toString()) || "double".equals(type.toString());
    }

    protected JavaClass findOwnerClass(MethodGen mg, String className, String methodName, String signature) throws ClassNotFoundException {
        if (DJUnitUtil.isDJUnitSystemClass(className)) {
            return null;
        }
        if (DJUnitUtil.isDefaultExcludedPath(className)) {
            return null;
        }
        JavaClass jc = Repository.lookupClass((String)className);
        return this.findOwnerClass(jc, methodName, signature);
    }

    protected JavaClass findOwnerClass(JavaClass jc, String methodName, String signature) throws ClassNotFoundException {
        if (jc == null) {
            return null;
        }
        if (!this.isOwnSource(jc.getClassName())) {
            return jc;
        }
        ClassGen cg = new ClassGen(jc);
        Method method = cg.containsMethod(methodName, signature);
        if (method != null) {
            return jc;
        }
        if ("java.lang.Object".equals(jc.getClassName())) {
            return null;
        }
        return this.findOwnerClass(jc.getSuperClass(), methodName, signature);
    }

    protected boolean isSuperClass(String className, String superClassName) throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass((String)className);
        return jc.getSuperClass().getClassName().equals(superClassName);
    }

    protected boolean isOwnSource(String className) {
        if (VirtualMockUtil.getIncludeValue() != null && VirtualMockUtil.isInclude(className)) {
            return true;
        }
        return DJUnitUtil.isProjectsSource(className);
    }

    protected InstructionList createCreateArgsArray(MethodGen mg, Type[] argTypes, boolean isStatic, int varStartIndex, InstructionFactory ifactory) {
        InstructionList il = new InstructionList();
        int argLength = argTypes.length;
        il.append((CompoundInstruction)new PUSH(ifactory.getConstantPool(), argLength));
        il.append(ifactory.createNewArray((Type)Type.OBJECT, (short)1));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        int varIndex = varStartIndex;
        if (!isStatic) {
            ++varIndex;
        }
        Type argType = null;
        String wrapperTypeName = null;
        int i = 0;
        while (i < argLength) {
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
            il.append((CompoundInstruction)new PUSH(ifactory.getConstantPool(), i));
            argType = argTypes[i];
            if (this.isPrimitive(argType)) {
                wrapperTypeName = this.toWrapperType(argType);
                il.append((Instruction)ifactory.createNew(wrapperTypeName));
                il.append((Instruction)InstructionConstants.DUP);
                il.append((Instruction)InstructionFactory.createLoad((Type)argType, (int)varIndex));
                il.append((Instruction)ifactory.createInvoke(wrapperTypeName, CONSTRUCTOR_METHOD_NAME, (Type)Type.VOID, new Type[]{argType}, (short)183));
                if (this.isTwoEntryType(argType)) {
                    ++varIndex;
                }
            } else {
                il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)varIndex));
            }
            ++varIndex;
            il.append((Instruction)InstructionConstants.AASTORE);
            ++i;
        }
        return il;
    }

    protected InstructionList createPutArgsIntoStackFromLocalValriables(MethodGen mg, boolean isStatic, InvokeInstruction ii, InstructionFactory ifactory) {
        InstructionList il = new InstructionList();
        int argLength = ii.getArgumentTypes(ifactory.getConstantPool()).length;
        int argIndex = mg.getMaxLocals() + 1;
        if (!isStatic) {
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)argIndex));
            ++argIndex;
        }
        int idx = 0;
        while (idx < argLength) {
            il.append((Instruction)InstructionFactory.createLoad((Type)ii.getArgumentTypes(ifactory.getConstantPool())[idx], (int)argIndex));
            if (this.isTwoEntryType(ii.getArgumentTypes(ifactory.getConstantPool())[idx])) {
                ++argIndex;
            }
            ++argIndex;
            ++idx;
        }
        if (il.isEmpty()) {
            il.append((Instruction)new NOP());
        }
        return il;
    }

    protected InstructionList createCopyStackArgsToLocalVariables(MethodGen mg, boolean isStatic, InvokeInstruction ii, InstructionFactory ifactory) {
        InstructionList il = new InstructionList();
        int argLength = ii.getArgumentTypes(ifactory.getConstantPool()).length;
        int argIndex = mg.getMaxLocals() + argLength;
        argIndex += this.getTwoEntryTypeCount(ii.getArgumentTypes(ifactory.getConstantPool()));
        if (!isStatic) {
            ++argIndex;
        }
        int idx = argLength - 1;
        while (idx >= 0) {
            if (this.isTwoEntryType(ii.getArgumentTypes(ifactory.getConstantPool())[idx])) {
                --argIndex;
            }
            il.append((Instruction)InstructionFactory.createStore((Type)ii.getArgumentTypes(ifactory.getConstantPool())[idx], (int)argIndex));
            --argIndex;
            --idx;
        }
        if (!isStatic) {
            il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)argIndex));
        }
        return il;
    }

    protected int getTwoEntryTypeCount(Type[] argTypes) {
        if (argTypes == null) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < argTypes.length) {
            if (this.isTwoEntryType(argTypes[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    protected int getIndexOfNewOpcode(int index, InstructionHandle[] handles) {
        if (index == 0) {
            return -1;
        }
        InstructionHandle h = null;
        int i = index - 1;
        while (i >= 0) {
            h = handles[i];
            if (h.getInstruction().getOpcode() == 187) {
                return i;
            }
            --i;
        }
        return -1;
    }

    protected InstructionHandle findSuperOrThis(ClassGen cg, MethodGen mg, InstructionList il, ConstantPoolGen cpg) {
        InstructionHandle[] handles = il.getInstructionHandles();
        int i = 0;
        while (i < handles.length) {
            String methodName;
            String className;
            if (handles[i].getInstruction() instanceof InvokeInstruction && this.isSuperOrThis(cg, className = ((InvokeInstruction)handles[i].getInstruction()).getClassName(cpg), methodName = ((InvokeInstruction)handles[i].getInstruction()).getMethodName(cpg)) && handles[i].getInstruction().getOpcode() == 183) {
                return handles[i];
            }
            ++i;
        }
        return null;
    }
}

