/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.coverage.report;

import jp.co.dgic.eclipse.jdt.internal.coverage.report.ICoverageLabel;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class ColumnNameLabel
extends CLabel
implements ICoverageLabel {
    private static final int STYLE;
    private boolean isTail;
    private static final String FONT_NAME = "Franklin Gothic Medium";
    private static final int FONT_SIZE = 10;
    private static final int FONT_STYLE = 0;
    private static final RGB RGB_BACKGROUND;
    private static final RGB RGB_LINE;

    static {
        String osName = System.getProperty("os.name");
        STYLE = osName != null && osName.toLowerCase().indexOf("linux") >= 0 ? 0 : 0x1000000;
        RGB_BACKGROUND = new RGB(220, 236, 255);
        RGB_LINE = new RGB(170, 186, 205);
    }

    public ColumnNameLabel(Composite parent) {
        this(parent, false);
    }

    public ColumnNameLabel(Composite parent, boolean isTail) {
        super(parent, STYLE);
        this.isTail = isTail;
        this.setFont(new Font((Device)this.getDisplay(), new FontData(FONT_NAME, 10, 0)));
        this.setBackground(new Color((Device)this.getDisplay(), RGB_BACKGROUND));
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ColumnNameLabel.this.draw(e.gc);
            }
        });
    }

    private void draw(GC gc) {
        gc.setForeground(new Color((Device)this.getDisplay(), RGB_LINE));
        Rectangle r = this.getBounds();
        int[] nArray = new int[8];
        nArray[0] = r.width;
        nArray[5] = r.height - 1;
        nArray[6] = r.width;
        nArray[7] = r.height - 1;
        int[] pointArray = nArray;
        gc.drawPolyline(pointArray);
        if (this.isTail) {
            gc.drawLine(r.width - 1, 0, r.width - 1, r.height - 1);
        }
    }

    protected void checkSubclass() {
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.getSize();
    }

    public void setLineNumber(int lineNumber) {
    }
}

