/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.repository;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.repository.bean.FacilityInfo;
import com.clustercontrol.repository.bean.ScopeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportScope {
    private static Log log = LogFactory.getLog(ExportScope.class);

    public void exportScope() {
        log.info((Object)Messages.getMsg("Scope.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        FacilityTreeItem facilityTreeItem = this.getFacilityTree();
        this.getFacilityTreeItem(facilityTreeItem, arrayList);
        Collections.sort(arrayList, new StringListComparator(0));
        String string = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            string = "_" + simpleDateFormat.format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/SCOPE" + string + ".csv", arrayList);
        log.info((Object)Messages.getMsg("Scope.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    public void getFacilityTreeItem(FacilityTreeItem facilityTreeItem, ArrayList<ArrayList<String>> arrayList) {
        FacilityTreeItem[] facilityTreeItemArray;
        if (facilityTreeItem.getData() instanceof FacilityInfo && (facilityTreeItemArray = facilityTreeItem.getData()).getFacilityId() != null && facilityTreeItemArray.getFacilityId().compareTo("") != 0 && facilityTreeItemArray.getFacilityType() == 0) {
            FacilityInfo facilityInfo;
            Object[] objectArray = new Object[]{facilityTreeItemArray.getFacilityId()};
            log.info((Object)Messages.getMsg("FacilityID", objectArray));
            ScopeInfo scopeInfo = this.getScope(facilityTreeItemArray.getFacilityId());
            ArrayList<String> arrayList2 = this.createCsvFormat(scopeInfo);
            Object object = "";
            if (facilityTreeItem.getParent() != null && facilityTreeItem.getParent().getData() instanceof FacilityInfo && (facilityInfo = facilityTreeItem.getParent().getData()).getFacilityId() != null && facilityInfo.getFacilityId().compareTo("") != 0) {
                object = facilityInfo.getFacilityId();
            }
            arrayList2.add((String)object);
            arrayList.add(arrayList2);
        }
        facilityTreeItemArray = facilityTreeItem.getChildren();
        for (Object object : facilityTreeItemArray) {
            this.getFacilityTreeItem((FacilityTreeItem)object, arrayList);
        }
    }

    public ArrayList<String> createCsvFormat(ScopeInfo scopeInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getStringValue(scopeInfo.getFacilityId()));
        arrayList.add(this.getStringValue(scopeInfo.getFacilityName()));
        arrayList.add(this.getStringValue(scopeInfo.getDescription()));
        return arrayList;
    }

    public String getStringValue(String string) {
        return string;
    }

    protected ScopeInfo getScope(String string) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        ScopeInfo scopeInfo = null;
        try {
            scopeInfo = repositoryController.getScopeProperty(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return scopeInfo;
    }

    protected FacilityTreeItem getFacilityTree() {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        FacilityTreeItem facilityTreeItem = null;
        try {
            facilityTreeItem = repositoryController.getFacilityTree(Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return facilityTreeItem;
    }
}

