/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.master.mib;

import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.co.intellilink.hinemos.importtool.master.mib.TrapFactory;
import jp.co.intellilink.hinemos.importtool.master.mib.TrapV1Factory;
import jp.co.intellilink.hinemos.importtool.master.mib.TrapV2Factory;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpNotificationType;
import net.percederberg.mibble.snmp.SnmpTrapType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrapsFactory {
    private TrapFactory v1Factory = new TrapV1Factory();
    private TrapFactory v2Factory = new TrapV2Factory();

    public List<SnmpTrapMasterInfo> create(Mib mib) {
        if (mib == null) {
            return null;
        }
        ArrayList<SnmpTrapMasterInfo> arrayList = new ArrayList<SnmpTrapMasterInfo>();
        Collection collection = mib.getAllSymbols();
        for (MibSymbol mibSymbol : collection) {
            if (!(mibSymbol instanceof MibValueSymbol)) continue;
            SnmpTrapMasterInfo snmpTrapMasterInfo = null;
            if (mibSymbol.getMib().getSmiVersion() == 1) {
                if (((MibValueSymbol)mibSymbol).getType() instanceof SnmpTrapType) {
                    snmpTrapMasterInfo = this.v1Factory.create(mibSymbol);
                }
            } else if (mibSymbol.getMib().getSmiVersion() == 2 && ((MibValueSymbol)mibSymbol).getType() instanceof SnmpNotificationType) {
                snmpTrapMasterInfo = this.v2Factory.create(mibSymbol);
            }
            if (!(snmpTrapMasterInfo instanceof SnmpTrapMasterInfo)) continue;
            snmpTrapMasterInfo.setMib(mib.getName());
            snmpTrapMasterInfo.setPriority(0);
            arrayList.add(snmpTrapMasterInfo);
        }
        return arrayList;
    }
}

