/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.check.conf;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.hinemosagent.ejb.session.MonitorAgentController;
import com.clustercontrol.monitor.run.bean.MonitorInfo;

/**
 * エージェント監視情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CheckMonitorAgent extends CheckMonitor {

	// ログ出力
	private static Log log = LogFactory.getLog(CheckMonitorAgent.class);

	/**
	 * エージェント監視の監視項目数、ノード数、通知数を取得する。<br>
	 */
	@SuppressWarnings("unchecked")
	public ArrayList<String> checkAgent() {
		log.info(Messages.getMsg("Agent.Start", new String[]{""}));

		//監視項目リスト取得
		ArrayList idList = getAgentList();
		setIdList(idList);

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				MonitorInfo info = (MonitorInfo)itr.next();

				Object[] args = {info.getMonitorId()};
				log.info(Messages.getMsg("MonitorID", args));

				int nodeCount = getNodeCount(info);
				int notifyCount = getNotifyCount(info);

				addNodeTotalCount(nodeCount);
				addNotifyTotalCount(nodeCount * notifyCount);
			}
		}

		log.info(Messages.getMsg("Agent.End", new String[]{""}));

		return createOutput("Agent");
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getAgentList() {

		MonitorAgentController agent = EjbConnectionManager.getConnectionManager().getMonitorAgentController();

		ArrayList records = null;
		try {
			records = agent.getAgentList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}