var TimerWidgetClass = function(manager, args)
{
	TimerWidgetClass.base.apply(this, arguments);
	this.manager = manager;
	
	this.size = new Point2D(128, 24);
	this.origin = new Point2D(5, 5);

	
	this.wBox = null;

	this.manager.warnType = 0;
	
}.extend(WidgetClass, {
	attach : function(){
		var element = document.createElement('div');
		with(element)
		{
			style.position = "absolute";
			style.bottom = this.origin.y + "px";
			style.left = this.origin.x + "px";
			style.textShadow = "0px 0px 5px black";
			style.fontSize = "18px";
			style.zIndex = 100;
		}
		this.manager.mainArea.appendChild(element);
		this.wBox = element;
	},
	detach : function()
	{
		if(this.wBox)
		{
			this.manager.mainArea.removeChild(this.wBox);
		}
	},
	tick : function()
	{
		if(this.manager.timerRunning)
		{
			var past = (+new Date()) - this.manager.startTimeStamp;
			if(past > this.manager.gameTime)
			{
				this.manager.timerRunning = false;
				var that = this;
				var w = new MessageWidgetClass(this.manager,["時間切れです！\n", null, function(){
					document.location.href = URL_PCD_Root + "ranking.php?name=" + encodeURIComponent(that.manager.userManager.getUserNameByUID(that.manager.userID)) + "&score=" + that.manager.userManager.getSumPoint();
				}])
				w.cancelKeyEnabled = false;
				this.manager.addWidget(w);
			}else
			{
				var rate = past / this.manager.gameTime;
				
				if(rate < 0.8)
				{
					this.warnType = 0;
				}else if(rate < 0.95)
				{
					this.warnType = 1;
				}else
				{
					this.warnType = 2;
				}
			}
		}
		return true;
	},
	draw : function(){
		
		
		
		var time = this.manager.gameTime - ((+new Date()) - this.manager.startTimeStamp);
		var min = Math.floor(time / (60 * 1000));
		var sec = Math.floor((time - (min * 60 * 1000)) / 1000);
		var msec = (time - (min * 60 * 1000) - (sec * 1000));

		this.wBox.style.color = this.warnType == 0 ? "lime" : (this.warnType == 1 ? "yellow" : "red");
		if(time >= 0)
		{
			this.wBox.innerText = "残り時間 " +  min + ":" + sec + ":" + msec;
		}else
		{
			this.wBox.innerText = "";
		}
	}
});

TimerWidgetClass.startTimer = function(manager)
{
	manager.timerRunning = true;
	manager.startTimeStamp = (+new Date());
};
