var PickedItemWidgetClass = function(manager, args)
{
	PickedItemWidgetClass.base.apply(this, arguments);
	this.manager = manager;
	
	this.size = new Point2D(256, 32);
	this.origin = new Point2D(5, 5);
	
	this.updateInterval = 10;
	this.updateCount = 999;
	
	this.wBox = null;
}.extend(WidgetClass, {
	attach : function(){},
	update: function(){
		if(this.wBox != null)
		{
			this.manager.mainArea.removeChild(this.wBox);
		}
		var element = document.createElement('div');
		with(element)
		{
			style.top = this.origin.y + "px";
			style.left = this.origin.x + "px";
			style.width = this.size.x + "px";
			style.height = this.size.y + "px";
			style.overflow = "hidden";
			style.position = "absolute";
			style.zIndex = "500";
		}
		
		var maxItems = Math.floor(this.size.x / this.size.y);
		var items = this.manager.userManager.ingredientList;
		var showDots = false;
		if(maxItems < items.length)
		{
			maxItems--;
			showDots = true;
		}
		
		var xloc = 0;
		for(var i = 0; i < maxItems && i < items.length; i++)
		{
			var img = document.createElement('img');
			with(img)
			{
				style.position = "absolute";
				style.top = "0px";
				style.left = xloc + "px";
				style.width = this.size.y + "px";
				style.height = this.size.y + "px";
				src = "images/" + items[i].value;
			}
			element.appendChild(img);
			xloc += this.size.y;
		}
		
		if(showDots)
		{
			var div = document.createElement('div');
			with(div)
			{
				style.position = "absolute";
				style.top = "0px";
				style.left = xloc + "px";
				style.width = this.size.y + "px";
				style.height = this.size.y + "px";
			}
			div.innerText = "...";
			element.appendChild(div);
		}
		this.manager.mainArea.appendChild(element);
		this.wBox = element;
	},
	detach : function()
	{
		if(this.wBox != null)
		{
			this.manager.mainArea.removeChild(this.wBox);
		}
	},
	tick : function()
	{
		this.updateCount++;
		if(this.updateCount > this.updateInterval)
		{
			this.update();
			this.updateCount = 0;
		}
		return true;
	}
});

