var MainCharacterClass = function(stage, args, isFromNetwork){
	MainCharacterClass.base.apply(this);
	this.create(stage, args);
	if(stage){
		if(!isFromNetwork){
			this.ownerUID = stage.manager.userID;
			stage.userControlledCharacter = this;
			stage.addStageObject(this, true);
		} else{
			stage.addStageObject(this, true, true);
		}
	}
	
	// 攻撃を受けた際などに一時的に無敵モードになるように
	// これがないと攻撃を受けたことが分かりにくくなる
	this.isDamageDefenseMode = false;
	this.damageDefenseModeTimeStamp = 0;
	this.damageDefenseModeLong = 500;
	
	// 探し回ってしまった。こんな時間の無駄を今後はしないようにするため記述しておく
	this.max_HP = 100;
	this.HP = 100;
	//this.isPhantom = true;
}.extend(OperatedCharacterClass, {
	className: "MainCharacterClass",
	create: function(stage, args){
		MainCharacterClass.base.apply(this, arguments);
		this.max_HP = 100;
		this.HP = this.max_HP;
	},
	tick : function()
	{
		if(this.isDamageDefenseMode)
		{
			if((+new Date()) > this.damageDefenseModeTimeStamp + this.damageDefenseModeLong)
			{
				this.isDamageDefenseMode = false;
			}
		}
		MainCharacterClass.base.prototype.tick.apply(this);
		if((!mainManager.runningStageName || this.ownerStage.manager.userID == this.ownerUID) && this.origin.y > 1000){
			this.kill();
		}
	},
	damage: function(p){
		if(!this.isDamageDefenseMode)
		{
			if(this.HP <= p){
				
				this.kill();
			} else{
				this.HP -= p;
			}
			this.isDamageDefenseMode = true;
			this.damageDefenseModeTimeStamp = (+new Date());
		}
	},
	heal: function(p){
		if(this.HP + p > this.max_HP){
			this.HP = this.max_HP;
		} else{
			this.HP += p;
		}
	},
	kill: function(){
		this.HP = 0;
		//終了処理および再読み込みはmainManager側で行われる。
	},
	draw: function(x, y){
		
		if(!this.isDamageDefenseMode || (+new Date()) % 200 < 100)
		{
			//自分を描画
			MainCharacterClass.base.prototype.draw.apply(this, [x, y]);
		}
		
		if(this != this.ownerStage.userControlledCharacter)
		{
			this.ownerStage.mainContext.save();
			var color = "green";
			var backColor = "gray";
			var thickness = 4;
			var barWidth = this.max_HP;
			if(barWidth < 16) barWidth = 16;
			if(barWidth > this.size.x) barWidth = this.size.x;
			var barPerHP = this.HP / this.max_HP;
			
			if(barPerHP < 0.2)
			{
				var backColor = "red";
			}else if(barPerHP < 0.4)
			{
				var backColor = "yellow";
			}
			
			this.ownerStage.mainContext.fillStyle = backColor;
			this.ownerStage.mainContext.fillRect(x + (this.size.x - barWidth) / 2, y - thickness, barWidth, thickness);
			this.ownerStage.mainContext.fillStyle = color;
			this.ownerStage.mainContext.fillRect(x + (this.size.x - barWidth) / 2, y - thickness, barWidth * barPerHP, thickness);
			
			this.ownerStage.mainContext.restore();
		}
	},
	canMoveTo: function(x, y){
		//すべてのオブジェクトに対して(x, y)にあるときの自分の衝突状態を調べる。
		var retv = true;
		var d = this.ownerStage.stageObjectLinearList;
		
		this.onLadder = false;
		for(var i = 0, i_max = d.length; i < i_max; i++){
			var f = d[i];
			if(f !== this && !(f instanceof MainCharacterClass)){
				//自分でない
				if(f.isOverlappedWithLocatedObject(this, x, y)){
					//衝突先fの衝突範囲内にいる
					if(this.isItemCollector){
						//衝突先fを取得したアイテムに加える。
						var titem = null;
						for(titem in this.collectedItems){
							//複数追加の防止
							if(titem == f){
								break;
							}
						}
						if(titem != f){
							this.collectedItems.push(f);
							if(f instanceof LadderBlockClass){
								this.onLadder = true;
							}
						}
					}
					if(f.isPhantom){
						//衝突先fが衝突判定無視だったら、衝突はしない
					} else{
						//衝突した
						retv = false;
						//break;
					}
					
				}
			}
		}
		return retv;
	},
});

/*
MainCharacterClass.createCharacter = function(stage, args)
{
	var id = stage.manager.userManager.characterId;
	if(id == 0)
	{
		return new MainCharacterClass_Hunter(stage, args);
	}else if(id == 1)
	{
		return new MainCharacterClass_Man(stage, args);
	}else if(id == 2)
	{
		return new MainCharacterClass_NakedMan(stage, args);
	}else if(id == 3)
	{
		return new MainCharacterClass_Thief(stage, args);
	}else if(id == 4)
	{
		return new MainCharacterClass_Witch(stage, args);
	}else
	{
		return new MainCharacterClass_Woman(stage, args);
	}
};
*/

