
var HorizonalScrollStageClass = function()
{
	HorizonalScrollStageClass.base.apply(this, []);

	this.scrollX = 0;
	this.scrollMaxX =1280 - 640;	//Xe[W̉̒-640
	
}.extend(GameStage, {
	className: "HorizonalScrollStageClass",
	timerTick: function(){

		HorizonalScrollStageClass.base.prototype.timerTick.call(this);
		if(this.userControlledCharacter){
			//LN^[ǔ
			this.scrollTo(this.getScrollLocation());
		}
	},
	
	// qXe[WŁA쒆LȊO𒆐SɎĂƂ͂̊֐I[o[Ch
	getScrollLocation: function(){
		var pos = 0;
		if(this.userControlledCharacter){
			return this.userControlledCharacter.origin.x - 320;
		}
		
		return 0;
	},
	draw: function(){
		this.drawBackground();
		this.drawAsPoint(this.scrollX, 0);
		if(this.waterLevel){
			this.drawWater();
		}
	},
	drawBackground: function(){
		if(this.background){
			//ʈʒuɍ킹ĉ摜XN[\
			var width = this.background.width;
			var pos = -((this.scrollX / 2) % width);
			for(;pos < this.background.width; pos += width)
			{
				this.mainContext.drawImage(this.background, pos, 0, this.background.width, this.background.height);
			}
		} else{
			//LoXS
			this.mainContext.clearRect(0, 0, this.mainCanvas.width, this.mainCanvas.height);
		}
		if(this.collisionMapContext){
			this.collisionMapContext.clearRect(0, 0, this.collisionMapCanvas.width, this.collisionMapCanvas.height);
		}
	},
	
	//XN[ƂɁAtickɌĂԁB
	scrollTo: function(x){
		this.scrollX += (x - this.scrollX) / 7;
		if(this.scrollX > this.scrollMaxX){
			this.scrollX = this.scrollMaxX;
		}
		if(this.scrollX < 0){
			this.scrollX = 0;
		}
	}
});

