﻿var BreadItemWidgetClass = function(manager, args)
{
	BreadItemWidgetClass.base.apply(this, arguments);
	this.manager = manager;
	
	this.size = new Point2D(320, 32);
	this.origin = new Point2D(5, 37);
	
	this.updateInterval = 10;
	this.updateCount = 999;
	this.wBox = null;
	
	this.selectedBorder = "3px orange solid";
	
	this.numberKeyPressed = [false, false, false, false, false, false, false, false, false, false];
	this.selectedIndex = -1;	//Selected Bread
	this.elementList = [];
	
	manager.breadItemWidget = this;
	
}.extend(WidgetClass, {
	generateBreadImage: function(score){
		if(score <= 0)
		{
			return "burntbread.png";
		}
		if(score <=10)
		{
			return "KOPPE.png";
		}else if(score <=20)
		{
			return "bread.png";
		}else if(score <= 40)
		{
			return "curypan.png";
		}else
		{
			return "crosand.png";
		}
	},
	attach : function(){},
	update: function(){
		if(this.wBox != null)
		{
			this.manager.mainArea.removeChild(this.wBox);
		}
		var element = document.createElement('div');
		with(element)
		{
			style.top = this.origin.y + "px";
			style.left = this.origin.x + "px";
			style.width = this.size.x + "px";
			style.height = this.size.y + "px";
			//style.overflow = "hidden";
			style.position = "absolute";
			style.zIndex = "500";
		}
		
		var maxItems = 10;
		var items = this.manager.userManager.breadList;
		
		var xloc = 0;
		this.elementList = [];
		for(var i = 0; i < maxItems && i < items.length; i++)
		{
			var img = document.createElement('img');
			with(img)
			{
				style.position = "absolute";
				style.top = "0px";
				style.left = xloc + "px";
				style.width = this.size.y + "px";
				style.height = this.size.y + "px";
				src = "images/" + BreadItemWidgetClass.prototype.generateBreadImage(items[i]);
				//src = "images/012.png";
				style.borderRadius = "4px";
			}
			if(i == this.selectedIndex)
			{
				img.style.border = this.selectedBorder;
			}
			element.appendChild(img);
			var div = document.createElement('div');
			with(div)
			{
				style.position = "absolute";
				style.top = this.size.y + "px";
				style.left = xloc + "px";
				style.width = this.size.y + "px";
				style.height = this.size.y + "px";
				style.textAlign = "center";
			}
			var k = i + 1;
			if(k == 10) k = 0;
			div.innerText = k;
			element.appendChild(div);
			var div2 = document.createElement('div');
			with(div2)
			{
				style.position = "absolute";
				style.bottom = "0px";
				style.left = xloc + "px";
				style.width = this.size.y + "px";
				style.textAlign = "center";
			}
			div2.innerText = items[i] + "pt";
			element.appendChild(div2);
			
			xloc += this.size.y;
			this.elementList.push(div);
		}

		this.manager.mainArea.appendChild(element);
		this.wBox = element;
	},
	detach : function()
	{
		if(this.wBox != null)
		{
			this.manager.mainArea.removeChild(this.wBox);
		}
	},
	tick : function()
	{
		this.updateCount++;
		if(this.updateCount > this.updateInterval)
		{
			this.update();
			this.updateCount = 0;
		}
		
		for(var i = 0; i < 10; i++)
		{
			if(this.manager.UIManager.keyState.numbers[i])
			{
				if(!this.numberKeyPressed[i])
				{
					var k = i - 1;
					if(k == -1) k = 9;
					this.keyPressed(k);
					this.numberKeyPressed[i] = true;
				}
			}else
			{
				this.numberKeyPressed[i] = false;
			}
		}
		
		return true;
	},
	keyPressed : function(index)
	{
		if(index < this.elementList.length)
		{
			this.selectedIndex = index;
		}else
		{
			showAlert(this.manager, "そのキーに武器は割り当てられていません");
		}
	},
	getLastSelectedBreadIndex : function()
	{
		if(this.selectedIndex == -1) return -1;
		var items = this.manager.userManager.breadList;
		var score = this.manager.userManager.breadList[this.selectedIndex];
		this.manager.userManager.breadList.splice(this.selectedIndex, 1);
		this.selectedIndex = -1;
		return score;
	}
});

