/**
 *  ProcessBlock
 *
 *  Copyright (C) 2006-2014 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __ProcessBlock_H
#define __ProcessBlock_H

#define VENDOR_STRING "Teru Kamogashira"

#include <new>
#include <audioeffectx.h>
#include <freeverb/slot.hpp>

#include "Locker.hpp"
#include "XMLConfig.hpp"

#ifdef WIN32
#include <windows.h>
#include <process.h>
#else
#include <unistd.h>
#include <pthread.h>
#include <freeverb/fv3_pthread_tool.hpp>
#endif

#ifdef WIN32
#define ALIGN_ARG_POINTER __attribute__((force_align_arg_pointer))
#else
#define ALIGN_ARG_POINTER
#endif

#ifdef PLUGDOUBLE
typedef fv3::slot_ SLOT;
typedef fv3::utils_ UTILS;
typedef double pfloat_t;
#else
typedef fv3::slot_f SLOT;
typedef fv3::utils_f UTILS;
typedef float pfloat_t;
#endif

#ifdef WIN32
#define PB3_EVENT_PREFIX L"PB3_EVENT"
#define PB3_EVENT_START L"START"
#define PB3_EVENT_ENDED L"ENDED"
#endif
#define PB3_THREAD_FLAG_0        (0U)
#define PB3_THREAD_FLAG_EXIT     (1U << 1)
#define PB3_THREAD_FLAG_RUN_HALF (1U << 2)
#define PB3_THREAD_FLAG_RUN_FULL (1U << 3)

class ProcessBlock;
typedef struct {
  ProcessBlock *hostClass;
  long *latencySize;
  SLOT *inputBlock, *outputBlock;
  volatile int *threadFlags;
  Locker * mainSection;
#ifndef WIN32
  PthreadEvent *threadStart, *threadEnded;
#endif
} ProcessBlockThreadInfo;

class ProcessBlock
{
public:
  ProcessBlock();
  virtual ~ProcessBlock();
  void p_process(float **inputs, float **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
  void p_processReplacing(float **inputs, float **outputs, VstInt32 sampleFrames)ALIGN_ARG_POINTER;
#ifdef PLUGDOUBLE
  void p_processDoubleReplacing(double **inputs, double **outputs, VstInt32 sampleFrames)ALIGN_ARG_POINTER;
#endif
  void processLRModelThreaded(pfloat_t *inL, pfloat_t *inR, pfloat_t *outL, pfloat_t *outR, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
  virtual void processLRModel(pfloat_t *inL, pfloat_t *inR, pfloat_t *outL, pfloat_t *outR, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
  void setLatency(long size);
  long getLatency();
  void mute();
  
protected:
  VstInt32 allocProcessBlock(VstInt32 size);
  void freeProcessBlock();
  
private:
  void float2double(float *i, double *o, int size);
  void double2float(double *i, float *o, int size);
  VstInt32 processBlockSize;
#ifdef PLUGDOUBLE
  SLOT inputBlock;
#endif
  SLOT outputBlock;
  void resume();
  void suspend();
  ProcessBlockThreadInfo hostInfo;
  Locker mainSection;
#ifdef WIN32
  wchar_t eventName_StartThread[_MAX_PATH], eventName_ThreadEnded[_MAX_PATH];
  HANDLE event_StartThread, event_ThreadEnded, event_waitfor, event_trigger, PBThreadHandle;
#else
  PthreadEvent threadStart, threadEnded;
  pthread_t PBThreadHandle;
#endif
  SLOT latencyBlockInput, latencyBlockThreadInput, latencyBlockOutput, latencyBlockThreadOutput;
  volatile int threadFlags; unsigned int threadId;
  long latencySize, savedSize; bool runHalf;
};

#endif
