/**
 *  General GUI
 *
 *  Copyright (C) 2006-2014 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GeneralEditor_H
#define __GeneralEditor_H

#include <aeffguieditor.h>
#include <vstgui.h>
#include "vstguiev.hpp"
#include <vstcontrols.h>
#include <cfileselector.h>
#include <audioeffectx.h>
#include "ProcessBlock.hpp"

#define kBackBitmap        "g_back.bmp"
#define kVSliderBitmap     "g_knob.bmp"
#define kVSliderBackBitmap "g_knobback.bmp"

enum {
  kFaderX = 25,
  kFaderY = 10,
  kHeadX = 260,
  kHeadY = 30,
  kSelectorY = 50,
  kNameY = 79,
  kVSOffsetY = 108,
  kFaderInc = 10,
  kSignalSliderOffset = 50,
  kSignalSliderTextOffset = 60,
  kSignalGroupOffset = 70,
};

#define VerticalSliderN 6

typedef float (*PARAMCONV)(int, float);

class GeneralEditor :
  public AEffGUIEditor, CControlListener
{
public:
  GeneralEditor(AudioEffectX *effect) ALIGN_ARG_POINTER;
  virtual ~GeneralEditor() ALIGN_ARG_POINTER;
  virtual bool open(void *ptr) ALIGN_ARG_POINTER;
  virtual void close() ALIGN_ARG_POINTER;
  virtual void idle() ALIGN_ARG_POINTER;
  virtual void setParameter(VstInt32 index, float value) ALIGN_ARG_POINTER;
  virtual void valueChanged(CControl * pControl) ALIGN_ARG_POINTER;
  void registerConst(const char * effectName, const char ** grpName, const VstInt32 groupMatrix[6][6], const char * nameMatrix[6][6]);
  void registerParamConverter(PARAMCONV def);

private:
  AudioEffectX *aeffect;
  CTextLabel *headLabel;
  CTextLabelB *groupSelector[VerticalSliderN];
  CTextLabel *vsLabel[VerticalSliderN];
  CVerticalSlider *vSlider[VerticalSliderN];
  CTextEdit *vSliderText[VerticalSliderN];
  CTextLabel *vSliderTextLabel[VerticalSliderN];
  PARAMCONV paramConv;

  void setCurrentGroup(int grp);

  int currentGroup;
  const char * effName;
  const char ** _grpName;
  VstInt32 _grpMtx[6][6];
  const char * _nameMtx[6][6];
};

#endif
