/**
 *  CheckCPU Instruction
 *
 *  Copyright (C) 2006-2014 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "CheckCPU.hpp"

int detectCPU()
{
  int check = 1, prefer = 0;
  uint32_t simdFlag = UTILS::getSIMDFlag();
  fprintf(stderr, "simdFlag: %08x\n", simdFlag);
  
#ifdef PLUGDOUBLE
#ifdef ENABLE_AVX
  if(!(simdFlag & FV3_FLAG_AVX))
    check = 0;
#endif
#ifdef ENABLE_SSE4
  if(!(simdFlag & FV3_FLAG_SSE4_1))
    check = 0;
#endif
#ifdef ENABLE_SSE2
  if(!(simdFlag & FV3_FLAG_SSE2))
    check = 0;
#endif
  
#else

#ifdef ENABLE_SSE_V2
#define ENABLE_SSE
#endif

#ifdef ENABLE_AVX
  if(!(simdFlag & FV3_FLAG_AVX))
    check = 0;
#endif
#ifdef ENABLE_SSE3
  if(!(simdFlag & FV3_FLAG_SSE3))
    check = 0;
#endif
#ifdef ENABLE_SSE
  if(!(simdFlag & FV3_FLAG_SSE))
    check = 0;
#endif
#endif
  
  if(check == 0)
    {
#ifdef WIN32
      MessageBoxW(NULL,
		  L"This binary version is not supported on this machine.\n"
		  L"Try using check_cpu.exe to find the optimized binary version of Freeverb3_VST.",
		  L"Freeverb3_VST CPU MISMATCH ERROR",
		  MB_OK);
#endif
      return check;
    }
  return check;
}
