/**
 *  STRev
 *
 *  Copyright (C) 2006-2014 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __STRev_H
#define __STRev_H

#define EFFECT_NAME "Freeverb3_STRev"

#include <cstdlib>

#include <new>
#include <vector>
#include <string>
#include <cstdio>
#include <typeinfo>
#include <audioeffectx.h>
#include <freeverb/strev.hpp>
#include "ProcessBlock.hpp"
#include "Locker.hpp"

#ifdef PLUGDOUBLE
typedef fv3::strev_ STREV;
typedef double pfloat_t;
#else
typedef fv3::strev_f STREV;
typedef float pfloat_t;
#endif

#if WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <process.h>
#endif

enum {
  KOFactor, KDry, KWet, KWidth, KDelay, KRT60,
  KInputLPF, KDampLPF, KOutputLPF, KSpin, KWander,
  KNumParams,
};

class STRevProgram
{
public:
  STRevProgram()
  {
    fOFactor = 2, fDry = -4, fWet = -14, fWidth = 1, fDelay = 10, fRT60 = 2.3,
      fInputLPF = 19000, fDampLPF = 4000, fOutputLPF = 18000, fSpin = 0.8, fWander = 0.8;
    strcpy(name, "(Default Preset)");
  }
  ~STRevProgram(){}
  void setProgram(char * n, float v[KNumParams])
  {
    fOFactor = v[0], fDry = v[1], fWet = v[2], fWidth = v[3], fDelay = v[4], fRT60 = v[5],
      fInputLPF = v[6], fDampLPF = v[7], fOutputLPF = v[8], fSpin = v[9], fWander = v[10];
    strcpy(name, n);
  }
  pfloat_t getParameterValue(VstInt32 index)
  {
    pfloat_t ret = 0.;
    switch (index)
      {
      case KOFactor:    ret = this->fOFactor;   break;
      case KDry:        ret = this->fDry;       break;
      case KWet:        ret = this->fWet;	break;
      case KWidth:      ret = this->fWidth;	break;
      case KDelay:	ret = this->fDelay;	break;
      case KRT60:	ret = this->fRT60;	break;
      case KInputLPF:	ret = this->fInputLPF;	break;
      case KDampLPF:	ret = this->fDampLPF;	break;
      case KOutputLPF:	ret = this->fOutputLPF;	break;
      case KSpin:	ret = this->fSpin;	break;
      case KWander:	ret = this->fWander;	break;
      default:          break;
      }
    return ret;
  }
private:
  friend class STRev;
  pfloat_t fOFactor, fDry, fWet, fWidth, fDelay, fRT60,
    fInputLPF, fDampLPF, fOutputLPF, fSpin, fWander;
  char name[kVstMaxProgNameLen];
};

class STRev :
  public AudioEffectX, ProcessBlock, Locker
{
public:
  STRev(audioMasterCallback audioMaster) ALIGN_ARG_POINTER;
  virtual ~STRev();
  virtual VstPlugCategory getPlugCategory();
  virtual VstInt32 getProgram();
  virtual void     setProgram(VstInt32 program);
  virtual void setProgramName(char *name);
  virtual void getProgramName(char *name);
  virtual bool getProgramNameIndexed(VstInt32 category, VstInt32 index, char* text);
  virtual void getParameterLabel(VstInt32 index, char *label);
  virtual void getParameterDisplay(VstInt32 index, char *text);
  virtual void getParameterName(VstInt32 index, char *text);
  virtual bool getEffectName (char* name);
  virtual bool getVendorString (char* text);
  virtual bool getProductString (char* text);
  virtual VstInt32 canDo(char* text);
  virtual bool setBypass(bool onOff);
  virtual bool getInputProperties(VstInt32 index, VstPinProperties* properties);
  virtual bool getOutputProperties(VstInt32 index, VstPinProperties* properties);

  virtual void  suspend() ALIGN_ARG_POINTER;
  virtual void  resume() ALIGN_ARG_POINTER;
  virtual void  setSampleRate (float sampleRate) ALIGN_ARG_POINTER;
  virtual float getSampleRate() ALIGN_ARG_POINTER;
  virtual void  setParameter(VstInt32 index, float value) ALIGN_ARG_POINTER;
  virtual float getParameter(VstInt32 index) ALIGN_ARG_POINTER;
  virtual void process               (float **inputs, float **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
  virtual void processReplacing      (float **inputs, float **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
#ifdef PLUGDOUBLE
  virtual void processDoubleReplacing(double **inputs, double **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
#endif
  virtual void processLRModel(pfloat_t *inL, pfloat_t *inR, pfloat_t *outL, pfloat_t *outR, VstInt32 sampleFrames) ALIGN_ARG_POINTER;

  void setConverterType(int type);
  void setLatency(int size);

  static pfloat_t param2model(int index, float value);
  static float model2param(int index, pfloat_t value);
  static pfloat_t pconv(int index, pfloat_t value, bool p2m);
  
private:
  void setParameterM(VstInt32 index, float value);
  void setParameter(VstInt32 index, float value, bool vstp);

  STRevProgram * programs;
  STREV *model;
  double currentFs;
  int converter_type;
  bool byPass;
};

#endif
