/**
 *  MBCompressor GUI
 *
 *  Copyright (C) 2006-2014 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FreeverbEditor_H
#define __FreeverbEditor_H

#include <aeffguieditor.h>
#include <vstgui.h>
#include "vstguiev.hpp"
#include <vstcontrols.h>
#include <cfileselector.h>

#include "MBCompressor.hpp"

class CCGraph : public CView, SCOMP
{
public:
  CCGraph(const CRect &size, const CColor &line) ALIGN_ARG_POINTER :
    CView(size)
  {
    setTransparency(true);
    setMouseEnabled(false);
    offset(size.left, size.top);
    linecolor = line;
    setRMS(0), setAttack(0), setRelease(0);
  }

  virtual ~CCGraph(){};

  virtual void draw(CDrawContext *pContext) ALIGN_ARG_POINTER
  {
    float AGC = (1-1/getRatio())*UTILS::R2dB(getThreshold())*(-1);
    pContext->setLineWidth(3);
    pContext->setFrameColor(linecolor);
    for(float i = 0;i < 128;i ++)
      {
	float x1 = LINCV(0,128,-60,0,i);
	float y1 = UTILS::R2dB(UTILS::dB2R(x1)*process(UTILS::dB2R(x1)));
	float x2 = LINCV(0,128,-60,0,i+1);
	float y2 = UTILS::R2dB(UTILS::dB2R(x2)*process(UTILS::dB2R(x2)));
	if(autogain != 0) y1 += (AGC+gain), y2 += (AGC+gain);
	else y1 += gain, y2 += gain;
	CRect line((VSTGUI::CCoord)LINCV(-60,0,0,128,x1),(VSTGUI::CCoord)LINCV(-60,0,128,0,y1),
		   (VSTGUI::CCoord)LINCV(-60,0,0,128,x2),(VSTGUI::CCoord)LINCV(-60,0,128,0,y2));
	line.offset(offset.x, offset.y);
	pContext->moveTo(CPoint(line.left,line.bottom));
	pContext->lineTo(CPoint(line.right,line.top));
      }
    setDirty(false);
  }

  virtual void doIdleStuff() ALIGN_ARG_POINTER
  {
    if(pParentFrame) pParentFrame->doIdleStuff();
  }

  virtual bool isDirty() const
  {
    if(dirty||CView::isDirty()) return true;
    else return false;
  }

  virtual void setDirty(const bool val = true)
  {
    dirty = val;
  }
  
  void updateValue(float t, float r, float sk, float g, float a) ALIGN_ARG_POINTER
  {
    setThreshold(UTILS::dB2R(t)), setRatio(r), setSoftKnee(sk);
    gain=g, autogain=a;
    setDirty();
  }

private:
  CCGraph(const CCGraph&);
  bool dirty;
  float gain, autogain;
  CPoint offset;
  CColor linecolor;
};

class CLGraph : public CView, SLIMIT
{
public:
  CLGraph(const CRect &size, const CColor &line) ALIGN_ARG_POINTER :
    CView(size)
  {
    setTransparency(true);
    setMouseEnabled(false);
    offset(size.left, size.top);
    linecolor = line;
    setRMS(0), setAttack(0), setRelease(0);
  }

  virtual void draw(CDrawContext *pContext) ALIGN_ARG_POINTER
  {
    pContext->setLineWidth(3);
    pContext->setFrameColor(linecolor);
    for(float i = 0;i < 128;i ++)
      {
	float x1 = LINCV(0,128,-60,0,i);
	float y1 = UTILS::R2dB(UTILS::dB2R(x1)*process(UTILS::dB2R(x1)));
	float x2 = LINCV(0,128,-60,0,i+1);
	float y2 = UTILS::R2dB(UTILS::dB2R(x2)*process(UTILS::dB2R(x2)));
	CRect line((VSTGUI::CCoord)LINCV(-60,0,0,128,x1),(VSTGUI::CCoord)LINCV(-60,0,128,0,y1),
		   (VSTGUI::CCoord)LINCV(-60,0,0,128,x2),(VSTGUI::CCoord)LINCV(-60,0,128,0,y2));
	line.offset(offset.x, offset.y);
	pContext->moveTo(CPoint(line.left,line.bottom));
	pContext->lineTo(CPoint(line.right,line.top));
      }
    setDirty(false);
  }

  virtual void doIdleStuff() ALIGN_ARG_POINTER
  {
    if(pParentFrame) pParentFrame->doIdleStuff();
  }

  virtual bool isDirty() const
  {
    if(dirty||CView::isDirty()) return true;
    else return false;
  }

  virtual void setDirty(const bool val = true)
  {
    dirty = val;
  }

  void updateValue(float c, float t) ALIGN_ARG_POINTER
  {
    setCeiling(UTILS::dB2R(c)), setThreshold(UTILS::dB2R(t));
    setDirty();
  }
  
private:
  CLGraph(const CLGraph&);
  bool dirty;
  CPoint offset;
  CColor linecolor;
};

class MBCompressorEditor : public AEffGUIEditor, CControlListener
{
public:
  MBCompressorEditor(AudioEffect *effect) ALIGN_ARG_POINTER;
  virtual bool open(void *ptr) ALIGN_ARG_POINTER;
  virtual void close() ALIGN_ARG_POINTER;
  virtual void idle() ALIGN_ARG_POINTER;
  virtual void setParameter(VstInt32 index, float value) ALIGN_ARG_POINTER;
  virtual void valueChanged(CControl* control) ALIGN_ARG_POINTER;
  
  void setVuMeter(float iL, float iR, float oL, float oR);
  void setRMeter(float r1, float r2, float r3, float l);

private:
  float gui2param(int index, pfloat_t value);
  pfloat_t param2gui(int index, float value);
  
  void registerFader(CFrame * frame, VstInt32 data[3], CBitmap * body, CBitmap * handle,
		     float initFaderValue, float initTextValue, float zoomFactor, VstInt32 wide, int setIndex);
  static void stringConvert(float value, char * string);
  float R2VudB(float value);
  float limitFader(float value);
  
  void updateGraph();
  
  MBCompressor * compressor;
  
  float vuIL, vuIR, vuOL, vuOR, re1, re2, re3, le;
  CVuMeter *cVuMeterIL, *cVuMeterIR, *cVuMeterOL, *cVuMeterOR;
  CVuMeter *cRMeter1, *cRMeter2, *cRMeter3, *lRMeter;
  CHorizontalSliderE *cFreqHS1, *cFreqHS2;
  CTextEdit *cFreqTE1, *cFreqTE2;
  COnOffButton *autoGainB;
  CCGraph *graphL, *graphM, *graphH;
  CLGraph *lgraph;
};

#define kBackBMP    "vstpanel-comp.bmp"
#define kVuOnBMP    "c_vuon.bmp"
#define kVuOffBMP   "c_vuoff.bmp"
#define kRedOnBMP   "c_redon.bmp"
#define kRedOffBMP  "c_redoff.bmp"
#define kHSliderBMP "c_hslider.bmp"
#define kSliderTBMP "c_hslider_t.bmp"
#define kFreqBarBMP "c_freqbar.bmp"
#define kOnOffBMP   "c_onoff.bmp"

// positions
enum {
  kpVuIX = 9,   kpVuIY = 15,
  kpVuOX = 43,  kpVuOY = 15,
  kpRedX = 100, kpRedY = 215,
  kpRedOffset = 4,
  kpLRedX = 502, kpLRedY = 156,
  kpFreqX = 100, kpFreqY = 173,
  kpFreqOffset = 9,
  kpFreqTEWidth = 40, kpFreqTEHeight = 12,
  kpFreqTE1X = 210, kpFreqTE1Y = 152,
  kpFreqTE2X = 342, kpFreqTE2Y = 152,
  kpAGX = 100, kpAGY = 404,
  kpGraphWidth = 128, kpGraphHeight = 128,
  kpGraphLX = 100, kpGraphLY = 15,
  kpGraphMX = 232, kpGraphMY = 15,
  kpGraphHX = 364, kpGraphHY = 15,
  kpGraphTX = 502, kpGraphTY = 15,
};

#endif
