/**
 *  Hibiki Reverb based on Zita-Rev
 *
 *  Copyright (C) 2006-2014 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __STRev_H
#define __STRev_H

#define EFFECT_NAME "Freeverb3_Hibiki_Reverb"

#include <cstdlib>

#include <new>
#include <vector>
#include <string>
#include <cstdio>
#include <typeinfo>
#include <audioeffectx.h>
#include <freeverb/earlyref.hpp>
#include <freeverb/zrev2.hpp>
#include "ProcessBlock.hpp"
#include "Locker.hpp"

#ifdef PLUGDOUBLE
typedef fv3::earlyref_ EARLYREF;
typedef fv3::zrev2_ ZREV2;
typedef fv3::utils_ UTILS;
typedef double pfloat_t;
#else
typedef fv3::earlyref_f EARLYREF;
typedef fv3::zrev2_f ZREV2;
typedef fv3::utils_f UTILS;
typedef float pfloat_t;
#endif

enum {
  KOSRCFact, KODry, KOERefWet, KOERefWid, KOERefFac, KOERefSend, KOLateWet, KOWidth, KOPreDelay,
  KORoomSize, KORT60, KOXOLow, KOXOHigh, KORT60LoG, KORT60HiG, KODiffuse, KOFDNApFb,
  KOEarlyLPF, KOEarlyHPF, KOLateLPF, KOLateHPF, KOLFO1, KOLFO2, KOLFOFact, KOSpin, KOWander, KOSpinFact,
  KOReverbType, KOERType, KORsvd3, KORsvd4, KORsvd5, KORsvd6, KORsvd7, KORsvd8, KORsvd9, KORsvd10,
  KNumParams,
};

class HibikiRevProgram
{
public:
  HibikiRevProgram()
  {
    fOSRCFact = 1, fODry = -5, fOERefWet = -5, fOERefWid = 0.3, fOERefFac = 6.0, fOERefSend = 0.3, fOLateWet = -5, fOWidth = 1, fOPreDelay = 2,
      fORoomSize = 70, fORT60 = 2.5, fOXOLow = 490, fOXOHigh = 6000, fORT60LoG = 1.4, fORT60HiG = 0.25, fODiffuse = 90, fOFDNApFb = 90,
      fOEarlyLPF = 20000, fOEarlyHPF = 4, fOLateLPF = 8000, fOLateHPF = 4, fOLFO1 = 0.9, fOLFO2 = 1.3, fOLFOFact = 0.3,
      fOSpin = 2.4, fOWander = 22, fOSpinFact = 0.3,
      fOReverbType = 0, fOERType = 0, fORsvd3 = 0, fORsvd4 = 0, fORsvd5 = 0, fORsvd6 = 0, fORsvd7 = 0, fORsvd8 = 0, fORsvd9 = 0, fORsvd10 = 0;
    strcpy(name, "(Default Preset)");
  }
  ~HibikiRevProgram(){}
  void setProgram(char * n, float v[KNumParams])
  {
    fOSRCFact = v[0]; fODry = v[1]; fOERefWet = v[2]; fOERefWid = v[3]; fOERefFac = v[4]; fOERefSend = v[5]; fOLateWet = v[6]; fOWidth = v[7];
    fOPreDelay = v[8]; fORoomSize = v[9]; fORT60 = v[10]; fOXOLow = v[11]; fOXOHigh = v[12]; fORT60LoG = v[13]; fORT60HiG = v[14]; fODiffuse = v[15];
    fOFDNApFb = v[16]; fOEarlyLPF = v[17]; fOEarlyHPF = v[18]; fOLateLPF = v[19]; fOLateHPF = v[20]; fOLFO1 = v[21]; fOLFO2 = v[22]; fOLFOFact = v[23];
    fOSpin = v[24]; fOWander = v[25]; fOSpinFact = v[26]; fOReverbType = v[27]; fOERType = v[28];
    strcpy(name, n);
  }
  pfloat_t getParameterValue(VstInt32 index)
  {
    pfloat_t ret = 0.;
    switch (index)
      {
      case KOSRCFact: ret = this->fOSRCFact; break;
      case KODry:     ret = this->fODry; break;
      case KOERefWet: ret = this->fOERefWet; break;
      case KOERefWid: ret = this->fOERefWid; break;
      case KOERefFac: ret = this->fOERefFac; break;
      case KOERefSend:        ret = this->fOERefSend; break;
      case KOLateWet: ret = this->fOLateWet; break;
      case KOWidth:   ret = this->fOWidth; break;
      case KOPreDelay:        ret = this->fOPreDelay; break;
      case KORoomSize:        ret = this->fORoomSize; break;
      case KORT60:    ret = this->fORT60; break;
      case KOXOLow:   ret = this->fOXOLow; break;
      case KOXOHigh:  ret = this->fOXOHigh; break;
      case KORT60LoG: ret = this->fORT60LoG; break;
      case KORT60HiG: ret = this->fORT60HiG; break;
      case KODiffuse: ret = this->fODiffuse; break;
      case KOFDNApFb: ret = this->fOFDNApFb; break;
      case KOEarlyLPF:        ret = this->fOEarlyLPF; break;
      case KOEarlyHPF:        ret = this->fOEarlyHPF; break;
      case KOLateLPF: ret = this->fOLateLPF; break;
      case KOLateHPF: ret = this->fOLateHPF; break;
      case KOLFO1:    ret = this->fOLFO1; break;
      case KOLFO2:    ret = this->fOLFO2; break;
      case KOLFOFact: ret = this->fOLFOFact; break;
      case KOSpin:    ret = this->fOSpin; break;
      case KOWander:  ret = this->fOWander; break;
      case KOSpinFact:        ret = this->fOSpinFact; break;
      case KOReverbType:      ret = this->fOReverbType; break;
      case KOERType:          ret = this->fOERType; break;
      default:          break;
      }
    return ret;
  }
private:
  friend class HibikiRev;
  pfloat_t  fOSRCFact, fODry, fOERefWet, fOERefWid, fOERefFac, fOERefSend, fOLateWet, fOWidth, fOPreDelay,
    fORoomSize, fORT60, fOXOLow, fOXOHigh, fORT60LoG, fORT60HiG, fODiffuse, fOFDNApFb,
    fOEarlyLPF, fOEarlyHPF, fOLateLPF, fOLateHPF, fOLFO1, fOLFO2, fOLFOFact, fOSpin, fOWander, fOSpinFact,
    fOReverbType, fOERType, fORsvd3, fORsvd4, fORsvd5, fORsvd6, fORsvd7, fORsvd8, fORsvd9, fORsvd10;
  char name[kVstMaxProgNameLen];
};

class HibikiRev :
  public AudioEffectX, ProcessBlock, Locker
{
public:
  HibikiRev(audioMasterCallback audioMaster) ALIGN_ARG_POINTER;
  virtual ~HibikiRev();
  virtual VstPlugCategory getPlugCategory();
  virtual VstInt32 getProgram();
  virtual void     setProgram(VstInt32 program);
  virtual void setProgramName(char *name);
  virtual void getProgramName(char *name);
  virtual bool getProgramNameIndexed(VstInt32 category, VstInt32 index, char* text);
  virtual void getParameterLabel(VstInt32 index, char *label);
  virtual void getParameterDisplay(VstInt32 index, char *text);
  virtual void getParameterName(VstInt32 index, char *text);
  virtual bool getEffectName (char* name);
  virtual bool getVendorString (char* text);
  virtual bool getProductString (char* text);
  virtual VstInt32 canDo(char* text);
  virtual bool setBypass(bool onOff);
  virtual bool getInputProperties(VstInt32 index, VstPinProperties* properties);
  virtual bool getOutputProperties(VstInt32 index, VstPinProperties* properties);
  
  virtual void  suspend() ALIGN_ARG_POINTER;
  virtual void  resume() ALIGN_ARG_POINTER;
  virtual void  setSampleRate (float sampleRate) ALIGN_ARG_POINTER;
  virtual float getSampleRate() ALIGN_ARG_POINTER;
  virtual void  setParameter(VstInt32 index, float value) ALIGN_ARG_POINTER;
  virtual float getParameter(VstInt32 index) ALIGN_ARG_POINTER;
  virtual void process               (float **inputs, float **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
  virtual void processReplacing      (float **inputs, float **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
#ifdef PLUGDOUBLE
  virtual void processDoubleReplacing(double **inputs, double **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
#endif
  virtual void processLRModel(pfloat_t *inL, pfloat_t *inR, pfloat_t *outL, pfloat_t *outR, VstInt32 sampleFrames) ALIGN_ARG_POINTER;

  void setConverterType(int type);
  void setLatency(int size);
  
  static pfloat_t param2model(int index, float value);
  static float model2param(int index, pfloat_t value);
  static pfloat_t pconv(int index, pfloat_t value, bool p2m);
  
private:
  void setParameterM(VstInt32 index, float value);
  void setParameter(VstInt32 index, float value, bool vstp);

  HibikiRevProgram * programs;
  EARLYREF *dsp_eref;
  ZREV2 *dsp_prev;
  SLOT tmp1Block, tmp2Block;
  pfloat_t vERtoLate, dryDB, erDB;
  double currentFs;
  int converter_type;
  bool byPass;
};

#endif
