/**
 *  General GUI
 *
 *  Copyright (C) 2006-2014 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "GeneralEditor.hpp"

GeneralEditor::GeneralEditor(AudioEffectX *effect) :
  AEffGUIEditor(effect), aeffect(effect)
{
  CBitmap backBitmap(kBackBitmap);
  rect.left = 0; rect.top = 0; rect.right = backBitmap.getWidth(); rect.bottom = backBitmap.getHeight();
  currentGroup = 0;
  paramConv = NULL;
}

GeneralEditor::~GeneralEditor()
{
  ;
}

bool GeneralEditor::open(void *ptr)
{
  AEffGUIEditor::open(ptr);
  
  CBitmap *backBitmap = new CBitmap(kBackBitmap);
  CRect size(0, 0, backBitmap->getWidth(), backBitmap->getHeight());
  CFrame * _frame = new CFrame(size, ptr, this);
  _frame->setBackground(backBitmap);
  backBitmap->forget();
  
  // Effect Label
  size(kFaderX, kFaderY, kFaderX+kHeadX, kFaderY+kHeadY);
  headLabel = new CTextLabel(size, "VST Plugin", 0);
  headLabel->setFont(kNormalFontVeryBig);
  headLabel->setFontColor(kBlueCColor); headLabel->setBackColor(kWhiteCColor); headLabel->setFrameColor(kWhiteCColor);
  headLabel->setText(effName);
  _frame->addView(headLabel);

  CPoint point(0, 0), offset(0, 0);
  CBitmap *vsliderBitmap = new CBitmap(kVSliderBitmap);
  CBitmap *vsliderBackBitmap = new CBitmap(kVSliderBackBitmap);

  // GroupSelector
  size(kFaderX, kSelectorY, kFaderX+vsliderBitmap->getWidth(), kSelectorY+vsliderBitmap->getHeight());
  for(int i = 0;i < VerticalSliderN;i ++)
    {
      groupSelector[i] = new CTextLabelB(size, "GRP", 0, 0, this, kSignalGroupOffset+i);
      groupSelector[i]->setFont(kNormalFont);
      groupSelector[i]->setFontColor(kWhiteCColor); groupSelector[i]->setBackColor(kBlueCColor); groupSelector[i]->setFrameColor(kBlueCColor);
      _frame->addView(groupSelector[i]);
      size.offset(kFaderInc + vsliderBitmap->getWidth(), 0);
    }

  // Parameter Name
  size(kFaderX, kNameY, kFaderX+vsliderBitmap->getWidth(), kNameY+vsliderBitmap->getHeight());
  for(int i = 0;i < VerticalSliderN;i ++)
    {
      vsLabel[i] = new CTextLabel(size, "Eff", 0);
      vsLabel[i]->setFont(kNormalFont); vsLabel[i]->setFontColor(kBlackCColor);
      vsLabel[i]->setBackColor(kWhiteCColor); vsLabel[i]->setFrameColor(kWhiteCColor);
      _frame->addView(vsLabel[i]);
      size.offset(kFaderInc + vsliderBitmap->getWidth(), 0);
    }

  // VerticalSlider
  size(kFaderX, kVSOffsetY, kFaderX+vsliderBackBitmap->getWidth(), kVSOffsetY+vsliderBackBitmap->getHeight());
  int minPos = kVSOffsetY, maxPos = kVSOffsetY + vsliderBackBitmap->getHeight() - vsliderBitmap->getHeight();
  for(int i = 0;i < VerticalSliderN;i ++)
    {
      vSlider[i] = new CVerticalSlider(size, this, kSignalSliderOffset+i, minPos, maxPos, vsliderBitmap, vsliderBackBitmap, point);
      vSlider[i]->setOffsetHandle(offset);
      vSlider[i]->setValue(0.5);
      vSlider[i]->setFreeClick(false);
      vSlider[i]->setZoomFactor(3);
      _frame->addView(vSlider[i]);
      size.offset(kFaderInc + vsliderBackBitmap->getWidth(), 0);
      }

  // SliderTextEditor
  size(kFaderX, kVSOffsetY+kFaderInc+vsliderBackBitmap->getHeight(),
       kFaderX+vsliderBackBitmap->getWidth(), kVSOffsetY+kFaderInc+vsliderBackBitmap->getHeight()+vsliderBitmap->getHeight());
  for(int i = 0;i < VerticalSliderN;i ++)
    {
      vSliderText[i] = new CTextEdit(size, this, kSignalSliderTextOffset+i, NULL, NULL, kCenterText);
      vSliderText[i]->setFont(kNormalFont); vSliderText[i]->setFontColor(kBlackCColor);
      vSliderText[i]->setBackColor(kWhiteCColor); vSliderText[i]->setFrameColor(kWhiteCColor);
      vSliderText[i]->setText("");
      _frame->addView(vSliderText[i]);
      size.offset(kFaderInc + vsliderBackBitmap->getWidth(), 0);
      }

  // SliderTextLabel
  size(kFaderX, kVSOffsetY+kFaderInc+vsliderBackBitmap->getHeight()+vsliderBitmap->getHeight(),
       kFaderX+vsliderBackBitmap->getWidth(), kVSOffsetY+kFaderInc+vsliderBackBitmap->getHeight()+vsliderBitmap->getHeight()*2);
  for(int i = 0;i < VerticalSliderN;i ++)
    {
      vSliderTextLabel[i] = new CTextLabel(size, "[]", 0);
      vSliderTextLabel[i]->setFont(kNormalFontBig); vSliderTextLabel[i]->setFontColor(kBlackCColor);
      vSliderTextLabel[i]->setBackColor(kWhiteCColor); vSliderTextLabel[i]->setFrameColor(kWhiteCColor);
      _frame->addView(vSliderTextLabel[i]);
      size.offset(kFaderInc + vsliderBackBitmap->getWidth(), 0);
      }

  vsliderBitmap->forget();
  vsliderBackBitmap->forget();

  for(int i = 0;i < VerticalSliderN;i ++)
    {
      groupSelector[i]->setText(_grpName[i]);
    }
  
  setCurrentGroup(currentGroup);

  _frame->setDirty();
  this->frame = _frame;
  return true;
}

void GeneralEditor::close()
{
  if (frame != NULL) delete frame;
  frame = NULL;
}

void GeneralEditor::idle()
{
  if(!frame) return;
  AEffGUIEditor::idle();
}

void GeneralEditor::registerConst(const char * effectName, const char ** grpName, const VstInt32 groupMatrix[6][6], const char * nameMatrix[6][6])
{
  effName = effectName;
  this->_grpName = grpName;
  memcpy(_grpMtx, groupMatrix, sizeof(VstInt32)*6*6);
  memcpy(_nameMtx, nameMatrix, sizeof(char*)*6*6);
}

void GeneralEditor::registerParamConverter(PARAMCONV def)
{
  if(def != NULL) paramConv = def;
}

void GeneralEditor::setCurrentGroup(int grp)
{
  if(grp < 0||grp >= VerticalSliderN) return;
  currentGroup = grp;
  for(int i = 0;i < VerticalSliderN;i ++)
    {
      vsLabel[i]->setText(_nameMtx[grp][i]);
      VstInt32 paramIndex =_grpMtx[grp][i];
      if(paramIndex >= 0)
	{
	  vSlider[i]->setValue(aeffect->getParameter(paramIndex));
	  char str[kVstMaxParamStrLen];
	  aeffect->getParameterDisplay(paramIndex, str), str[5] = '\0';
	  vSliderText[i]->setText(str);
	  aeffect->getParameterLabel(paramIndex, str), str[5] = '\0';
	  vSliderTextLabel[i]->setText(str);
	}
      else
	{
	  vSlider[i]->setValue(0);
	  vSliderText[i]->setText("");
	  vSliderTextLabel[i]->setText("");
	}
      if(i == grp)
	{
	  groupSelector[i]->setFontColor(kWhiteCColor); groupSelector[i]->setBackColor(kBlueCColor); groupSelector[i]->setFrameColor(kBlueCColor);
	}
      else
	{
	  groupSelector[i]->setFontColor(kBlueCColor); groupSelector[i]->setBackColor(kWhiteCColor); groupSelector[i]->setFrameColor(kBlueCColor);
	}
    }
}

void GeneralEditor::setParameter(VstInt32 index, float value)
{
  if(!frame) return;
  for(int i = 0;i < VerticalSliderN;i ++)
    {
      VstInt32 paramIndex = _grpMtx[currentGroup][i];
      if(paramIndex == index)
	{
	  vSlider[i]->setValue(value);
	  char str[kVstMaxParamStrLen];
	  aeffect->getParameterDisplay(index, str), str[5] = '\0';
	  vSliderText[i]->setText(str);
	}
    }
}

void GeneralEditor::valueChanged(CControl * pControl)
{
  VstInt32 Tag = pControl->getTag();
  float Value = pControl->getValue();
  if(Tag >= kSignalGroupOffset&&Tag < kSignalGroupOffset+VerticalSliderN)
    {
      setCurrentGroup(Tag-kSignalGroupOffset);
    }
  if(Tag >= kSignalSliderOffset&&Tag < kSignalSliderOffset+VerticalSliderN)
    {
      VstInt32 paramIndex = _grpMtx[currentGroup][Tag-kSignalSliderOffset];
      if(paramIndex < 0) return;
      if(Value < 0) Value = 0; if(Value > 1) Value = 1;
      effect->setParameterAutomated(paramIndex, Value);
    }
  if(Tag >= kSignalSliderTextOffset&&Tag < kSignalSliderTextOffset+VerticalSliderN)
    {
      VstInt32 paramIndex = _grpMtx[currentGroup][Tag-kSignalSliderTextOffset];
      if(paramIndex < 0) return;
      char str[16]; float fvalue = 0;
      ((CTextEdit*)pControl)->getText(str), fvalue = atof(str);
      if(paramConv != NULL) fvalue = paramConv(paramIndex, fvalue);
      if(fvalue < 0) fvalue = 0; if(fvalue > 1) fvalue = 1;
      effect->setParameterAutomated(paramIndex, fvalue);
    }
}
