/**
 *  FileLog
 *
 *  Copyright (C) 2006-2014 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "FileLog.hpp"

FileLog::FileLog()
{
  logFilename = "";
}

FileLog::~FileLog()
{
  ;
}

void FileLog::setLogFileName(char * filename)
{
  if(filename != NULL)
    logFilename = filename;
  else
    logFilename = "";
}

void FileLog::writeLogA(const char * fmt, ...)
{
  if(logFilename.length() <= 0)
    return;
  FILE * logfp = fopen(logFilename.c_str(), "a");
  if(logfp == NULL) return;
  va_list argp;
  va_start(argp, fmt);
  vfprintf(logfp, fmt, argp);
  va_end(argp);
  fclose(logfp);
}

void FileLog::writeDumpA(const char * description, const unsigned char * data, int size)
{
  if(logFilename.length() <= 0)
    return;
  FILE * logfp = fopen(logFilename.c_str(), "a");
  if(logfp == NULL) return;
  fprintf(logfp, "%s", description);

  int i = 0;
  while(size > 0)
    {
      if(i%16 == 0) fprintf(logfp, "\n%08x ", i);
      fprintf(logfp, "%02x", data[i]);
      if(!isprint(data[i])) fprintf(logfp, "(.) ");
      else fprintf(logfp, "(%c) ", data[i]);
      i ++; size --;
    }
  fprintf(logfp, "\n");
  fclose(logfp);
}
