// RUN: llvm-mc -triple x86_64-unknown-unknown -mcpu=knl -mattr=+avx512bw -mattr=+avx512vl  --show-encoding %s | FileCheck %s

// CHECK: vpaddb %xmm22, %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x21,0x75,0x00,0xfc,0xd6]
          vpaddb %xmm22, %xmm17, %xmm26

// CHECK: vpaddb %xmm22, %xmm17, %xmm26 {%k5}
// CHECK:  encoding: [0x62,0x21,0x75,0x05,0xfc,0xd6]
          vpaddb %xmm22, %xmm17, %xmm26 {%k5}

// CHECK: vpaddb %xmm22, %xmm17, %xmm26 {%k5} {z}
// CHECK:  encoding: [0x62,0x21,0x75,0x85,0xfc,0xd6]
          vpaddb %xmm22, %xmm17, %xmm26 {%k5} {z}

// CHECK: vpaddb (%rcx), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x61,0x75,0x00,0xfc,0x11]
          vpaddb (%rcx), %xmm17, %xmm26

// CHECK: vpaddb 291(%rax,%r14,8), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x21,0x75,0x00,0xfc,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpaddb 291(%rax,%r14,8), %xmm17, %xmm26

// CHECK: vpaddb 2032(%rdx), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x61,0x75,0x00,0xfc,0x52,0x7f]
          vpaddb 2032(%rdx), %xmm17, %xmm26

// CHECK: vpaddb 2048(%rdx), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x61,0x75,0x00,0xfc,0x92,0x00,0x08,0x00,0x00]
          vpaddb 2048(%rdx), %xmm17, %xmm26

// CHECK: vpaddb -2048(%rdx), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x61,0x75,0x00,0xfc,0x52,0x80]
          vpaddb -2048(%rdx), %xmm17, %xmm26

// CHECK: vpaddb -2064(%rdx), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x61,0x75,0x00,0xfc,0x92,0xf0,0xf7,0xff,0xff]
          vpaddb -2064(%rdx), %xmm17, %xmm26

// CHECK: vpaddb %ymm28, %ymm27, %ymm26
// CHECK:  encoding: [0x62,0x01,0x25,0x20,0xfc,0xd4]
          vpaddb %ymm28, %ymm27, %ymm26

// CHECK: vpaddb %ymm28, %ymm27, %ymm26 {%k3}
// CHECK:  encoding: [0x62,0x01,0x25,0x23,0xfc,0xd4]
          vpaddb %ymm28, %ymm27, %ymm26 {%k3}

// CHECK: vpaddb %ymm28, %ymm27, %ymm26 {%k3} {z}
// CHECK:  encoding: [0x62,0x01,0x25,0xa3,0xfc,0xd4]
          vpaddb %ymm28, %ymm27, %ymm26 {%k3} {z}

// CHECK: vpaddb (%rcx), %ymm27, %ymm26
// CHECK:  encoding: [0x62,0x61,0x25,0x20,0xfc,0x11]
          vpaddb (%rcx), %ymm27, %ymm26

// CHECK: vpaddb 291(%rax,%r14,8), %ymm27, %ymm26
// CHECK:  encoding: [0x62,0x21,0x25,0x20,0xfc,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpaddb 291(%rax,%r14,8), %ymm27, %ymm26

// CHECK: vpaddb 4064(%rdx), %ymm27, %ymm26
// CHECK:  encoding: [0x62,0x61,0x25,0x20,0xfc,0x52,0x7f]
          vpaddb 4064(%rdx), %ymm27, %ymm26

// CHECK: vpaddb 4096(%rdx), %ymm27, %ymm26
// CHECK:  encoding: [0x62,0x61,0x25,0x20,0xfc,0x92,0x00,0x10,0x00,0x00]
          vpaddb 4096(%rdx), %ymm27, %ymm26

// CHECK: vpaddb -4096(%rdx), %ymm27, %ymm26
// CHECK:  encoding: [0x62,0x61,0x25,0x20,0xfc,0x52,0x80]
          vpaddb -4096(%rdx), %ymm27, %ymm26

// CHECK: vpaddb -4128(%rdx), %ymm27, %ymm26
// CHECK:  encoding: [0x62,0x61,0x25,0x20,0xfc,0x92,0xe0,0xef,0xff,0xff]
          vpaddb -4128(%rdx), %ymm27, %ymm26

// CHECK: vpaddw %xmm18, %xmm17, %xmm18
// CHECK:  encoding: [0x62,0xa1,0x75,0x00,0xfd,0xd2]
          vpaddw %xmm18, %xmm17, %xmm18

// CHECK: vpaddw %xmm18, %xmm17, %xmm18 {%k1}
// CHECK:  encoding: [0x62,0xa1,0x75,0x01,0xfd,0xd2]
          vpaddw %xmm18, %xmm17, %xmm18 {%k1}

// CHECK: vpaddw %xmm18, %xmm17, %xmm18 {%k1} {z}
// CHECK:  encoding: [0x62,0xa1,0x75,0x81,0xfd,0xd2]
          vpaddw %xmm18, %xmm17, %xmm18 {%k1} {z}

// CHECK: vpaddw (%rcx), %xmm17, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x75,0x00,0xfd,0x11]
          vpaddw (%rcx), %xmm17, %xmm18

// CHECK: vpaddw 291(%rax,%r14,8), %xmm17, %xmm18
// CHECK:  encoding: [0x62,0xa1,0x75,0x00,0xfd,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpaddw 291(%rax,%r14,8), %xmm17, %xmm18

// CHECK: vpaddw 2032(%rdx), %xmm17, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x75,0x00,0xfd,0x52,0x7f]
          vpaddw 2032(%rdx), %xmm17, %xmm18

// CHECK: vpaddw 2048(%rdx), %xmm17, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x75,0x00,0xfd,0x92,0x00,0x08,0x00,0x00]
          vpaddw 2048(%rdx), %xmm17, %xmm18

// CHECK: vpaddw -2048(%rdx), %xmm17, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x75,0x00,0xfd,0x52,0x80]
          vpaddw -2048(%rdx), %xmm17, %xmm18

// CHECK: vpaddw -2064(%rdx), %xmm17, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x75,0x00,0xfd,0x92,0xf0,0xf7,0xff,0xff]
          vpaddw -2064(%rdx), %xmm17, %xmm18

// CHECK: vpaddw %ymm26, %ymm21, %ymm23
// CHECK:  encoding: [0x62,0x81,0x55,0x20,0xfd,0xfa]
          vpaddw %ymm26, %ymm21, %ymm23

// CHECK: vpaddw %ymm26, %ymm21, %ymm23 {%k7}
// CHECK:  encoding: [0x62,0x81,0x55,0x27,0xfd,0xfa]
          vpaddw %ymm26, %ymm21, %ymm23 {%k7}

// CHECK: vpaddw %ymm26, %ymm21, %ymm23 {%k7} {z}
// CHECK:  encoding: [0x62,0x81,0x55,0xa7,0xfd,0xfa]
          vpaddw %ymm26, %ymm21, %ymm23 {%k7} {z}

// CHECK: vpaddw (%rcx), %ymm21, %ymm23
// CHECK:  encoding: [0x62,0xe1,0x55,0x20,0xfd,0x39]
          vpaddw (%rcx), %ymm21, %ymm23

// CHECK: vpaddw 291(%rax,%r14,8), %ymm21, %ymm23
// CHECK:  encoding: [0x62,0xa1,0x55,0x20,0xfd,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpaddw 291(%rax,%r14,8), %ymm21, %ymm23

// CHECK: vpaddw 4064(%rdx), %ymm21, %ymm23
// CHECK:  encoding: [0x62,0xe1,0x55,0x20,0xfd,0x7a,0x7f]
          vpaddw 4064(%rdx), %ymm21, %ymm23

// CHECK: vpaddw 4096(%rdx), %ymm21, %ymm23
// CHECK:  encoding: [0x62,0xe1,0x55,0x20,0xfd,0xba,0x00,0x10,0x00,0x00]
          vpaddw 4096(%rdx), %ymm21, %ymm23

// CHECK: vpaddw -4096(%rdx), %ymm21, %ymm23
// CHECK:  encoding: [0x62,0xe1,0x55,0x20,0xfd,0x7a,0x80]
          vpaddw -4096(%rdx), %ymm21, %ymm23

// CHECK: vpaddw -4128(%rdx), %ymm21, %ymm23
// CHECK:  encoding: [0x62,0xe1,0x55,0x20,0xfd,0xba,0xe0,0xef,0xff,0xff]
          vpaddw -4128(%rdx), %ymm21, %ymm23

// CHECK: vpbroadcastb %eax, %xmm22
// CHECK:  encoding: [0x62,0xe2,0x7d,0x08,0x7a,0xf0]
          vpbroadcastb %eax, %xmm22

// CHECK: vpbroadcastb %eax, %xmm22 {%k3}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x0b,0x7a,0xf0]
          vpbroadcastb %eax, %xmm22 {%k3}

// CHECK: vpbroadcastb %eax, %xmm22 {%k3} {z}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x8b,0x7a,0xf0]
          vpbroadcastb %eax, %xmm22 {%k3} {z}

// CHECK: vpbroadcastb %eax, %ymm17
// CHECK:  encoding: [0x62,0xe2,0x7d,0x28,0x7a,0xc8]
          vpbroadcastb %eax, %ymm17

// CHECK: vpbroadcastb %eax, %ymm17 {%k1}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x29,0x7a,0xc8]
          vpbroadcastb %eax, %ymm17 {%k1}

// CHECK: vpbroadcastb %eax, %ymm17 {%k1} {z}
// CHECK:  encoding: [0x62,0xe2,0x7d,0xa9,0x7a,0xc8]
          vpbroadcastb %eax, %ymm17 {%k1} {z}

// CHECK: vpbroadcastw %eax, %xmm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x7b,0xe8]
          vpbroadcastw %eax, %xmm29

// CHECK: vpbroadcastw %eax, %xmm29 {%k1}
// CHECK:  encoding: [0x62,0x62,0x7d,0x09,0x7b,0xe8]
          vpbroadcastw %eax, %xmm29 {%k1}

// CHECK: vpbroadcastw %eax, %xmm29 {%k1} {z}
// CHECK:  encoding: [0x62,0x62,0x7d,0x89,0x7b,0xe8]
          vpbroadcastw %eax, %xmm29 {%k1} {z}

// CHECK: vpbroadcastw %eax, %ymm28
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x7b,0xe0]
          vpbroadcastw %eax, %ymm28

// CHECK: vpbroadcastw %eax, %ymm28 {%k4}
// CHECK:  encoding: [0x62,0x62,0x7d,0x2c,0x7b,0xe0]
          vpbroadcastw %eax, %ymm28 {%k4}

// CHECK: vpbroadcastw %eax, %ymm28 {%k4} {z}
// CHECK:  encoding: [0x62,0x62,0x7d,0xac,0x7b,0xe0]
          vpbroadcastw %eax, %ymm28 {%k4} {z}

// CHECK: vpcmpeqb %xmm21, %xmm21, %k4
// CHECK:  encoding: [0x62,0xb1,0x55,0x00,0x74,0xe5]
          vpcmpeqb %xmm21, %xmm21, %k4

// CHECK: vpcmpeqb %xmm21, %xmm21, %k4 {%k3}
// CHECK:  encoding: [0x62,0xb1,0x55,0x03,0x74,0xe5]
          vpcmpeqb %xmm21, %xmm21, %k4 {%k3}

// CHECK: vpcmpeqb (%rcx), %xmm21, %k4
// CHECK:  encoding: [0x62,0xf1,0x55,0x00,0x74,0x21]
          vpcmpeqb (%rcx), %xmm21, %k4

// CHECK: vpcmpeqb 291(%rax,%r14,8), %xmm21, %k4
// CHECK:  encoding: [0x62,0xb1,0x55,0x00,0x74,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpcmpeqb 291(%rax,%r14,8), %xmm21, %k4

// CHECK: vpcmpeqb 2032(%rdx), %xmm21, %k4
// CHECK:  encoding: [0x62,0xf1,0x55,0x00,0x74,0x62,0x7f]
          vpcmpeqb 2032(%rdx), %xmm21, %k4

// CHECK: vpcmpeqb 2048(%rdx), %xmm21, %k4
// CHECK:  encoding: [0x62,0xf1,0x55,0x00,0x74,0xa2,0x00,0x08,0x00,0x00]
          vpcmpeqb 2048(%rdx), %xmm21, %k4

// CHECK: vpcmpeqb -2048(%rdx), %xmm21, %k4
// CHECK:  encoding: [0x62,0xf1,0x55,0x00,0x74,0x62,0x80]
          vpcmpeqb -2048(%rdx), %xmm21, %k4

// CHECK: vpcmpeqb -2064(%rdx), %xmm21, %k4
// CHECK:  encoding: [0x62,0xf1,0x55,0x00,0x74,0xa2,0xf0,0xf7,0xff,0xff]
          vpcmpeqb -2064(%rdx), %xmm21, %k4

// CHECK: vpcmpeqb %ymm18, %ymm21, %k4
// CHECK:  encoding: [0x62,0xb1,0x55,0x20,0x74,0xe2]
          vpcmpeqb %ymm18, %ymm21, %k4

// CHECK: vpcmpeqb %ymm18, %ymm21, %k4 {%k1}
// CHECK:  encoding: [0x62,0xb1,0x55,0x21,0x74,0xe2]
          vpcmpeqb %ymm18, %ymm21, %k4 {%k1}

// CHECK: vpcmpeqb (%rcx), %ymm21, %k4
// CHECK:  encoding: [0x62,0xf1,0x55,0x20,0x74,0x21]
          vpcmpeqb (%rcx), %ymm21, %k4

// CHECK: vpcmpeqb 291(%rax,%r14,8), %ymm21, %k4
// CHECK:  encoding: [0x62,0xb1,0x55,0x20,0x74,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpcmpeqb 291(%rax,%r14,8), %ymm21, %k4

// CHECK: vpcmpeqb 4064(%rdx), %ymm21, %k4
// CHECK:  encoding: [0x62,0xf1,0x55,0x20,0x74,0x62,0x7f]
          vpcmpeqb 4064(%rdx), %ymm21, %k4

// CHECK: vpcmpeqb 4096(%rdx), %ymm21, %k4
// CHECK:  encoding: [0x62,0xf1,0x55,0x20,0x74,0xa2,0x00,0x10,0x00,0x00]
          vpcmpeqb 4096(%rdx), %ymm21, %k4

// CHECK: vpcmpeqb -4096(%rdx), %ymm21, %k4
// CHECK:  encoding: [0x62,0xf1,0x55,0x20,0x74,0x62,0x80]
          vpcmpeqb -4096(%rdx), %ymm21, %k4

// CHECK: vpcmpeqb -4128(%rdx), %ymm21, %k4
// CHECK:  encoding: [0x62,0xf1,0x55,0x20,0x74,0xa2,0xe0,0xef,0xff,0xff]
          vpcmpeqb -4128(%rdx), %ymm21, %k4

// CHECK: vpcmpeqw %xmm27, %xmm30, %k3
// CHECK:  encoding: [0x62,0x91,0x0d,0x00,0x75,0xdb]
          vpcmpeqw %xmm27, %xmm30, %k3

// CHECK: vpcmpeqw %xmm27, %xmm30, %k3 {%k1}
// CHECK:  encoding: [0x62,0x91,0x0d,0x01,0x75,0xdb]
          vpcmpeqw %xmm27, %xmm30, %k3 {%k1}

// CHECK: vpcmpeqw (%rcx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf1,0x0d,0x00,0x75,0x19]
          vpcmpeqw (%rcx), %xmm30, %k3

// CHECK: vpcmpeqw 291(%rax,%r14,8), %xmm30, %k3
// CHECK:  encoding: [0x62,0xb1,0x0d,0x00,0x75,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpcmpeqw 291(%rax,%r14,8), %xmm30, %k3

// CHECK: vpcmpeqw 2032(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf1,0x0d,0x00,0x75,0x5a,0x7f]
          vpcmpeqw 2032(%rdx), %xmm30, %k3

// CHECK: vpcmpeqw 2048(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf1,0x0d,0x00,0x75,0x9a,0x00,0x08,0x00,0x00]
          vpcmpeqw 2048(%rdx), %xmm30, %k3

// CHECK: vpcmpeqw -2048(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf1,0x0d,0x00,0x75,0x5a,0x80]
          vpcmpeqw -2048(%rdx), %xmm30, %k3

// CHECK: vpcmpeqw -2064(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf1,0x0d,0x00,0x75,0x9a,0xf0,0xf7,0xff,0xff]
          vpcmpeqw -2064(%rdx), %xmm30, %k3

// CHECK: vpcmpeqw %ymm29, %ymm20, %k2
// CHECK:  encoding: [0x62,0x91,0x5d,0x20,0x75,0xd5]
          vpcmpeqw %ymm29, %ymm20, %k2

// CHECK: vpcmpeqw %ymm29, %ymm20, %k2 {%k5}
// CHECK:  encoding: [0x62,0x91,0x5d,0x25,0x75,0xd5]
          vpcmpeqw %ymm29, %ymm20, %k2 {%k5}

// CHECK: vpcmpeqw (%rcx), %ymm20, %k2
// CHECK:  encoding: [0x62,0xf1,0x5d,0x20,0x75,0x11]
          vpcmpeqw (%rcx), %ymm20, %k2

// CHECK: vpcmpeqw 291(%rax,%r14,8), %ymm20, %k2
// CHECK:  encoding: [0x62,0xb1,0x5d,0x20,0x75,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpcmpeqw 291(%rax,%r14,8), %ymm20, %k2

// CHECK: vpcmpeqw 4064(%rdx), %ymm20, %k2
// CHECK:  encoding: [0x62,0xf1,0x5d,0x20,0x75,0x52,0x7f]
          vpcmpeqw 4064(%rdx), %ymm20, %k2

// CHECK: vpcmpeqw 4096(%rdx), %ymm20, %k2
// CHECK:  encoding: [0x62,0xf1,0x5d,0x20,0x75,0x92,0x00,0x10,0x00,0x00]
          vpcmpeqw 4096(%rdx), %ymm20, %k2

// CHECK: vpcmpeqw -4096(%rdx), %ymm20, %k2
// CHECK:  encoding: [0x62,0xf1,0x5d,0x20,0x75,0x52,0x80]
          vpcmpeqw -4096(%rdx), %ymm20, %k2

// CHECK: vpcmpeqw -4128(%rdx), %ymm20, %k2
// CHECK:  encoding: [0x62,0xf1,0x5d,0x20,0x75,0x92,0xe0,0xef,0xff,0xff]
          vpcmpeqw -4128(%rdx), %ymm20, %k2

// CHECK: vpcmpgtb %xmm17, %xmm30, %k3
// CHECK:  encoding: [0x62,0xb1,0x0d,0x00,0x64,0xd9]
          vpcmpgtb %xmm17, %xmm30, %k3

// CHECK: vpcmpgtb %xmm17, %xmm30, %k3 {%k7}
// CHECK:  encoding: [0x62,0xb1,0x0d,0x07,0x64,0xd9]
          vpcmpgtb %xmm17, %xmm30, %k3 {%k7}

// CHECK: vpcmpgtb (%rcx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf1,0x0d,0x00,0x64,0x19]
          vpcmpgtb (%rcx), %xmm30, %k3

// CHECK: vpcmpgtb 291(%rax,%r14,8), %xmm30, %k3
// CHECK:  encoding: [0x62,0xb1,0x0d,0x00,0x64,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpcmpgtb 291(%rax,%r14,8), %xmm30, %k3

// CHECK: vpcmpgtb 2032(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf1,0x0d,0x00,0x64,0x5a,0x7f]
          vpcmpgtb 2032(%rdx), %xmm30, %k3

// CHECK: vpcmpgtb 2048(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf1,0x0d,0x00,0x64,0x9a,0x00,0x08,0x00,0x00]
          vpcmpgtb 2048(%rdx), %xmm30, %k3

// CHECK: vpcmpgtb -2048(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf1,0x0d,0x00,0x64,0x5a,0x80]
          vpcmpgtb -2048(%rdx), %xmm30, %k3

// CHECK: vpcmpgtb -2064(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf1,0x0d,0x00,0x64,0x9a,0xf0,0xf7,0xff,0xff]
          vpcmpgtb -2064(%rdx), %xmm30, %k3

// CHECK: vpcmpgtb %ymm17, %ymm17, %k2
// CHECK:  encoding: [0x62,0xb1,0x75,0x20,0x64,0xd1]
          vpcmpgtb %ymm17, %ymm17, %k2

// CHECK: vpcmpgtb %ymm17, %ymm17, %k2 {%k4}
// CHECK:  encoding: [0x62,0xb1,0x75,0x24,0x64,0xd1]
          vpcmpgtb %ymm17, %ymm17, %k2 {%k4}

// CHECK: vpcmpgtb (%rcx), %ymm17, %k2
// CHECK:  encoding: [0x62,0xf1,0x75,0x20,0x64,0x11]
          vpcmpgtb (%rcx), %ymm17, %k2

// CHECK: vpcmpgtb 291(%rax,%r14,8), %ymm17, %k2
// CHECK:  encoding: [0x62,0xb1,0x75,0x20,0x64,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpcmpgtb 291(%rax,%r14,8), %ymm17, %k2

// CHECK: vpcmpgtb 4064(%rdx), %ymm17, %k2
// CHECK:  encoding: [0x62,0xf1,0x75,0x20,0x64,0x52,0x7f]
          vpcmpgtb 4064(%rdx), %ymm17, %k2

// CHECK: vpcmpgtb 4096(%rdx), %ymm17, %k2
// CHECK:  encoding: [0x62,0xf1,0x75,0x20,0x64,0x92,0x00,0x10,0x00,0x00]
          vpcmpgtb 4096(%rdx), %ymm17, %k2

// CHECK: vpcmpgtb -4096(%rdx), %ymm17, %k2
// CHECK:  encoding: [0x62,0xf1,0x75,0x20,0x64,0x52,0x80]
          vpcmpgtb -4096(%rdx), %ymm17, %k2

// CHECK: vpcmpgtb -4128(%rdx), %ymm17, %k2
// CHECK:  encoding: [0x62,0xf1,0x75,0x20,0x64,0x92,0xe0,0xef,0xff,0xff]
          vpcmpgtb -4128(%rdx), %ymm17, %k2

// CHECK: vpcmpgtw %xmm22, %xmm28, %k2
// CHECK:  encoding: [0x62,0xb1,0x1d,0x00,0x65,0xd6]
          vpcmpgtw %xmm22, %xmm28, %k2

// CHECK: vpcmpgtw %xmm22, %xmm28, %k2 {%k7}
// CHECK:  encoding: [0x62,0xb1,0x1d,0x07,0x65,0xd6]
          vpcmpgtw %xmm22, %xmm28, %k2 {%k7}

// CHECK: vpcmpgtw (%rcx), %xmm28, %k2
// CHECK:  encoding: [0x62,0xf1,0x1d,0x00,0x65,0x11]
          vpcmpgtw (%rcx), %xmm28, %k2

// CHECK: vpcmpgtw 291(%rax,%r14,8), %xmm28, %k2
// CHECK:  encoding: [0x62,0xb1,0x1d,0x00,0x65,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpcmpgtw 291(%rax,%r14,8), %xmm28, %k2

// CHECK: vpcmpgtw 2032(%rdx), %xmm28, %k2
// CHECK:  encoding: [0x62,0xf1,0x1d,0x00,0x65,0x52,0x7f]
          vpcmpgtw 2032(%rdx), %xmm28, %k2

// CHECK: vpcmpgtw 2048(%rdx), %xmm28, %k2
// CHECK:  encoding: [0x62,0xf1,0x1d,0x00,0x65,0x92,0x00,0x08,0x00,0x00]
          vpcmpgtw 2048(%rdx), %xmm28, %k2

// CHECK: vpcmpgtw -2048(%rdx), %xmm28, %k2
// CHECK:  encoding: [0x62,0xf1,0x1d,0x00,0x65,0x52,0x80]
          vpcmpgtw -2048(%rdx), %xmm28, %k2

// CHECK: vpcmpgtw -2064(%rdx), %xmm28, %k2
// CHECK:  encoding: [0x62,0xf1,0x1d,0x00,0x65,0x92,0xf0,0xf7,0xff,0xff]
          vpcmpgtw -2064(%rdx), %xmm28, %k2

// CHECK: vpcmpgtw %ymm26, %ymm20, %k5
// CHECK:  encoding: [0x62,0x91,0x5d,0x20,0x65,0xea]
          vpcmpgtw %ymm26, %ymm20, %k5

// CHECK: vpcmpgtw %ymm26, %ymm20, %k5 {%k2}
// CHECK:  encoding: [0x62,0x91,0x5d,0x22,0x65,0xea]
          vpcmpgtw %ymm26, %ymm20, %k5 {%k2}

// CHECK: vpcmpgtw (%rcx), %ymm20, %k5
// CHECK:  encoding: [0x62,0xf1,0x5d,0x20,0x65,0x29]
          vpcmpgtw (%rcx), %ymm20, %k5

// CHECK: vpcmpgtw 291(%rax,%r14,8), %ymm20, %k5
// CHECK:  encoding: [0x62,0xb1,0x5d,0x20,0x65,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpcmpgtw 291(%rax,%r14,8), %ymm20, %k5

// CHECK: vpcmpgtw 4064(%rdx), %ymm20, %k5
// CHECK:  encoding: [0x62,0xf1,0x5d,0x20,0x65,0x6a,0x7f]
          vpcmpgtw 4064(%rdx), %ymm20, %k5

// CHECK: vpcmpgtw 4096(%rdx), %ymm20, %k5
// CHECK:  encoding: [0x62,0xf1,0x5d,0x20,0x65,0xaa,0x00,0x10,0x00,0x00]
          vpcmpgtw 4096(%rdx), %ymm20, %k5

// CHECK: vpcmpgtw -4096(%rdx), %ymm20, %k5
// CHECK:  encoding: [0x62,0xf1,0x5d,0x20,0x65,0x6a,0x80]
          vpcmpgtw -4096(%rdx), %ymm20, %k5

// CHECK: vpcmpgtw -4128(%rdx), %ymm20, %k5
// CHECK:  encoding: [0x62,0xf1,0x5d,0x20,0x65,0xaa,0xe0,0xef,0xff,0xff]
          vpcmpgtw -4128(%rdx), %ymm20, %k5

// CHECK: vpcmpb $171, %xmm17, %xmm30, %k3
// CHECK:  encoding: [0x62,0xb3,0x0d,0x00,0x3f,0xd9,0xab]
          vpcmpb $171, %xmm17, %xmm30, %k3

// CHECK: vpcmpb $171, %xmm17, %xmm30, %k3 {%k1}
// CHECK:  encoding: [0x62,0xb3,0x0d,0x01,0x3f,0xd9,0xab]
          vpcmpb $171, %xmm17, %xmm30, %k3 {%k1}

// CHECK: vpcmpb $123, %xmm17, %xmm30, %k3
// CHECK:  encoding: [0x62,0xb3,0x0d,0x00,0x3f,0xd9,0x7b]
          vpcmpb $123, %xmm17, %xmm30, %k3

// CHECK: vpcmpb $123, (%rcx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x0d,0x00,0x3f,0x19,0x7b]
          vpcmpb $123, (%rcx), %xmm30, %k3

// CHECK: vpcmpb $123, 291(%rax,%r14,8), %xmm30, %k3
// CHECK:  encoding: [0x62,0xb3,0x0d,0x00,0x3f,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpb $123, 291(%rax,%r14,8), %xmm30, %k3

// CHECK: vpcmpb $123, 2032(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x0d,0x00,0x3f,0x5a,0x7f,0x7b]
          vpcmpb $123, 2032(%rdx), %xmm30, %k3

// CHECK: vpcmpb $123, 2048(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x0d,0x00,0x3f,0x9a,0x00,0x08,0x00,0x00,0x7b]
          vpcmpb $123, 2048(%rdx), %xmm30, %k3

// CHECK: vpcmpb $123, -2048(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x0d,0x00,0x3f,0x5a,0x80,0x7b]
          vpcmpb $123, -2048(%rdx), %xmm30, %k3

// CHECK: vpcmpb $123, -2064(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x0d,0x00,0x3f,0x9a,0xf0,0xf7,0xff,0xff,0x7b]
          vpcmpb $123, -2064(%rdx), %xmm30, %k3

// CHECK: vpcmpb $171, %ymm19, %ymm19, %k5
// CHECK:  encoding: [0x62,0xb3,0x65,0x20,0x3f,0xeb,0xab]
          vpcmpb $171, %ymm19, %ymm19, %k5

// CHECK: vpcmpb $171, %ymm19, %ymm19, %k5 {%k4}
// CHECK:  encoding: [0x62,0xb3,0x65,0x24,0x3f,0xeb,0xab]
          vpcmpb $171, %ymm19, %ymm19, %k5 {%k4}

// CHECK: vpcmpb $123, %ymm19, %ymm19, %k5
// CHECK:  encoding: [0x62,0xb3,0x65,0x20,0x3f,0xeb,0x7b]
          vpcmpb $123, %ymm19, %ymm19, %k5

// CHECK: vpcmpb $123, (%rcx), %ymm19, %k5
// CHECK:  encoding: [0x62,0xf3,0x65,0x20,0x3f,0x29,0x7b]
          vpcmpb $123, (%rcx), %ymm19, %k5

// CHECK: vpcmpb $123, 291(%rax,%r14,8), %ymm19, %k5
// CHECK:  encoding: [0x62,0xb3,0x65,0x20,0x3f,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpb $123, 291(%rax,%r14,8), %ymm19, %k5

// CHECK: vpcmpb $123, 4064(%rdx), %ymm19, %k5
// CHECK:  encoding: [0x62,0xf3,0x65,0x20,0x3f,0x6a,0x7f,0x7b]
          vpcmpb $123, 4064(%rdx), %ymm19, %k5

// CHECK: vpcmpb $123, 4096(%rdx), %ymm19, %k5
// CHECK:  encoding: [0x62,0xf3,0x65,0x20,0x3f,0xaa,0x00,0x10,0x00,0x00,0x7b]
          vpcmpb $123, 4096(%rdx), %ymm19, %k5

// CHECK: vpcmpb $123, -4096(%rdx), %ymm19, %k5
// CHECK:  encoding: [0x62,0xf3,0x65,0x20,0x3f,0x6a,0x80,0x7b]
          vpcmpb $123, -4096(%rdx), %ymm19, %k5

// CHECK: vpcmpb $123, -4128(%rdx), %ymm19, %k5
// CHECK:  encoding: [0x62,0xf3,0x65,0x20,0x3f,0xaa,0xe0,0xef,0xff,0xff,0x7b]
          vpcmpb $123, -4128(%rdx), %ymm19, %k5

// CHECK: vpcmpw $171, %xmm22, %xmm30, %k3
// CHECK:  encoding: [0x62,0xb3,0x8d,0x00,0x3f,0xde,0xab]
          vpcmpw $171, %xmm22, %xmm30, %k3

// CHECK: vpcmpw $171, %xmm22, %xmm30, %k3 {%k6}
// CHECK:  encoding: [0x62,0xb3,0x8d,0x06,0x3f,0xde,0xab]
          vpcmpw $171, %xmm22, %xmm30, %k3 {%k6}

// CHECK: vpcmpw $123, %xmm22, %xmm30, %k3
// CHECK:  encoding: [0x62,0xb3,0x8d,0x00,0x3f,0xde,0x7b]
          vpcmpw $123, %xmm22, %xmm30, %k3

// CHECK: vpcmpw $123, (%rcx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x8d,0x00,0x3f,0x19,0x7b]
          vpcmpw $123, (%rcx), %xmm30, %k3

// CHECK: vpcmpw $123, 291(%rax,%r14,8), %xmm30, %k3
// CHECK:  encoding: [0x62,0xb3,0x8d,0x00,0x3f,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpw $123, 291(%rax,%r14,8), %xmm30, %k3

// CHECK: vpcmpw $123, 2032(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x8d,0x00,0x3f,0x5a,0x7f,0x7b]
          vpcmpw $123, 2032(%rdx), %xmm30, %k3

// CHECK: vpcmpw $123, 2048(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x8d,0x00,0x3f,0x9a,0x00,0x08,0x00,0x00,0x7b]
          vpcmpw $123, 2048(%rdx), %xmm30, %k3

// CHECK: vpcmpw $123, -2048(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x8d,0x00,0x3f,0x5a,0x80,0x7b]
          vpcmpw $123, -2048(%rdx), %xmm30, %k3

// CHECK: vpcmpw $123, -2064(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x8d,0x00,0x3f,0x9a,0xf0,0xf7,0xff,0xff,0x7b]
          vpcmpw $123, -2064(%rdx), %xmm30, %k3

// CHECK: vpcmpw $171, %ymm18, %ymm26, %k3
// CHECK:  encoding: [0x62,0xb3,0xad,0x20,0x3f,0xda,0xab]
          vpcmpw $171, %ymm18, %ymm26, %k3

// CHECK: vpcmpw $171, %ymm18, %ymm26, %k3 {%k3}
// CHECK:  encoding: [0x62,0xb3,0xad,0x23,0x3f,0xda,0xab]
          vpcmpw $171, %ymm18, %ymm26, %k3 {%k3}

// CHECK: vpcmpw $123, %ymm18, %ymm26, %k3
// CHECK:  encoding: [0x62,0xb3,0xad,0x20,0x3f,0xda,0x7b]
          vpcmpw $123, %ymm18, %ymm26, %k3

// CHECK: vpcmpw $123, (%rcx), %ymm26, %k3
// CHECK:  encoding: [0x62,0xf3,0xad,0x20,0x3f,0x19,0x7b]
          vpcmpw $123, (%rcx), %ymm26, %k3

// CHECK: vpcmpw $123, 291(%rax,%r14,8), %ymm26, %k3
// CHECK:  encoding: [0x62,0xb3,0xad,0x20,0x3f,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpw $123, 291(%rax,%r14,8), %ymm26, %k3

// CHECK: vpcmpw $123, 4064(%rdx), %ymm26, %k3
// CHECK:  encoding: [0x62,0xf3,0xad,0x20,0x3f,0x5a,0x7f,0x7b]
          vpcmpw $123, 4064(%rdx), %ymm26, %k3

// CHECK: vpcmpw $123, 4096(%rdx), %ymm26, %k3
// CHECK:  encoding: [0x62,0xf3,0xad,0x20,0x3f,0x9a,0x00,0x10,0x00,0x00,0x7b]
          vpcmpw $123, 4096(%rdx), %ymm26, %k3

// CHECK: vpcmpw $123, -4096(%rdx), %ymm26, %k3
// CHECK:  encoding: [0x62,0xf3,0xad,0x20,0x3f,0x5a,0x80,0x7b]
          vpcmpw $123, -4096(%rdx), %ymm26, %k3

// CHECK: vpcmpw $123, -4128(%rdx), %ymm26, %k3
// CHECK:  encoding: [0x62,0xf3,0xad,0x20,0x3f,0x9a,0xe0,0xef,0xff,0xff,0x7b]
          vpcmpw $123, -4128(%rdx), %ymm26, %k3

// CHECK: vpcmpub $171, %xmm21, %xmm22, %k5
// CHECK:  encoding: [0x62,0xb3,0x4d,0x00,0x3e,0xed,0xab]
          vpcmpub $171, %xmm21, %xmm22, %k5

// CHECK: vpcmpub $171, %xmm21, %xmm22, %k5 {%k3}
// CHECK:  encoding: [0x62,0xb3,0x4d,0x03,0x3e,0xed,0xab]
          vpcmpub $171, %xmm21, %xmm22, %k5 {%k3}

// CHECK: vpcmpub $123, %xmm21, %xmm22, %k5
// CHECK:  encoding: [0x62,0xb3,0x4d,0x00,0x3e,0xed,0x7b]
          vpcmpub $123, %xmm21, %xmm22, %k5

// CHECK: vpcmpub $123, (%rcx), %xmm22, %k5
// CHECK:  encoding: [0x62,0xf3,0x4d,0x00,0x3e,0x29,0x7b]
          vpcmpub $123, (%rcx), %xmm22, %k5

// CHECK: vpcmpub $123, 291(%rax,%r14,8), %xmm22, %k5
// CHECK:  encoding: [0x62,0xb3,0x4d,0x00,0x3e,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpub $123, 291(%rax,%r14,8), %xmm22, %k5

// CHECK: vpcmpub $123, 2032(%rdx), %xmm22, %k5
// CHECK:  encoding: [0x62,0xf3,0x4d,0x00,0x3e,0x6a,0x7f,0x7b]
          vpcmpub $123, 2032(%rdx), %xmm22, %k5

// CHECK: vpcmpub $123, 2048(%rdx), %xmm22, %k5
// CHECK:  encoding: [0x62,0xf3,0x4d,0x00,0x3e,0xaa,0x00,0x08,0x00,0x00,0x7b]
          vpcmpub $123, 2048(%rdx), %xmm22, %k5

// CHECK: vpcmpub $123, -2048(%rdx), %xmm22, %k5
// CHECK:  encoding: [0x62,0xf3,0x4d,0x00,0x3e,0x6a,0x80,0x7b]
          vpcmpub $123, -2048(%rdx), %xmm22, %k5

// CHECK: vpcmpub $123, -2064(%rdx), %xmm22, %k5
// CHECK:  encoding: [0x62,0xf3,0x4d,0x00,0x3e,0xaa,0xf0,0xf7,0xff,0xff,0x7b]
          vpcmpub $123, -2064(%rdx), %xmm22, %k5

// CHECK: vpcmpub $171, %ymm21, %ymm23, %k2
// CHECK:  encoding: [0x62,0xb3,0x45,0x20,0x3e,0xd5,0xab]
          vpcmpub $171, %ymm21, %ymm23, %k2

// CHECK: vpcmpub $171, %ymm21, %ymm23, %k2 {%k2}
// CHECK:  encoding: [0x62,0xb3,0x45,0x22,0x3e,0xd5,0xab]
          vpcmpub $171, %ymm21, %ymm23, %k2 {%k2}

// CHECK: vpcmpub $123, %ymm21, %ymm23, %k2
// CHECK:  encoding: [0x62,0xb3,0x45,0x20,0x3e,0xd5,0x7b]
          vpcmpub $123, %ymm21, %ymm23, %k2

// CHECK: vpcmpub $123, (%rcx), %ymm23, %k2
// CHECK:  encoding: [0x62,0xf3,0x45,0x20,0x3e,0x11,0x7b]
          vpcmpub $123, (%rcx), %ymm23, %k2

// CHECK: vpcmpub $123, 291(%rax,%r14,8), %ymm23, %k2
// CHECK:  encoding: [0x62,0xb3,0x45,0x20,0x3e,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpub $123, 291(%rax,%r14,8), %ymm23, %k2

// CHECK: vpcmpub $123, 4064(%rdx), %ymm23, %k2
// CHECK:  encoding: [0x62,0xf3,0x45,0x20,0x3e,0x52,0x7f,0x7b]
          vpcmpub $123, 4064(%rdx), %ymm23, %k2

// CHECK: vpcmpub $123, 4096(%rdx), %ymm23, %k2
// CHECK:  encoding: [0x62,0xf3,0x45,0x20,0x3e,0x92,0x00,0x10,0x00,0x00,0x7b]
          vpcmpub $123, 4096(%rdx), %ymm23, %k2

// CHECK: vpcmpub $123, -4096(%rdx), %ymm23, %k2
// CHECK:  encoding: [0x62,0xf3,0x45,0x20,0x3e,0x52,0x80,0x7b]
          vpcmpub $123, -4096(%rdx), %ymm23, %k2

// CHECK: vpcmpub $123, -4128(%rdx), %ymm23, %k2
// CHECK:  encoding: [0x62,0xf3,0x45,0x20,0x3e,0x92,0xe0,0xef,0xff,0xff,0x7b]
          vpcmpub $123, -4128(%rdx), %ymm23, %k2

// CHECK: vpcmpuw $171, %xmm17, %xmm28, %k5
// CHECK:  encoding: [0x62,0xb3,0x9d,0x00,0x3e,0xe9,0xab]
          vpcmpuw $171, %xmm17, %xmm28, %k5

// CHECK: vpcmpuw $171, %xmm17, %xmm28, %k5 {%k4}
// CHECK:  encoding: [0x62,0xb3,0x9d,0x04,0x3e,0xe9,0xab]
          vpcmpuw $171, %xmm17, %xmm28, %k5 {%k4}

// CHECK: vpcmpuw $123, %xmm17, %xmm28, %k5
// CHECK:  encoding: [0x62,0xb3,0x9d,0x00,0x3e,0xe9,0x7b]
          vpcmpuw $123, %xmm17, %xmm28, %k5

// CHECK: vpcmpuw $123, (%rcx), %xmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x00,0x3e,0x29,0x7b]
          vpcmpuw $123, (%rcx), %xmm28, %k5

// CHECK: vpcmpuw $123, 291(%rax,%r14,8), %xmm28, %k5
// CHECK:  encoding: [0x62,0xb3,0x9d,0x00,0x3e,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpuw $123, 291(%rax,%r14,8), %xmm28, %k5

// CHECK: vpcmpuw $123, 2032(%rdx), %xmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x00,0x3e,0x6a,0x7f,0x7b]
          vpcmpuw $123, 2032(%rdx), %xmm28, %k5

// CHECK: vpcmpuw $123, 2048(%rdx), %xmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x00,0x3e,0xaa,0x00,0x08,0x00,0x00,0x7b]
          vpcmpuw $123, 2048(%rdx), %xmm28, %k5

// CHECK: vpcmpuw $123, -2048(%rdx), %xmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x00,0x3e,0x6a,0x80,0x7b]
          vpcmpuw $123, -2048(%rdx), %xmm28, %k5

// CHECK: vpcmpuw $123, -2064(%rdx), %xmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x00,0x3e,0xaa,0xf0,0xf7,0xff,0xff,0x7b]
          vpcmpuw $123, -2064(%rdx), %xmm28, %k5

// CHECK: vpcmpuw $171, %ymm28, %ymm27, %k4
// CHECK:  encoding: [0x62,0x93,0xa5,0x20,0x3e,0xe4,0xab]
          vpcmpuw $171, %ymm28, %ymm27, %k4

// CHECK: vpcmpuw $171, %ymm28, %ymm27, %k4 {%k2}
// CHECK:  encoding: [0x62,0x93,0xa5,0x22,0x3e,0xe4,0xab]
          vpcmpuw $171, %ymm28, %ymm27, %k4 {%k2}

// CHECK: vpcmpuw $123, %ymm28, %ymm27, %k4
// CHECK:  encoding: [0x62,0x93,0xa5,0x20,0x3e,0xe4,0x7b]
          vpcmpuw $123, %ymm28, %ymm27, %k4

// CHECK: vpcmpuw $123, (%rcx), %ymm27, %k4
// CHECK:  encoding: [0x62,0xf3,0xa5,0x20,0x3e,0x21,0x7b]
          vpcmpuw $123, (%rcx), %ymm27, %k4

// CHECK: vpcmpuw $123, 291(%rax,%r14,8), %ymm27, %k4
// CHECK:  encoding: [0x62,0xb3,0xa5,0x20,0x3e,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpuw $123, 291(%rax,%r14,8), %ymm27, %k4

// CHECK: vpcmpuw $123, 4064(%rdx), %ymm27, %k4
// CHECK:  encoding: [0x62,0xf3,0xa5,0x20,0x3e,0x62,0x7f,0x7b]
          vpcmpuw $123, 4064(%rdx), %ymm27, %k4

// CHECK: vpcmpuw $123, 4096(%rdx), %ymm27, %k4
// CHECK:  encoding: [0x62,0xf3,0xa5,0x20,0x3e,0xa2,0x00,0x10,0x00,0x00,0x7b]
          vpcmpuw $123, 4096(%rdx), %ymm27, %k4

// CHECK: vpcmpuw $123, -4096(%rdx), %ymm27, %k4
// CHECK:  encoding: [0x62,0xf3,0xa5,0x20,0x3e,0x62,0x80,0x7b]
          vpcmpuw $123, -4096(%rdx), %ymm27, %k4

// CHECK: vpcmpuw $123, -4128(%rdx), %ymm27, %k4
// CHECK:  encoding: [0x62,0xf3,0xa5,0x20,0x3e,0xa2,0xe0,0xef,0xff,0xff,0x7b]
          vpcmpuw $123, -4128(%rdx), %ymm27, %k4

// CHECK: vpmaxsb %xmm17, %xmm24, %xmm23
// CHECK:  encoding: [0x62,0xa2,0x3d,0x00,0x3c,0xf9]
          vpmaxsb %xmm17, %xmm24, %xmm23

// CHECK: vpmaxsb %xmm17, %xmm24, %xmm23 {%k3}
// CHECK:  encoding: [0x62,0xa2,0x3d,0x03,0x3c,0xf9]
          vpmaxsb %xmm17, %xmm24, %xmm23 {%k3}

// CHECK: vpmaxsb %xmm17, %xmm24, %xmm23 {%k3} {z}
// CHECK:  encoding: [0x62,0xa2,0x3d,0x83,0x3c,0xf9]
          vpmaxsb %xmm17, %xmm24, %xmm23 {%k3} {z}

// CHECK: vpmaxsb (%rcx), %xmm24, %xmm23
// CHECK:  encoding: [0x62,0xe2,0x3d,0x00,0x3c,0x39]
          vpmaxsb (%rcx), %xmm24, %xmm23

// CHECK: vpmaxsb 291(%rax,%r14,8), %xmm24, %xmm23
// CHECK:  encoding: [0x62,0xa2,0x3d,0x00,0x3c,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpmaxsb 291(%rax,%r14,8), %xmm24, %xmm23

// CHECK: vpmaxsb 2032(%rdx), %xmm24, %xmm23
// CHECK:  encoding: [0x62,0xe2,0x3d,0x00,0x3c,0x7a,0x7f]
          vpmaxsb 2032(%rdx), %xmm24, %xmm23

// CHECK: vpmaxsb 2048(%rdx), %xmm24, %xmm23
// CHECK:  encoding: [0x62,0xe2,0x3d,0x00,0x3c,0xba,0x00,0x08,0x00,0x00]
          vpmaxsb 2048(%rdx), %xmm24, %xmm23

// CHECK: vpmaxsb -2048(%rdx), %xmm24, %xmm23
// CHECK:  encoding: [0x62,0xe2,0x3d,0x00,0x3c,0x7a,0x80]
          vpmaxsb -2048(%rdx), %xmm24, %xmm23

// CHECK: vpmaxsb -2064(%rdx), %xmm24, %xmm23
// CHECK:  encoding: [0x62,0xe2,0x3d,0x00,0x3c,0xba,0xf0,0xf7,0xff,0xff]
          vpmaxsb -2064(%rdx), %xmm24, %xmm23

// CHECK: vpmaxsb %ymm27, %ymm22, %ymm30
// CHECK:  encoding: [0x62,0x02,0x4d,0x20,0x3c,0xf3]
          vpmaxsb %ymm27, %ymm22, %ymm30

// CHECK: vpmaxsb %ymm27, %ymm22, %ymm30 {%k5}
// CHECK:  encoding: [0x62,0x02,0x4d,0x25,0x3c,0xf3]
          vpmaxsb %ymm27, %ymm22, %ymm30 {%k5}

// CHECK: vpmaxsb %ymm27, %ymm22, %ymm30 {%k5} {z}
// CHECK:  encoding: [0x62,0x02,0x4d,0xa5,0x3c,0xf3]
          vpmaxsb %ymm27, %ymm22, %ymm30 {%k5} {z}

// CHECK: vpmaxsb (%rcx), %ymm22, %ymm30
// CHECK:  encoding: [0x62,0x62,0x4d,0x20,0x3c,0x31]
          vpmaxsb (%rcx), %ymm22, %ymm30

// CHECK: vpmaxsb 291(%rax,%r14,8), %ymm22, %ymm30
// CHECK:  encoding: [0x62,0x22,0x4d,0x20,0x3c,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmaxsb 291(%rax,%r14,8), %ymm22, %ymm30

// CHECK: vpmaxsb 4064(%rdx), %ymm22, %ymm30
// CHECK:  encoding: [0x62,0x62,0x4d,0x20,0x3c,0x72,0x7f]
          vpmaxsb 4064(%rdx), %ymm22, %ymm30

// CHECK: vpmaxsb 4096(%rdx), %ymm22, %ymm30
// CHECK:  encoding: [0x62,0x62,0x4d,0x20,0x3c,0xb2,0x00,0x10,0x00,0x00]
          vpmaxsb 4096(%rdx), %ymm22, %ymm30

// CHECK: vpmaxsb -4096(%rdx), %ymm22, %ymm30
// CHECK:  encoding: [0x62,0x62,0x4d,0x20,0x3c,0x72,0x80]
          vpmaxsb -4096(%rdx), %ymm22, %ymm30

// CHECK: vpmaxsb -4128(%rdx), %ymm22, %ymm30
// CHECK:  encoding: [0x62,0x62,0x4d,0x20,0x3c,0xb2,0xe0,0xef,0xff,0xff]
          vpmaxsb -4128(%rdx), %ymm22, %ymm30

// CHECK: vpmaxsw %xmm28, %xmm24, %xmm18
// CHECK:  encoding: [0x62,0x81,0x3d,0x00,0xee,0xd4]
          vpmaxsw %xmm28, %xmm24, %xmm18

// CHECK: vpmaxsw %xmm28, %xmm24, %xmm18 {%k3}
// CHECK:  encoding: [0x62,0x81,0x3d,0x03,0xee,0xd4]
          vpmaxsw %xmm28, %xmm24, %xmm18 {%k3}

// CHECK: vpmaxsw %xmm28, %xmm24, %xmm18 {%k3} {z}
// CHECK:  encoding: [0x62,0x81,0x3d,0x83,0xee,0xd4]
          vpmaxsw %xmm28, %xmm24, %xmm18 {%k3} {z}

// CHECK: vpmaxsw (%rcx), %xmm24, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x3d,0x00,0xee,0x11]
          vpmaxsw (%rcx), %xmm24, %xmm18

// CHECK: vpmaxsw 291(%rax,%r14,8), %xmm24, %xmm18
// CHECK:  encoding: [0x62,0xa1,0x3d,0x00,0xee,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpmaxsw 291(%rax,%r14,8), %xmm24, %xmm18

// CHECK: vpmaxsw 2032(%rdx), %xmm24, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x3d,0x00,0xee,0x52,0x7f]
          vpmaxsw 2032(%rdx), %xmm24, %xmm18

// CHECK: vpmaxsw 2048(%rdx), %xmm24, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x3d,0x00,0xee,0x92,0x00,0x08,0x00,0x00]
          vpmaxsw 2048(%rdx), %xmm24, %xmm18

// CHECK: vpmaxsw -2048(%rdx), %xmm24, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x3d,0x00,0xee,0x52,0x80]
          vpmaxsw -2048(%rdx), %xmm24, %xmm18

// CHECK: vpmaxsw -2064(%rdx), %xmm24, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x3d,0x00,0xee,0x92,0xf0,0xf7,0xff,0xff]
          vpmaxsw -2064(%rdx), %xmm24, %xmm18

// CHECK: vpmaxsw %ymm17, %ymm28, %ymm27
// CHECK:  encoding: [0x62,0x21,0x1d,0x20,0xee,0xd9]
          vpmaxsw %ymm17, %ymm28, %ymm27

// CHECK: vpmaxsw %ymm17, %ymm28, %ymm27 {%k6}
// CHECK:  encoding: [0x62,0x21,0x1d,0x26,0xee,0xd9]
          vpmaxsw %ymm17, %ymm28, %ymm27 {%k6}

// CHECK: vpmaxsw %ymm17, %ymm28, %ymm27 {%k6} {z}
// CHECK:  encoding: [0x62,0x21,0x1d,0xa6,0xee,0xd9]
          vpmaxsw %ymm17, %ymm28, %ymm27 {%k6} {z}

// CHECK: vpmaxsw (%rcx), %ymm28, %ymm27
// CHECK:  encoding: [0x62,0x61,0x1d,0x20,0xee,0x19]
          vpmaxsw (%rcx), %ymm28, %ymm27

// CHECK: vpmaxsw 291(%rax,%r14,8), %ymm28, %ymm27
// CHECK:  encoding: [0x62,0x21,0x1d,0x20,0xee,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpmaxsw 291(%rax,%r14,8), %ymm28, %ymm27

// CHECK: vpmaxsw 4064(%rdx), %ymm28, %ymm27
// CHECK:  encoding: [0x62,0x61,0x1d,0x20,0xee,0x5a,0x7f]
          vpmaxsw 4064(%rdx), %ymm28, %ymm27

// CHECK: vpmaxsw 4096(%rdx), %ymm28, %ymm27
// CHECK:  encoding: [0x62,0x61,0x1d,0x20,0xee,0x9a,0x00,0x10,0x00,0x00]
          vpmaxsw 4096(%rdx), %ymm28, %ymm27

// CHECK: vpmaxsw -4096(%rdx), %ymm28, %ymm27
// CHECK:  encoding: [0x62,0x61,0x1d,0x20,0xee,0x5a,0x80]
          vpmaxsw -4096(%rdx), %ymm28, %ymm27

// CHECK: vpmaxsw -4128(%rdx), %ymm28, %ymm27
// CHECK:  encoding: [0x62,0x61,0x1d,0x20,0xee,0x9a,0xe0,0xef,0xff,0xff]
          vpmaxsw -4128(%rdx), %ymm28, %ymm27

// CHECK: vpmaxub %xmm23, %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xa1,0x75,0x00,0xde,0xcf]
          vpmaxub %xmm23, %xmm17, %xmm17

// CHECK: vpmaxub %xmm23, %xmm17, %xmm17 {%k5}
// CHECK:  encoding: [0x62,0xa1,0x75,0x05,0xde,0xcf]
          vpmaxub %xmm23, %xmm17, %xmm17 {%k5}

// CHECK: vpmaxub %xmm23, %xmm17, %xmm17 {%k5} {z}
// CHECK:  encoding: [0x62,0xa1,0x75,0x85,0xde,0xcf]
          vpmaxub %xmm23, %xmm17, %xmm17 {%k5} {z}

// CHECK: vpmaxub (%rcx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x75,0x00,0xde,0x09]
          vpmaxub (%rcx), %xmm17, %xmm17

// CHECK: vpmaxub 291(%rax,%r14,8), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xa1,0x75,0x00,0xde,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpmaxub 291(%rax,%r14,8), %xmm17, %xmm17

// CHECK: vpmaxub 2032(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x75,0x00,0xde,0x4a,0x7f]
          vpmaxub 2032(%rdx), %xmm17, %xmm17

// CHECK: vpmaxub 2048(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x75,0x00,0xde,0x8a,0x00,0x08,0x00,0x00]
          vpmaxub 2048(%rdx), %xmm17, %xmm17

// CHECK: vpmaxub -2048(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x75,0x00,0xde,0x4a,0x80]
          vpmaxub -2048(%rdx), %xmm17, %xmm17

// CHECK: vpmaxub -2064(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x75,0x00,0xde,0x8a,0xf0,0xf7,0xff,0xff]
          vpmaxub -2064(%rdx), %xmm17, %xmm17

// CHECK: vpmaxub %ymm24, %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x01,0x2d,0x20,0xde,0xe0]
          vpmaxub %ymm24, %ymm26, %ymm28

// CHECK: vpmaxub %ymm24, %ymm26, %ymm28 {%k6}
// CHECK:  encoding: [0x62,0x01,0x2d,0x26,0xde,0xe0]
          vpmaxub %ymm24, %ymm26, %ymm28 {%k6}

// CHECK: vpmaxub %ymm24, %ymm26, %ymm28 {%k6} {z}
// CHECK:  encoding: [0x62,0x01,0x2d,0xa6,0xde,0xe0]
          vpmaxub %ymm24, %ymm26, %ymm28 {%k6} {z}

// CHECK: vpmaxub (%rcx), %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x61,0x2d,0x20,0xde,0x21]
          vpmaxub (%rcx), %ymm26, %ymm28

// CHECK: vpmaxub 291(%rax,%r14,8), %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x21,0x2d,0x20,0xde,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpmaxub 291(%rax,%r14,8), %ymm26, %ymm28

// CHECK: vpmaxub 4064(%rdx), %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x61,0x2d,0x20,0xde,0x62,0x7f]
          vpmaxub 4064(%rdx), %ymm26, %ymm28

// CHECK: vpmaxub 4096(%rdx), %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x61,0x2d,0x20,0xde,0xa2,0x00,0x10,0x00,0x00]
          vpmaxub 4096(%rdx), %ymm26, %ymm28

// CHECK: vpmaxub -4096(%rdx), %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x61,0x2d,0x20,0xde,0x62,0x80]
          vpmaxub -4096(%rdx), %ymm26, %ymm28

// CHECK: vpmaxub -4128(%rdx), %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x61,0x2d,0x20,0xde,0xa2,0xe0,0xef,0xff,0xff]
          vpmaxub -4128(%rdx), %ymm26, %ymm28

// CHECK: vpmaxuw %xmm20, %xmm18, %xmm24
// CHECK:  encoding: [0x62,0x22,0x6d,0x00,0x3e,0xc4]
          vpmaxuw %xmm20, %xmm18, %xmm24

// CHECK: vpmaxuw %xmm20, %xmm18, %xmm24 {%k7}
// CHECK:  encoding: [0x62,0x22,0x6d,0x07,0x3e,0xc4]
          vpmaxuw %xmm20, %xmm18, %xmm24 {%k7}

// CHECK: vpmaxuw %xmm20, %xmm18, %xmm24 {%k7} {z}
// CHECK:  encoding: [0x62,0x22,0x6d,0x87,0x3e,0xc4]
          vpmaxuw %xmm20, %xmm18, %xmm24 {%k7} {z}

// CHECK: vpmaxuw (%rcx), %xmm18, %xmm24
// CHECK:  encoding: [0x62,0x62,0x6d,0x00,0x3e,0x01]
          vpmaxuw (%rcx), %xmm18, %xmm24

// CHECK: vpmaxuw 291(%rax,%r14,8), %xmm18, %xmm24
// CHECK:  encoding: [0x62,0x22,0x6d,0x00,0x3e,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpmaxuw 291(%rax,%r14,8), %xmm18, %xmm24

// CHECK: vpmaxuw 2032(%rdx), %xmm18, %xmm24
// CHECK:  encoding: [0x62,0x62,0x6d,0x00,0x3e,0x42,0x7f]
          vpmaxuw 2032(%rdx), %xmm18, %xmm24

// CHECK: vpmaxuw 2048(%rdx), %xmm18, %xmm24
// CHECK:  encoding: [0x62,0x62,0x6d,0x00,0x3e,0x82,0x00,0x08,0x00,0x00]
          vpmaxuw 2048(%rdx), %xmm18, %xmm24

// CHECK: vpmaxuw -2048(%rdx), %xmm18, %xmm24
// CHECK:  encoding: [0x62,0x62,0x6d,0x00,0x3e,0x42,0x80]
          vpmaxuw -2048(%rdx), %xmm18, %xmm24

// CHECK: vpmaxuw -2064(%rdx), %xmm18, %xmm24
// CHECK:  encoding: [0x62,0x62,0x6d,0x00,0x3e,0x82,0xf0,0xf7,0xff,0xff]
          vpmaxuw -2064(%rdx), %xmm18, %xmm24

// CHECK: vpmaxuw %ymm19, %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xa2,0x4d,0x20,0x3e,0xdb]
          vpmaxuw %ymm19, %ymm22, %ymm19

// CHECK: vpmaxuw %ymm19, %ymm22, %ymm19 {%k7}
// CHECK:  encoding: [0x62,0xa2,0x4d,0x27,0x3e,0xdb]
          vpmaxuw %ymm19, %ymm22, %ymm19 {%k7}

// CHECK: vpmaxuw %ymm19, %ymm22, %ymm19 {%k7} {z}
// CHECK:  encoding: [0x62,0xa2,0x4d,0xa7,0x3e,0xdb]
          vpmaxuw %ymm19, %ymm22, %ymm19 {%k7} {z}

// CHECK: vpmaxuw (%rcx), %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x20,0x3e,0x19]
          vpmaxuw (%rcx), %ymm22, %ymm19

// CHECK: vpmaxuw 291(%rax,%r14,8), %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xa2,0x4d,0x20,0x3e,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpmaxuw 291(%rax,%r14,8), %ymm22, %ymm19

// CHECK: vpmaxuw 4064(%rdx), %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x20,0x3e,0x5a,0x7f]
          vpmaxuw 4064(%rdx), %ymm22, %ymm19

// CHECK: vpmaxuw 4096(%rdx), %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x20,0x3e,0x9a,0x00,0x10,0x00,0x00]
          vpmaxuw 4096(%rdx), %ymm22, %ymm19

// CHECK: vpmaxuw -4096(%rdx), %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x20,0x3e,0x5a,0x80]
          vpmaxuw -4096(%rdx), %ymm22, %ymm19

// CHECK: vpmaxuw -4128(%rdx), %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x20,0x3e,0x9a,0xe0,0xef,0xff,0xff]
          vpmaxuw -4128(%rdx), %ymm22, %ymm19

// CHECK: vpminsb %xmm27, %xmm28, %xmm25
// CHECK:  encoding: [0x62,0x02,0x1d,0x00,0x38,0xcb]
          vpminsb %xmm27, %xmm28, %xmm25

// CHECK: vpminsb %xmm27, %xmm28, %xmm25 {%k1}
// CHECK:  encoding: [0x62,0x02,0x1d,0x01,0x38,0xcb]
          vpminsb %xmm27, %xmm28, %xmm25 {%k1}

// CHECK: vpminsb %xmm27, %xmm28, %xmm25 {%k1} {z}
// CHECK:  encoding: [0x62,0x02,0x1d,0x81,0x38,0xcb]
          vpminsb %xmm27, %xmm28, %xmm25 {%k1} {z}

// CHECK: vpminsb (%rcx), %xmm28, %xmm25
// CHECK:  encoding: [0x62,0x62,0x1d,0x00,0x38,0x09]
          vpminsb (%rcx), %xmm28, %xmm25

// CHECK: vpminsb 291(%rax,%r14,8), %xmm28, %xmm25
// CHECK:  encoding: [0x62,0x22,0x1d,0x00,0x38,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpminsb 291(%rax,%r14,8), %xmm28, %xmm25

// CHECK: vpminsb 2032(%rdx), %xmm28, %xmm25
// CHECK:  encoding: [0x62,0x62,0x1d,0x00,0x38,0x4a,0x7f]
          vpminsb 2032(%rdx), %xmm28, %xmm25

// CHECK: vpminsb 2048(%rdx), %xmm28, %xmm25
// CHECK:  encoding: [0x62,0x62,0x1d,0x00,0x38,0x8a,0x00,0x08,0x00,0x00]
          vpminsb 2048(%rdx), %xmm28, %xmm25

// CHECK: vpminsb -2048(%rdx), %xmm28, %xmm25
// CHECK:  encoding: [0x62,0x62,0x1d,0x00,0x38,0x4a,0x80]
          vpminsb -2048(%rdx), %xmm28, %xmm25

// CHECK: vpminsb -2064(%rdx), %xmm28, %xmm25
// CHECK:  encoding: [0x62,0x62,0x1d,0x00,0x38,0x8a,0xf0,0xf7,0xff,0xff]
          vpminsb -2064(%rdx), %xmm28, %xmm25

// CHECK: vpminsb %ymm27, %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x02,0x5d,0x20,0x38,0xdb]
          vpminsb %ymm27, %ymm20, %ymm27

// CHECK: vpminsb %ymm27, %ymm20, %ymm27 {%k6}
// CHECK:  encoding: [0x62,0x02,0x5d,0x26,0x38,0xdb]
          vpminsb %ymm27, %ymm20, %ymm27 {%k6}

// CHECK: vpminsb %ymm27, %ymm20, %ymm27 {%k6} {z}
// CHECK:  encoding: [0x62,0x02,0x5d,0xa6,0x38,0xdb]
          vpminsb %ymm27, %ymm20, %ymm27 {%k6} {z}

// CHECK: vpminsb (%rcx), %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x62,0x5d,0x20,0x38,0x19]
          vpminsb (%rcx), %ymm20, %ymm27

// CHECK: vpminsb 291(%rax,%r14,8), %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x22,0x5d,0x20,0x38,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpminsb 291(%rax,%r14,8), %ymm20, %ymm27

// CHECK: vpminsb 4064(%rdx), %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x62,0x5d,0x20,0x38,0x5a,0x7f]
          vpminsb 4064(%rdx), %ymm20, %ymm27

// CHECK: vpminsb 4096(%rdx), %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x62,0x5d,0x20,0x38,0x9a,0x00,0x10,0x00,0x00]
          vpminsb 4096(%rdx), %ymm20, %ymm27

// CHECK: vpminsb -4096(%rdx), %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x62,0x5d,0x20,0x38,0x5a,0x80]
          vpminsb -4096(%rdx), %ymm20, %ymm27

// CHECK: vpminsb -4128(%rdx), %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x62,0x5d,0x20,0x38,0x9a,0xe0,0xef,0xff,0xff]
          vpminsb -4128(%rdx), %ymm20, %ymm27

// CHECK: vpminsw %xmm19, %xmm26, %xmm27
// CHECK:  encoding: [0x62,0x21,0x2d,0x00,0xea,0xdb]
          vpminsw %xmm19, %xmm26, %xmm27

// CHECK: vpminsw %xmm19, %xmm26, %xmm27 {%k2}
// CHECK:  encoding: [0x62,0x21,0x2d,0x02,0xea,0xdb]
          vpminsw %xmm19, %xmm26, %xmm27 {%k2}

// CHECK: vpminsw %xmm19, %xmm26, %xmm27 {%k2} {z}
// CHECK:  encoding: [0x62,0x21,0x2d,0x82,0xea,0xdb]
          vpminsw %xmm19, %xmm26, %xmm27 {%k2} {z}

// CHECK: vpminsw (%rcx), %xmm26, %xmm27
// CHECK:  encoding: [0x62,0x61,0x2d,0x00,0xea,0x19]
          vpminsw (%rcx), %xmm26, %xmm27

// CHECK: vpminsw 291(%rax,%r14,8), %xmm26, %xmm27
// CHECK:  encoding: [0x62,0x21,0x2d,0x00,0xea,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpminsw 291(%rax,%r14,8), %xmm26, %xmm27

// CHECK: vpminsw 2032(%rdx), %xmm26, %xmm27
// CHECK:  encoding: [0x62,0x61,0x2d,0x00,0xea,0x5a,0x7f]
          vpminsw 2032(%rdx), %xmm26, %xmm27

// CHECK: vpminsw 2048(%rdx), %xmm26, %xmm27
// CHECK:  encoding: [0x62,0x61,0x2d,0x00,0xea,0x9a,0x00,0x08,0x00,0x00]
          vpminsw 2048(%rdx), %xmm26, %xmm27

// CHECK: vpminsw -2048(%rdx), %xmm26, %xmm27
// CHECK:  encoding: [0x62,0x61,0x2d,0x00,0xea,0x5a,0x80]
          vpminsw -2048(%rdx), %xmm26, %xmm27

// CHECK: vpminsw -2064(%rdx), %xmm26, %xmm27
// CHECK:  encoding: [0x62,0x61,0x2d,0x00,0xea,0x9a,0xf0,0xf7,0xff,0xff]
          vpminsw -2064(%rdx), %xmm26, %xmm27

// CHECK: vpminsw %ymm27, %ymm23, %ymm21
// CHECK:  encoding: [0x62,0x81,0x45,0x20,0xea,0xeb]
          vpminsw %ymm27, %ymm23, %ymm21

// CHECK: vpminsw %ymm27, %ymm23, %ymm21 {%k2}
// CHECK:  encoding: [0x62,0x81,0x45,0x22,0xea,0xeb]
          vpminsw %ymm27, %ymm23, %ymm21 {%k2}

// CHECK: vpminsw %ymm27, %ymm23, %ymm21 {%k2} {z}
// CHECK:  encoding: [0x62,0x81,0x45,0xa2,0xea,0xeb]
          vpminsw %ymm27, %ymm23, %ymm21 {%k2} {z}

// CHECK: vpminsw (%rcx), %ymm23, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x45,0x20,0xea,0x29]
          vpminsw (%rcx), %ymm23, %ymm21

// CHECK: vpminsw 291(%rax,%r14,8), %ymm23, %ymm21
// CHECK:  encoding: [0x62,0xa1,0x45,0x20,0xea,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpminsw 291(%rax,%r14,8), %ymm23, %ymm21

// CHECK: vpminsw 4064(%rdx), %ymm23, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x45,0x20,0xea,0x6a,0x7f]
          vpminsw 4064(%rdx), %ymm23, %ymm21

// CHECK: vpminsw 4096(%rdx), %ymm23, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x45,0x20,0xea,0xaa,0x00,0x10,0x00,0x00]
          vpminsw 4096(%rdx), %ymm23, %ymm21

// CHECK: vpminsw -4096(%rdx), %ymm23, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x45,0x20,0xea,0x6a,0x80]
          vpminsw -4096(%rdx), %ymm23, %ymm21

// CHECK: vpminsw -4128(%rdx), %ymm23, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x45,0x20,0xea,0xaa,0xe0,0xef,0xff,0xff]
          vpminsw -4128(%rdx), %ymm23, %ymm21

// CHECK: vpminub %xmm27, %xmm27, %xmm22
// CHECK:  encoding: [0x62,0x81,0x25,0x00,0xda,0xf3]
          vpminub %xmm27, %xmm27, %xmm22

// CHECK: vpminub %xmm27, %xmm27, %xmm22 {%k5}
// CHECK:  encoding: [0x62,0x81,0x25,0x05,0xda,0xf3]
          vpminub %xmm27, %xmm27, %xmm22 {%k5}

// CHECK: vpminub %xmm27, %xmm27, %xmm22 {%k5} {z}
// CHECK:  encoding: [0x62,0x81,0x25,0x85,0xda,0xf3]
          vpminub %xmm27, %xmm27, %xmm22 {%k5} {z}

// CHECK: vpminub (%rcx), %xmm27, %xmm22
// CHECK:  encoding: [0x62,0xe1,0x25,0x00,0xda,0x31]
          vpminub (%rcx), %xmm27, %xmm22

// CHECK: vpminub 291(%rax,%r14,8), %xmm27, %xmm22
// CHECK:  encoding: [0x62,0xa1,0x25,0x00,0xda,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpminub 291(%rax,%r14,8), %xmm27, %xmm22

// CHECK: vpminub 2032(%rdx), %xmm27, %xmm22
// CHECK:  encoding: [0x62,0xe1,0x25,0x00,0xda,0x72,0x7f]
          vpminub 2032(%rdx), %xmm27, %xmm22

// CHECK: vpminub 2048(%rdx), %xmm27, %xmm22
// CHECK:  encoding: [0x62,0xe1,0x25,0x00,0xda,0xb2,0x00,0x08,0x00,0x00]
          vpminub 2048(%rdx), %xmm27, %xmm22

// CHECK: vpminub -2048(%rdx), %xmm27, %xmm22
// CHECK:  encoding: [0x62,0xe1,0x25,0x00,0xda,0x72,0x80]
          vpminub -2048(%rdx), %xmm27, %xmm22

// CHECK: vpminub -2064(%rdx), %xmm27, %xmm22
// CHECK:  encoding: [0x62,0xe1,0x25,0x00,0xda,0xb2,0xf0,0xf7,0xff,0xff]
          vpminub -2064(%rdx), %xmm27, %xmm22

// CHECK: vpminub %ymm27, %ymm25, %ymm27
// CHECK:  encoding: [0x62,0x01,0x35,0x20,0xda,0xdb]
          vpminub %ymm27, %ymm25, %ymm27

// CHECK: vpminub %ymm27, %ymm25, %ymm27 {%k3}
// CHECK:  encoding: [0x62,0x01,0x35,0x23,0xda,0xdb]
          vpminub %ymm27, %ymm25, %ymm27 {%k3}

// CHECK: vpminub %ymm27, %ymm25, %ymm27 {%k3} {z}
// CHECK:  encoding: [0x62,0x01,0x35,0xa3,0xda,0xdb]
          vpminub %ymm27, %ymm25, %ymm27 {%k3} {z}

// CHECK: vpminub (%rcx), %ymm25, %ymm27
// CHECK:  encoding: [0x62,0x61,0x35,0x20,0xda,0x19]
          vpminub (%rcx), %ymm25, %ymm27

// CHECK: vpminub 291(%rax,%r14,8), %ymm25, %ymm27
// CHECK:  encoding: [0x62,0x21,0x35,0x20,0xda,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpminub 291(%rax,%r14,8), %ymm25, %ymm27

// CHECK: vpminub 4064(%rdx), %ymm25, %ymm27
// CHECK:  encoding: [0x62,0x61,0x35,0x20,0xda,0x5a,0x7f]
          vpminub 4064(%rdx), %ymm25, %ymm27

// CHECK: vpminub 4096(%rdx), %ymm25, %ymm27
// CHECK:  encoding: [0x62,0x61,0x35,0x20,0xda,0x9a,0x00,0x10,0x00,0x00]
          vpminub 4096(%rdx), %ymm25, %ymm27

// CHECK: vpminub -4096(%rdx), %ymm25, %ymm27
// CHECK:  encoding: [0x62,0x61,0x35,0x20,0xda,0x5a,0x80]
          vpminub -4096(%rdx), %ymm25, %ymm27

// CHECK: vpminub -4128(%rdx), %ymm25, %ymm27
// CHECK:  encoding: [0x62,0x61,0x35,0x20,0xda,0x9a,0xe0,0xef,0xff,0xff]
          vpminub -4128(%rdx), %ymm25, %ymm27

// CHECK: vpminuw %xmm23, %xmm17, %xmm28
// CHECK:  encoding: [0x62,0x22,0x75,0x00,0x3a,0xe7]
          vpminuw %xmm23, %xmm17, %xmm28

// CHECK: vpminuw %xmm23, %xmm17, %xmm28 {%k2}
// CHECK:  encoding: [0x62,0x22,0x75,0x02,0x3a,0xe7]
          vpminuw %xmm23, %xmm17, %xmm28 {%k2}

// CHECK: vpminuw %xmm23, %xmm17, %xmm28 {%k2} {z}
// CHECK:  encoding: [0x62,0x22,0x75,0x82,0x3a,0xe7]
          vpminuw %xmm23, %xmm17, %xmm28 {%k2} {z}

// CHECK: vpminuw (%rcx), %xmm17, %xmm28
// CHECK:  encoding: [0x62,0x62,0x75,0x00,0x3a,0x21]
          vpminuw (%rcx), %xmm17, %xmm28

// CHECK: vpminuw 291(%rax,%r14,8), %xmm17, %xmm28
// CHECK:  encoding: [0x62,0x22,0x75,0x00,0x3a,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpminuw 291(%rax,%r14,8), %xmm17, %xmm28

// CHECK: vpminuw 2032(%rdx), %xmm17, %xmm28
// CHECK:  encoding: [0x62,0x62,0x75,0x00,0x3a,0x62,0x7f]
          vpminuw 2032(%rdx), %xmm17, %xmm28

// CHECK: vpminuw 2048(%rdx), %xmm17, %xmm28
// CHECK:  encoding: [0x62,0x62,0x75,0x00,0x3a,0xa2,0x00,0x08,0x00,0x00]
          vpminuw 2048(%rdx), %xmm17, %xmm28

// CHECK: vpminuw -2048(%rdx), %xmm17, %xmm28
// CHECK:  encoding: [0x62,0x62,0x75,0x00,0x3a,0x62,0x80]
          vpminuw -2048(%rdx), %xmm17, %xmm28

// CHECK: vpminuw -2064(%rdx), %xmm17, %xmm28
// CHECK:  encoding: [0x62,0x62,0x75,0x00,0x3a,0xa2,0xf0,0xf7,0xff,0xff]
          vpminuw -2064(%rdx), %xmm17, %xmm28

// CHECK: vpminuw %ymm18, %ymm27, %ymm20
// CHECK:  encoding: [0x62,0xa2,0x25,0x20,0x3a,0xe2]
          vpminuw %ymm18, %ymm27, %ymm20

// CHECK: vpminuw %ymm18, %ymm27, %ymm20 {%k7}
// CHECK:  encoding: [0x62,0xa2,0x25,0x27,0x3a,0xe2]
          vpminuw %ymm18, %ymm27, %ymm20 {%k7}

// CHECK: vpminuw %ymm18, %ymm27, %ymm20 {%k7} {z}
// CHECK:  encoding: [0x62,0xa2,0x25,0xa7,0x3a,0xe2]
          vpminuw %ymm18, %ymm27, %ymm20 {%k7} {z}

// CHECK: vpminuw (%rcx), %ymm27, %ymm20
// CHECK:  encoding: [0x62,0xe2,0x25,0x20,0x3a,0x21]
          vpminuw (%rcx), %ymm27, %ymm20

// CHECK: vpminuw 291(%rax,%r14,8), %ymm27, %ymm20
// CHECK:  encoding: [0x62,0xa2,0x25,0x20,0x3a,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpminuw 291(%rax,%r14,8), %ymm27, %ymm20

// CHECK: vpminuw 4064(%rdx), %ymm27, %ymm20
// CHECK:  encoding: [0x62,0xe2,0x25,0x20,0x3a,0x62,0x7f]
          vpminuw 4064(%rdx), %ymm27, %ymm20

// CHECK: vpminuw 4096(%rdx), %ymm27, %ymm20
// CHECK:  encoding: [0x62,0xe2,0x25,0x20,0x3a,0xa2,0x00,0x10,0x00,0x00]
          vpminuw 4096(%rdx), %ymm27, %ymm20

// CHECK: vpminuw -4096(%rdx), %ymm27, %ymm20
// CHECK:  encoding: [0x62,0xe2,0x25,0x20,0x3a,0x62,0x80]
          vpminuw -4096(%rdx), %ymm27, %ymm20

// CHECK: vpminuw -4128(%rdx), %ymm27, %ymm20
// CHECK:  encoding: [0x62,0xe2,0x25,0x20,0x3a,0xa2,0xe0,0xef,0xff,0xff]
          vpminuw -4128(%rdx), %ymm27, %ymm20

// CHECK: vpmullw %xmm26, %xmm19, %xmm29
// CHECK:  encoding: [0x62,0x01,0x65,0x00,0xd5,0xea]
          vpmullw %xmm26, %xmm19, %xmm29

// CHECK: vpmullw %xmm26, %xmm19, %xmm29 {%k7}
// CHECK:  encoding: [0x62,0x01,0x65,0x07,0xd5,0xea]
          vpmullw %xmm26, %xmm19, %xmm29 {%k7}

// CHECK: vpmullw %xmm26, %xmm19, %xmm29 {%k7} {z}
// CHECK:  encoding: [0x62,0x01,0x65,0x87,0xd5,0xea]
          vpmullw %xmm26, %xmm19, %xmm29 {%k7} {z}

// CHECK: vpmullw (%rcx), %xmm19, %xmm29
// CHECK:  encoding: [0x62,0x61,0x65,0x00,0xd5,0x29]
          vpmullw (%rcx), %xmm19, %xmm29

// CHECK: vpmullw 291(%rax,%r14,8), %xmm19, %xmm29
// CHECK:  encoding: [0x62,0x21,0x65,0x00,0xd5,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpmullw 291(%rax,%r14,8), %xmm19, %xmm29

// CHECK: vpmullw 2032(%rdx), %xmm19, %xmm29
// CHECK:  encoding: [0x62,0x61,0x65,0x00,0xd5,0x6a,0x7f]
          vpmullw 2032(%rdx), %xmm19, %xmm29

// CHECK: vpmullw 2048(%rdx), %xmm19, %xmm29
// CHECK:  encoding: [0x62,0x61,0x65,0x00,0xd5,0xaa,0x00,0x08,0x00,0x00]
          vpmullw 2048(%rdx), %xmm19, %xmm29

// CHECK: vpmullw -2048(%rdx), %xmm19, %xmm29
// CHECK:  encoding: [0x62,0x61,0x65,0x00,0xd5,0x6a,0x80]
          vpmullw -2048(%rdx), %xmm19, %xmm29

// CHECK: vpmullw -2064(%rdx), %xmm19, %xmm29
// CHECK:  encoding: [0x62,0x61,0x65,0x00,0xd5,0xaa,0xf0,0xf7,0xff,0xff]
          vpmullw -2064(%rdx), %xmm19, %xmm29

// CHECK: vpmullw %ymm20, %ymm24, %ymm17
// CHECK:  encoding: [0x62,0xa1,0x3d,0x20,0xd5,0xcc]
          vpmullw %ymm20, %ymm24, %ymm17

// CHECK: vpmullw %ymm20, %ymm24, %ymm17 {%k5}
// CHECK:  encoding: [0x62,0xa1,0x3d,0x25,0xd5,0xcc]
          vpmullw %ymm20, %ymm24, %ymm17 {%k5}

// CHECK: vpmullw %ymm20, %ymm24, %ymm17 {%k5} {z}
// CHECK:  encoding: [0x62,0xa1,0x3d,0xa5,0xd5,0xcc]
          vpmullw %ymm20, %ymm24, %ymm17 {%k5} {z}

// CHECK: vpmullw (%rcx), %ymm24, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x3d,0x20,0xd5,0x09]
          vpmullw (%rcx), %ymm24, %ymm17

// CHECK: vpmullw 291(%rax,%r14,8), %ymm24, %ymm17
// CHECK:  encoding: [0x62,0xa1,0x3d,0x20,0xd5,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpmullw 291(%rax,%r14,8), %ymm24, %ymm17

// CHECK: vpmullw 4064(%rdx), %ymm24, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x3d,0x20,0xd5,0x4a,0x7f]
          vpmullw 4064(%rdx), %ymm24, %ymm17

// CHECK: vpmullw 4096(%rdx), %ymm24, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x3d,0x20,0xd5,0x8a,0x00,0x10,0x00,0x00]
          vpmullw 4096(%rdx), %ymm24, %ymm17

// CHECK: vpmullw -4096(%rdx), %ymm24, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x3d,0x20,0xd5,0x4a,0x80]
          vpmullw -4096(%rdx), %ymm24, %ymm17

// CHECK: vpmullw -4128(%rdx), %ymm24, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x3d,0x20,0xd5,0x8a,0xe0,0xef,0xff,0xff]
          vpmullw -4128(%rdx), %ymm24, %ymm17

// CHECK: vpsubb %xmm28, %xmm29, %xmm27
// CHECK:  encoding: [0x62,0x01,0x15,0x00,0xf8,0xdc]
          vpsubb %xmm28, %xmm29, %xmm27

// CHECK: vpsubb %xmm28, %xmm29, %xmm27 {%k3}
// CHECK:  encoding: [0x62,0x01,0x15,0x03,0xf8,0xdc]
          vpsubb %xmm28, %xmm29, %xmm27 {%k3}

// CHECK: vpsubb %xmm28, %xmm29, %xmm27 {%k3} {z}
// CHECK:  encoding: [0x62,0x01,0x15,0x83,0xf8,0xdc]
          vpsubb %xmm28, %xmm29, %xmm27 {%k3} {z}

// CHECK: vpsubb (%rcx), %xmm29, %xmm27
// CHECK:  encoding: [0x62,0x61,0x15,0x00,0xf8,0x19]
          vpsubb (%rcx), %xmm29, %xmm27

// CHECK: vpsubb 291(%rax,%r14,8), %xmm29, %xmm27
// CHECK:  encoding: [0x62,0x21,0x15,0x00,0xf8,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpsubb 291(%rax,%r14,8), %xmm29, %xmm27

// CHECK: vpsubb 2032(%rdx), %xmm29, %xmm27
// CHECK:  encoding: [0x62,0x61,0x15,0x00,0xf8,0x5a,0x7f]
          vpsubb 2032(%rdx), %xmm29, %xmm27

// CHECK: vpsubb 2048(%rdx), %xmm29, %xmm27
// CHECK:  encoding: [0x62,0x61,0x15,0x00,0xf8,0x9a,0x00,0x08,0x00,0x00]
          vpsubb 2048(%rdx), %xmm29, %xmm27

// CHECK: vpsubb -2048(%rdx), %xmm29, %xmm27
// CHECK:  encoding: [0x62,0x61,0x15,0x00,0xf8,0x5a,0x80]
          vpsubb -2048(%rdx), %xmm29, %xmm27

// CHECK: vpsubb -2064(%rdx), %xmm29, %xmm27
// CHECK:  encoding: [0x62,0x61,0x15,0x00,0xf8,0x9a,0xf0,0xf7,0xff,0xff]
          vpsubb -2064(%rdx), %xmm29, %xmm27

// CHECK: vpsubb %ymm28, %ymm20, %ymm20
// CHECK:  encoding: [0x62,0x81,0x5d,0x20,0xf8,0xe4]
          vpsubb %ymm28, %ymm20, %ymm20

// CHECK: vpsubb %ymm28, %ymm20, %ymm20 {%k2}
// CHECK:  encoding: [0x62,0x81,0x5d,0x22,0xf8,0xe4]
          vpsubb %ymm28, %ymm20, %ymm20 {%k2}

// CHECK: vpsubb %ymm28, %ymm20, %ymm20 {%k2} {z}
// CHECK:  encoding: [0x62,0x81,0x5d,0xa2,0xf8,0xe4]
          vpsubb %ymm28, %ymm20, %ymm20 {%k2} {z}

// CHECK: vpsubb (%rcx), %ymm20, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x5d,0x20,0xf8,0x21]
          vpsubb (%rcx), %ymm20, %ymm20

// CHECK: vpsubb 291(%rax,%r14,8), %ymm20, %ymm20
// CHECK:  encoding: [0x62,0xa1,0x5d,0x20,0xf8,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpsubb 291(%rax,%r14,8), %ymm20, %ymm20

// CHECK: vpsubb 4064(%rdx), %ymm20, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x5d,0x20,0xf8,0x62,0x7f]
          vpsubb 4064(%rdx), %ymm20, %ymm20

// CHECK: vpsubb 4096(%rdx), %ymm20, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x5d,0x20,0xf8,0xa2,0x00,0x10,0x00,0x00]
          vpsubb 4096(%rdx), %ymm20, %ymm20

// CHECK: vpsubb -4096(%rdx), %ymm20, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x5d,0x20,0xf8,0x62,0x80]
          vpsubb -4096(%rdx), %ymm20, %ymm20

// CHECK: vpsubb -4128(%rdx), %ymm20, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x5d,0x20,0xf8,0xa2,0xe0,0xef,0xff,0xff]
          vpsubb -4128(%rdx), %ymm20, %ymm20

// CHECK: vpsubw %xmm18, %xmm22, %xmm17
// CHECK:  encoding: [0x62,0xa1,0x4d,0x00,0xf9,0xca]
          vpsubw %xmm18, %xmm22, %xmm17

// CHECK: vpsubw %xmm18, %xmm22, %xmm17 {%k6}
// CHECK:  encoding: [0x62,0xa1,0x4d,0x06,0xf9,0xca]
          vpsubw %xmm18, %xmm22, %xmm17 {%k6}

// CHECK: vpsubw %xmm18, %xmm22, %xmm17 {%k6} {z}
// CHECK:  encoding: [0x62,0xa1,0x4d,0x86,0xf9,0xca]
          vpsubw %xmm18, %xmm22, %xmm17 {%k6} {z}

// CHECK: vpsubw (%rcx), %xmm22, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x4d,0x00,0xf9,0x09]
          vpsubw (%rcx), %xmm22, %xmm17

// CHECK: vpsubw 291(%rax,%r14,8), %xmm22, %xmm17
// CHECK:  encoding: [0x62,0xa1,0x4d,0x00,0xf9,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpsubw 291(%rax,%r14,8), %xmm22, %xmm17

// CHECK: vpsubw 2032(%rdx), %xmm22, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x4d,0x00,0xf9,0x4a,0x7f]
          vpsubw 2032(%rdx), %xmm22, %xmm17

// CHECK: vpsubw 2048(%rdx), %xmm22, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x4d,0x00,0xf9,0x8a,0x00,0x08,0x00,0x00]
          vpsubw 2048(%rdx), %xmm22, %xmm17

// CHECK: vpsubw -2048(%rdx), %xmm22, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x4d,0x00,0xf9,0x4a,0x80]
          vpsubw -2048(%rdx), %xmm22, %xmm17

// CHECK: vpsubw -2064(%rdx), %xmm22, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x4d,0x00,0xf9,0x8a,0xf0,0xf7,0xff,0xff]
          vpsubw -2064(%rdx), %xmm22, %xmm17

// CHECK: vpsubw %ymm24, %ymm29, %ymm17
// CHECK:  encoding: [0x62,0x81,0x15,0x20,0xf9,0xc8]
          vpsubw %ymm24, %ymm29, %ymm17

// CHECK: vpsubw %ymm24, %ymm29, %ymm17 {%k2}
// CHECK:  encoding: [0x62,0x81,0x15,0x22,0xf9,0xc8]
          vpsubw %ymm24, %ymm29, %ymm17 {%k2}

// CHECK: vpsubw %ymm24, %ymm29, %ymm17 {%k2} {z}
// CHECK:  encoding: [0x62,0x81,0x15,0xa2,0xf9,0xc8]
          vpsubw %ymm24, %ymm29, %ymm17 {%k2} {z}

// CHECK: vpsubw (%rcx), %ymm29, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x15,0x20,0xf9,0x09]
          vpsubw (%rcx), %ymm29, %ymm17

// CHECK: vpsubw 291(%rax,%r14,8), %ymm29, %ymm17
// CHECK:  encoding: [0x62,0xa1,0x15,0x20,0xf9,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpsubw 291(%rax,%r14,8), %ymm29, %ymm17

// CHECK: vpsubw 4064(%rdx), %ymm29, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x15,0x20,0xf9,0x4a,0x7f]
          vpsubw 4064(%rdx), %ymm29, %ymm17

// CHECK: vpsubw 4096(%rdx), %ymm29, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x15,0x20,0xf9,0x8a,0x00,0x10,0x00,0x00]
          vpsubw 4096(%rdx), %ymm29, %ymm17

// CHECK: vpsubw -4096(%rdx), %ymm29, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x15,0x20,0xf9,0x4a,0x80]
          vpsubw -4096(%rdx), %ymm29, %ymm17

// CHECK: vpsubw -4128(%rdx), %ymm29, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x15,0x20,0xf9,0x8a,0xe0,0xef,0xff,0xff]
          vpsubw -4128(%rdx), %ymm29, %ymm17

// CHECK: vmovdqu8 %xmm23, %xmm26
// CHECK:  encoding: [0x62,0x21,0x7f,0x08,0x6f,0xd7]
          vmovdqu8 %xmm23, %xmm26

// CHECK: vmovdqu8 %xmm23, %xmm26 {%k2}
// CHECK:  encoding: [0x62,0x21,0x7f,0x0a,0x6f,0xd7]
          vmovdqu8 %xmm23, %xmm26 {%k2}

// CHECK: vmovdqu8 %xmm23, %xmm26 {%k2} {z}
// CHECK:  encoding: [0x62,0x21,0x7f,0x8a,0x6f,0xd7]
          vmovdqu8 %xmm23, %xmm26 {%k2} {z}

// CHECK: vmovdqu8 (%rcx), %xmm26
// CHECK:  encoding: [0x62,0x61,0x7f,0x08,0x6f,0x11]
          vmovdqu8 (%rcx), %xmm26

// CHECK: vmovdqu8 291(%rax,%r14,8), %xmm26
// CHECK:  encoding: [0x62,0x21,0x7f,0x08,0x6f,0x94,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu8 291(%rax,%r14,8), %xmm26

// CHECK: vmovdqu8 2032(%rdx), %xmm26
// CHECK:  encoding: [0x62,0x61,0x7f,0x08,0x6f,0x52,0x7f]
          vmovdqu8 2032(%rdx), %xmm26

// CHECK: vmovdqu8 2048(%rdx), %xmm26
// CHECK:  encoding: [0x62,0x61,0x7f,0x08,0x6f,0x92,0x00,0x08,0x00,0x00]
          vmovdqu8 2048(%rdx), %xmm26

// CHECK: vmovdqu8 -2048(%rdx), %xmm26
// CHECK:  encoding: [0x62,0x61,0x7f,0x08,0x6f,0x52,0x80]
          vmovdqu8 -2048(%rdx), %xmm26

// CHECK: vmovdqu8 -2064(%rdx), %xmm26
// CHECK:  encoding: [0x62,0x61,0x7f,0x08,0x6f,0x92,0xf0,0xf7,0xff,0xff]
          vmovdqu8 -2064(%rdx), %xmm26

// CHECK: vmovdqu8 %ymm29, %ymm18
// CHECK:  encoding: [0x62,0x81,0x7f,0x28,0x6f,0xd5]
          vmovdqu8 %ymm29, %ymm18

// CHECK: vmovdqu8 %ymm29, %ymm18 {%k7}
// CHECK:  encoding: [0x62,0x81,0x7f,0x2f,0x6f,0xd5]
          vmovdqu8 %ymm29, %ymm18 {%k7}

// CHECK: vmovdqu8 %ymm29, %ymm18 {%k7} {z}
// CHECK:  encoding: [0x62,0x81,0x7f,0xaf,0x6f,0xd5]
          vmovdqu8 %ymm29, %ymm18 {%k7} {z}

// CHECK: vmovdqu8 (%rcx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0x7f,0x28,0x6f,0x11]
          vmovdqu8 (%rcx), %ymm18

// CHECK: vmovdqu8 291(%rax,%r14,8), %ymm18
// CHECK:  encoding: [0x62,0xa1,0x7f,0x28,0x6f,0x94,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu8 291(%rax,%r14,8), %ymm18

// CHECK: vmovdqu8 4064(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0x7f,0x28,0x6f,0x52,0x7f]
          vmovdqu8 4064(%rdx), %ymm18

// CHECK: vmovdqu8 4096(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0x7f,0x28,0x6f,0x92,0x00,0x10,0x00,0x00]
          vmovdqu8 4096(%rdx), %ymm18

// CHECK: vmovdqu8 -4096(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0x7f,0x28,0x6f,0x52,0x80]
          vmovdqu8 -4096(%rdx), %ymm18

// CHECK: vmovdqu8 -4128(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0x7f,0x28,0x6f,0x92,0xe0,0xef,0xff,0xff]
          vmovdqu8 -4128(%rdx), %ymm18

// CHECK: vmovdqu16 %xmm24, %xmm29
// CHECK:  encoding: [0x62,0x01,0xff,0x08,0x6f,0xe8]
          vmovdqu16 %xmm24, %xmm29

// CHECK: vmovdqu16 %xmm24, %xmm29 {%k6}
// CHECK:  encoding: [0x62,0x01,0xff,0x0e,0x6f,0xe8]
          vmovdqu16 %xmm24, %xmm29 {%k6}

// CHECK: vmovdqu16 %xmm24, %xmm29 {%k6} {z}
// CHECK:  encoding: [0x62,0x01,0xff,0x8e,0x6f,0xe8]
          vmovdqu16 %xmm24, %xmm29 {%k6} {z}

// CHECK: vmovdqu16 (%rcx), %xmm29
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x6f,0x29]
          vmovdqu16 (%rcx), %xmm29

// CHECK: vmovdqu16 291(%rax,%r14,8), %xmm29
// CHECK:  encoding: [0x62,0x21,0xff,0x08,0x6f,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu16 291(%rax,%r14,8), %xmm29

// CHECK: vmovdqu16 2032(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x6f,0x6a,0x7f]
          vmovdqu16 2032(%rdx), %xmm29

// CHECK: vmovdqu16 2048(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x6f,0xaa,0x00,0x08,0x00,0x00]
          vmovdqu16 2048(%rdx), %xmm29

// CHECK: vmovdqu16 -2048(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x6f,0x6a,0x80]
          vmovdqu16 -2048(%rdx), %xmm29

// CHECK: vmovdqu16 -2064(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x6f,0xaa,0xf0,0xf7,0xff,0xff]
          vmovdqu16 -2064(%rdx), %xmm29

// CHECK: vmovdqu16 %ymm24, %ymm23
// CHECK:  encoding: [0x62,0x81,0xff,0x28,0x6f,0xf8]
          vmovdqu16 %ymm24, %ymm23

// CHECK: vmovdqu16 %ymm24, %ymm23 {%k3}
// CHECK:  encoding: [0x62,0x81,0xff,0x2b,0x6f,0xf8]
          vmovdqu16 %ymm24, %ymm23 {%k3}

// CHECK: vmovdqu16 %ymm24, %ymm23 {%k3} {z}
// CHECK:  encoding: [0x62,0x81,0xff,0xab,0x6f,0xf8]
          vmovdqu16 %ymm24, %ymm23 {%k3} {z}

// CHECK: vmovdqu16 (%rcx), %ymm23
// CHECK:  encoding: [0x62,0xe1,0xff,0x28,0x6f,0x39]
          vmovdqu16 (%rcx), %ymm23

// CHECK: vmovdqu16 291(%rax,%r14,8), %ymm23
// CHECK:  encoding: [0x62,0xa1,0xff,0x28,0x6f,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu16 291(%rax,%r14,8), %ymm23

// CHECK: vmovdqu16 4064(%rdx), %ymm23
// CHECK:  encoding: [0x62,0xe1,0xff,0x28,0x6f,0x7a,0x7f]
          vmovdqu16 4064(%rdx), %ymm23

// CHECK: vmovdqu16 4096(%rdx), %ymm23
// CHECK:  encoding: [0x62,0xe1,0xff,0x28,0x6f,0xba,0x00,0x10,0x00,0x00]
          vmovdqu16 4096(%rdx), %ymm23

// CHECK: vmovdqu16 -4096(%rdx), %ymm23
// CHECK:  encoding: [0x62,0xe1,0xff,0x28,0x6f,0x7a,0x80]
          vmovdqu16 -4096(%rdx), %ymm23

// CHECK: vmovdqu16 -4128(%rdx), %ymm23
// CHECK:  encoding: [0x62,0xe1,0xff,0x28,0x6f,0xba,0xe0,0xef,0xff,0xff]
          vmovdqu16 -4128(%rdx), %ymm23

// CHECK: vmovdqu8 %xmm17, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0x7f,0x08,0x7f,0x09]
          vmovdqu8 %xmm17, (%rcx)

// CHECK: vmovdqu8 %xmm17, (%rcx) {%k4}
// CHECK:  encoding: [0x62,0xe1,0x7f,0x0c,0x7f,0x09]
          vmovdqu8 %xmm17, (%rcx) {%k4}

// CHECK: vmovdqu8 %xmm17, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0x7f,0x08,0x7f,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu8 %xmm17, 291(%rax,%r14,8)

// CHECK: vmovdqu8 %xmm17, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7f,0x08,0x7f,0x4a,0x7f]
          vmovdqu8 %xmm17, 2032(%rdx)

// CHECK: vmovdqu8 %xmm17, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7f,0x08,0x7f,0x8a,0x00,0x08,0x00,0x00]
          vmovdqu8 %xmm17, 2048(%rdx)

// CHECK: vmovdqu8 %xmm17, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7f,0x08,0x7f,0x4a,0x80]
          vmovdqu8 %xmm17, -2048(%rdx)

// CHECK: vmovdqu8 %xmm17, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7f,0x08,0x7f,0x8a,0xf0,0xf7,0xff,0xff]
          vmovdqu8 %xmm17, -2064(%rdx)

// CHECK: vmovdqu8 %ymm21, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0x7f,0x28,0x7f,0x29]
          vmovdqu8 %ymm21, (%rcx)

// CHECK: vmovdqu8 %ymm21, (%rcx) {%k1}
// CHECK:  encoding: [0x62,0xe1,0x7f,0x29,0x7f,0x29]
          vmovdqu8 %ymm21, (%rcx) {%k1}

// CHECK: vmovdqu8 %ymm21, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0x7f,0x28,0x7f,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu8 %ymm21, 291(%rax,%r14,8)

// CHECK: vmovdqu8 %ymm21, 4064(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7f,0x28,0x7f,0x6a,0x7f]
          vmovdqu8 %ymm21, 4064(%rdx)

// CHECK: vmovdqu8 %ymm21, 4096(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7f,0x28,0x7f,0xaa,0x00,0x10,0x00,0x00]
          vmovdqu8 %ymm21, 4096(%rdx)

// CHECK: vmovdqu8 %ymm21, -4096(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7f,0x28,0x7f,0x6a,0x80]
          vmovdqu8 %ymm21, -4096(%rdx)

// CHECK: vmovdqu8 %ymm21, -4128(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7f,0x28,0x7f,0xaa,0xe0,0xef,0xff,0xff]
          vmovdqu8 %ymm21, -4128(%rdx)

// CHECK: vmovdqu16 %xmm23, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0xff,0x08,0x7f,0x39]
          vmovdqu16 %xmm23, (%rcx)

// CHECK: vmovdqu16 %xmm23, (%rcx) {%k7}
// CHECK:  encoding: [0x62,0xe1,0xff,0x0f,0x7f,0x39]
          vmovdqu16 %xmm23, (%rcx) {%k7}

// CHECK: vmovdqu16 %xmm23, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0xff,0x08,0x7f,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu16 %xmm23, 291(%rax,%r14,8)

// CHECK: vmovdqu16 %xmm23, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xff,0x08,0x7f,0x7a,0x7f]
          vmovdqu16 %xmm23, 2032(%rdx)

// CHECK: vmovdqu16 %xmm23, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xff,0x08,0x7f,0xba,0x00,0x08,0x00,0x00]
          vmovdqu16 %xmm23, 2048(%rdx)

// CHECK: vmovdqu16 %xmm23, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xff,0x08,0x7f,0x7a,0x80]
          vmovdqu16 %xmm23, -2048(%rdx)

// CHECK: vmovdqu16 %xmm23, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xff,0x08,0x7f,0xba,0xf0,0xf7,0xff,0xff]
          vmovdqu16 %xmm23, -2064(%rdx)

// CHECK: vmovdqu16 %ymm29, (%rcx)
// CHECK:  encoding: [0x62,0x61,0xff,0x28,0x7f,0x29]
          vmovdqu16 %ymm29, (%rcx)

// CHECK: vmovdqu16 %ymm29, (%rcx) {%k6}
// CHECK:  encoding: [0x62,0x61,0xff,0x2e,0x7f,0x29]
          vmovdqu16 %ymm29, (%rcx) {%k6}

// CHECK: vmovdqu16 %ymm29, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x21,0xff,0x28,0x7f,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu16 %ymm29, 291(%rax,%r14,8)

// CHECK: vmovdqu16 %ymm29, 4064(%rdx)
// CHECK:  encoding: [0x62,0x61,0xff,0x28,0x7f,0x6a,0x7f]
          vmovdqu16 %ymm29, 4064(%rdx)

// CHECK: vmovdqu16 %ymm29, 4096(%rdx)
// CHECK:  encoding: [0x62,0x61,0xff,0x28,0x7f,0xaa,0x00,0x10,0x00,0x00]
          vmovdqu16 %ymm29, 4096(%rdx)

// CHECK: vmovdqu16 %ymm29, -4096(%rdx)
// CHECK:  encoding: [0x62,0x61,0xff,0x28,0x7f,0x6a,0x80]
          vmovdqu16 %ymm29, -4096(%rdx)

// CHECK: vmovdqu16 %ymm29, -4128(%rdx)
// CHECK:  encoding: [0x62,0x61,0xff,0x28,0x7f,0xaa,0xe0,0xef,0xff,0xff]
          vmovdqu16 %ymm29, -4128(%rdx)

// CHECK: vpsllw %xmm26, %xmm23, %xmm19
// CHECK:  encoding: [0x62,0x81,0x45,0x00,0xf1,0xda]
          vpsllw %xmm26, %xmm23, %xmm19

// CHECK: vpsllw %xmm26, %xmm23, %xmm19 {%k7}
// CHECK:  encoding: [0x62,0x81,0x45,0x07,0xf1,0xda]
          vpsllw %xmm26, %xmm23, %xmm19 {%k7}

// CHECK: vpsllw %xmm26, %xmm23, %xmm19 {%k7} {z}
// CHECK:  encoding: [0x62,0x81,0x45,0x87,0xf1,0xda]
          vpsllw %xmm26, %xmm23, %xmm19 {%k7} {z}

// CHECK: vpsllw (%rcx), %xmm23, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x45,0x00,0xf1,0x19]
          vpsllw (%rcx), %xmm23, %xmm19

// CHECK: vpsllw 291(%rax,%r14,8), %xmm23, %xmm19
// CHECK:  encoding: [0x62,0xa1,0x45,0x00,0xf1,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpsllw 291(%rax,%r14,8), %xmm23, %xmm19

// CHECK: vpsllw 2032(%rdx), %xmm23, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x45,0x00,0xf1,0x5a,0x7f]
          vpsllw 2032(%rdx), %xmm23, %xmm19

// CHECK: vpsllw 2048(%rdx), %xmm23, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x45,0x00,0xf1,0x9a,0x00,0x08,0x00,0x00]
          vpsllw 2048(%rdx), %xmm23, %xmm19

// CHECK: vpsllw -2048(%rdx), %xmm23, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x45,0x00,0xf1,0x5a,0x80]
          vpsllw -2048(%rdx), %xmm23, %xmm19

// CHECK: vpsllw -2064(%rdx), %xmm23, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x45,0x00,0xf1,0x9a,0xf0,0xf7,0xff,0xff]
          vpsllw -2064(%rdx), %xmm23, %xmm19

// CHECK: vpsllw %xmm26, %ymm21, %ymm20
// CHECK:  encoding: [0x62,0x81,0x55,0x20,0xf1,0xe2]
          vpsllw %xmm26, %ymm21, %ymm20

// CHECK: vpsllw %xmm26, %ymm21, %ymm20 {%k7}
// CHECK:  encoding: [0x62,0x81,0x55,0x27,0xf1,0xe2]
          vpsllw %xmm26, %ymm21, %ymm20 {%k7}

// CHECK: vpsllw %xmm26, %ymm21, %ymm20 {%k7} {z}
// CHECK:  encoding: [0x62,0x81,0x55,0xa7,0xf1,0xe2]
          vpsllw %xmm26, %ymm21, %ymm20 {%k7} {z}

// CHECK: vpsllw (%rcx), %ymm21, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x55,0x20,0xf1,0x21]
          vpsllw (%rcx), %ymm21, %ymm20

// CHECK: vpsllw 291(%rax,%r14,8), %ymm21, %ymm20
// CHECK:  encoding: [0x62,0xa1,0x55,0x20,0xf1,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpsllw 291(%rax,%r14,8), %ymm21, %ymm20

// CHECK: vpsllw 2032(%rdx), %ymm21, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x55,0x20,0xf1,0x62,0x7f]
          vpsllw 2032(%rdx), %ymm21, %ymm20

// CHECK: vpsllw 2048(%rdx), %ymm21, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x55,0x20,0xf1,0xa2,0x00,0x08,0x00,0x00]
          vpsllw 2048(%rdx), %ymm21, %ymm20

// CHECK: vpsllw -2048(%rdx), %ymm21, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x55,0x20,0xf1,0x62,0x80]
          vpsllw -2048(%rdx), %ymm21, %ymm20

// CHECK: vpsllw -2064(%rdx), %ymm21, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x55,0x20,0xf1,0xa2,0xf0,0xf7,0xff,0xff]
          vpsllw -2064(%rdx), %ymm21, %ymm20

// CHECK: vpsraw %xmm28, %xmm28, %xmm17
// CHECK:  encoding: [0x62,0x81,0x1d,0x00,0xe1,0xcc]
          vpsraw %xmm28, %xmm28, %xmm17

// CHECK: vpsraw %xmm28, %xmm28, %xmm17 {%k1}
// CHECK:  encoding: [0x62,0x81,0x1d,0x01,0xe1,0xcc]
          vpsraw %xmm28, %xmm28, %xmm17 {%k1}

// CHECK: vpsraw %xmm28, %xmm28, %xmm17 {%k1} {z}
// CHECK:  encoding: [0x62,0x81,0x1d,0x81,0xe1,0xcc]
          vpsraw %xmm28, %xmm28, %xmm17 {%k1} {z}

// CHECK: vpsraw (%rcx), %xmm28, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x1d,0x00,0xe1,0x09]
          vpsraw (%rcx), %xmm28, %xmm17

// CHECK: vpsraw 291(%rax,%r14,8), %xmm28, %xmm17
// CHECK:  encoding: [0x62,0xa1,0x1d,0x00,0xe1,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpsraw 291(%rax,%r14,8), %xmm28, %xmm17

// CHECK: vpsraw 2032(%rdx), %xmm28, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x1d,0x00,0xe1,0x4a,0x7f]
          vpsraw 2032(%rdx), %xmm28, %xmm17

// CHECK: vpsraw 2048(%rdx), %xmm28, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x1d,0x00,0xe1,0x8a,0x00,0x08,0x00,0x00]
          vpsraw 2048(%rdx), %xmm28, %xmm17

// CHECK: vpsraw -2048(%rdx), %xmm28, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x1d,0x00,0xe1,0x4a,0x80]
          vpsraw -2048(%rdx), %xmm28, %xmm17

// CHECK: vpsraw -2064(%rdx), %xmm28, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x1d,0x00,0xe1,0x8a,0xf0,0xf7,0xff,0xff]
          vpsraw -2064(%rdx), %xmm28, %xmm17

// CHECK: vpsraw %xmm19, %ymm26, %ymm18
// CHECK:  encoding: [0x62,0xa1,0x2d,0x20,0xe1,0xd3]
          vpsraw %xmm19, %ymm26, %ymm18

// CHECK: vpsraw %xmm19, %ymm26, %ymm18 {%k7}
// CHECK:  encoding: [0x62,0xa1,0x2d,0x27,0xe1,0xd3]
          vpsraw %xmm19, %ymm26, %ymm18 {%k7}

// CHECK: vpsraw %xmm19, %ymm26, %ymm18 {%k7} {z}
// CHECK:  encoding: [0x62,0xa1,0x2d,0xa7,0xe1,0xd3]
          vpsraw %xmm19, %ymm26, %ymm18 {%k7} {z}

// CHECK: vpsraw (%rcx), %ymm26, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x2d,0x20,0xe1,0x11]
          vpsraw (%rcx), %ymm26, %ymm18

// CHECK: vpsraw 291(%rax,%r14,8), %ymm26, %ymm18
// CHECK:  encoding: [0x62,0xa1,0x2d,0x20,0xe1,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpsraw 291(%rax,%r14,8), %ymm26, %ymm18

// CHECK: vpsraw 2032(%rdx), %ymm26, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x2d,0x20,0xe1,0x52,0x7f]
          vpsraw 2032(%rdx), %ymm26, %ymm18

// CHECK: vpsraw 2048(%rdx), %ymm26, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x2d,0x20,0xe1,0x92,0x00,0x08,0x00,0x00]
          vpsraw 2048(%rdx), %ymm26, %ymm18

// CHECK: vpsraw -2048(%rdx), %ymm26, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x2d,0x20,0xe1,0x52,0x80]
          vpsraw -2048(%rdx), %ymm26, %ymm18

// CHECK: vpsraw -2064(%rdx), %ymm26, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x2d,0x20,0xe1,0x92,0xf0,0xf7,0xff,0xff]
          vpsraw -2064(%rdx), %ymm26, %ymm18

// CHECK: vpsrlw %xmm27, %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x01,0x15,0x00,0xd1,0xf3]
          vpsrlw %xmm27, %xmm29, %xmm30

// CHECK: vpsrlw %xmm27, %xmm29, %xmm30 {%k1}
// CHECK:  encoding: [0x62,0x01,0x15,0x01,0xd1,0xf3]
          vpsrlw %xmm27, %xmm29, %xmm30 {%k1}

// CHECK: vpsrlw %xmm27, %xmm29, %xmm30 {%k1} {z}
// CHECK:  encoding: [0x62,0x01,0x15,0x81,0xd1,0xf3]
          vpsrlw %xmm27, %xmm29, %xmm30 {%k1} {z}

// CHECK: vpsrlw (%rcx), %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x61,0x15,0x00,0xd1,0x31]
          vpsrlw (%rcx), %xmm29, %xmm30

// CHECK: vpsrlw 291(%rax,%r14,8), %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x21,0x15,0x00,0xd1,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpsrlw 291(%rax,%r14,8), %xmm29, %xmm30

// CHECK: vpsrlw 2032(%rdx), %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x61,0x15,0x00,0xd1,0x72,0x7f]
          vpsrlw 2032(%rdx), %xmm29, %xmm30

// CHECK: vpsrlw 2048(%rdx), %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x61,0x15,0x00,0xd1,0xb2,0x00,0x08,0x00,0x00]
          vpsrlw 2048(%rdx), %xmm29, %xmm30

// CHECK: vpsrlw -2048(%rdx), %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x61,0x15,0x00,0xd1,0x72,0x80]
          vpsrlw -2048(%rdx), %xmm29, %xmm30

// CHECK: vpsrlw -2064(%rdx), %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x61,0x15,0x00,0xd1,0xb2,0xf0,0xf7,0xff,0xff]
          vpsrlw -2064(%rdx), %xmm29, %xmm30

// CHECK: vpsrlw %xmm27, %ymm18, %ymm28
// CHECK:  encoding: [0x62,0x01,0x6d,0x20,0xd1,0xe3]
          vpsrlw %xmm27, %ymm18, %ymm28

// CHECK: vpsrlw %xmm27, %ymm18, %ymm28 {%k2}
// CHECK:  encoding: [0x62,0x01,0x6d,0x22,0xd1,0xe3]
          vpsrlw %xmm27, %ymm18, %ymm28 {%k2}

// CHECK: vpsrlw %xmm27, %ymm18, %ymm28 {%k2} {z}
// CHECK:  encoding: [0x62,0x01,0x6d,0xa2,0xd1,0xe3]
          vpsrlw %xmm27, %ymm18, %ymm28 {%k2} {z}

// CHECK: vpsrlw (%rcx), %ymm18, %ymm28
// CHECK:  encoding: [0x62,0x61,0x6d,0x20,0xd1,0x21]
          vpsrlw (%rcx), %ymm18, %ymm28

// CHECK: vpsrlw 291(%rax,%r14,8), %ymm18, %ymm28
// CHECK:  encoding: [0x62,0x21,0x6d,0x20,0xd1,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpsrlw 291(%rax,%r14,8), %ymm18, %ymm28

// CHECK: vpsrlw 2032(%rdx), %ymm18, %ymm28
// CHECK:  encoding: [0x62,0x61,0x6d,0x20,0xd1,0x62,0x7f]
          vpsrlw 2032(%rdx), %ymm18, %ymm28

// CHECK: vpsrlw 2048(%rdx), %ymm18, %ymm28
// CHECK:  encoding: [0x62,0x61,0x6d,0x20,0xd1,0xa2,0x00,0x08,0x00,0x00]
          vpsrlw 2048(%rdx), %ymm18, %ymm28

// CHECK: vpsrlw -2048(%rdx), %ymm18, %ymm28
// CHECK:  encoding: [0x62,0x61,0x6d,0x20,0xd1,0x62,0x80]
          vpsrlw -2048(%rdx), %ymm18, %ymm28

// CHECK: vpsrlw -2064(%rdx), %ymm18, %ymm28
// CHECK:  encoding: [0x62,0x61,0x6d,0x20,0xd1,0xa2,0xf0,0xf7,0xff,0xff]
          vpsrlw -2064(%rdx), %ymm18, %ymm28

// CHECK: vpsrlw $171, %xmm21, %xmm22
// CHECK:  encoding: [0x62,0xb1,0x4d,0x00,0x71,0xd5,0xab]
          vpsrlw $171, %xmm21, %xmm22

// CHECK: vpsrlw $171, %xmm21, %xmm22 {%k7}
// CHECK:  encoding: [0x62,0xb1,0x4d,0x07,0x71,0xd5,0xab]
          vpsrlw $171, %xmm21, %xmm22 {%k7}

// CHECK: vpsrlw $171, %xmm21, %xmm22 {%k7} {z}
// CHECK:  encoding: [0x62,0xb1,0x4d,0x87,0x71,0xd5,0xab]
          vpsrlw $171, %xmm21, %xmm22 {%k7} {z}

// CHECK: vpsrlw $123, %xmm21, %xmm22
// CHECK:  encoding: [0x62,0xb1,0x4d,0x00,0x71,0xd5,0x7b]
          vpsrlw $123, %xmm21, %xmm22

// CHECK: vpsrlw $123, (%rcx), %xmm22
// CHECK:  encoding: [0x62,0xf1,0x4d,0x00,0x71,0x11,0x7b]
          vpsrlw $123, (%rcx), %xmm22

// CHECK: vpsrlw $123, 291(%rax,%r14,8), %xmm22
// CHECK:  encoding: [0x62,0xb1,0x4d,0x00,0x71,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpsrlw $123, 291(%rax,%r14,8), %xmm22

// CHECK: vpsrlw $123, 2032(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xf1,0x4d,0x00,0x71,0x52,0x7f,0x7b]
          vpsrlw $123, 2032(%rdx), %xmm22

// CHECK: vpsrlw $123, 2048(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xf1,0x4d,0x00,0x71,0x92,0x00,0x08,0x00,0x00,0x7b]
          vpsrlw $123, 2048(%rdx), %xmm22

// CHECK: vpsrlw $123, -2048(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xf1,0x4d,0x00,0x71,0x52,0x80,0x7b]
          vpsrlw $123, -2048(%rdx), %xmm22

// CHECK: vpsrlw $123, -2064(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xf1,0x4d,0x00,0x71,0x92,0xf0,0xf7,0xff,0xff,0x7b]
          vpsrlw $123, -2064(%rdx), %xmm22

// CHECK: vpsrlw $171, %ymm19, %ymm27
// CHECK:  encoding: [0x62,0xb1,0x25,0x20,0x71,0xd3,0xab]
          vpsrlw $171, %ymm19, %ymm27

// CHECK: vpsrlw $171, %ymm19, %ymm27 {%k3}
// CHECK:  encoding: [0x62,0xb1,0x25,0x23,0x71,0xd3,0xab]
          vpsrlw $171, %ymm19, %ymm27 {%k3}

// CHECK: vpsrlw $171, %ymm19, %ymm27 {%k3} {z}
// CHECK:  encoding: [0x62,0xb1,0x25,0xa3,0x71,0xd3,0xab]
          vpsrlw $171, %ymm19, %ymm27 {%k3} {z}

// CHECK: vpsrlw $123, %ymm19, %ymm27
// CHECK:  encoding: [0x62,0xb1,0x25,0x20,0x71,0xd3,0x7b]
          vpsrlw $123, %ymm19, %ymm27

// CHECK: vpsrlw $123, (%rcx), %ymm27
// CHECK:  encoding: [0x62,0xf1,0x25,0x20,0x71,0x11,0x7b]
          vpsrlw $123, (%rcx), %ymm27

// CHECK: vpsrlw $123, 291(%rax,%r14,8), %ymm27
// CHECK:  encoding: [0x62,0xb1,0x25,0x20,0x71,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpsrlw $123, 291(%rax,%r14,8), %ymm27

// CHECK: vpsrlw $123, 4064(%rdx), %ymm27
// CHECK:  encoding: [0x62,0xf1,0x25,0x20,0x71,0x52,0x7f,0x7b]
          vpsrlw $123, 4064(%rdx), %ymm27

// CHECK: vpsrlw $123, 4096(%rdx), %ymm27
// CHECK:  encoding: [0x62,0xf1,0x25,0x20,0x71,0x92,0x00,0x10,0x00,0x00,0x7b]
          vpsrlw $123, 4096(%rdx), %ymm27

// CHECK: vpsrlw $123, -4096(%rdx), %ymm27
// CHECK:  encoding: [0x62,0xf1,0x25,0x20,0x71,0x52,0x80,0x7b]
          vpsrlw $123, -4096(%rdx), %ymm27

// CHECK: vpsrlw $123, -4128(%rdx), %ymm27
// CHECK:  encoding: [0x62,0xf1,0x25,0x20,0x71,0x92,0xe0,0xef,0xff,0xff,0x7b]
          vpsrlw $123, -4128(%rdx), %ymm27

// CHECK: vpsraw $171, %xmm22, %xmm22
// CHECK:  encoding: [0x62,0xb1,0x4d,0x00,0x71,0xe6,0xab]
          vpsraw $171, %xmm22, %xmm22

// CHECK: vpsraw $171, %xmm22, %xmm22 {%k4}
// CHECK:  encoding: [0x62,0xb1,0x4d,0x04,0x71,0xe6,0xab]
          vpsraw $171, %xmm22, %xmm22 {%k4}

// CHECK: vpsraw $171, %xmm22, %xmm22 {%k4} {z}
// CHECK:  encoding: [0x62,0xb1,0x4d,0x84,0x71,0xe6,0xab]
          vpsraw $171, %xmm22, %xmm22 {%k4} {z}

// CHECK: vpsraw $123, %xmm22, %xmm22
// CHECK:  encoding: [0x62,0xb1,0x4d,0x00,0x71,0xe6,0x7b]
          vpsraw $123, %xmm22, %xmm22

// CHECK: vpsraw $123, (%rcx), %xmm22
// CHECK:  encoding: [0x62,0xf1,0x4d,0x00,0x71,0x21,0x7b]
          vpsraw $123, (%rcx), %xmm22

// CHECK: vpsraw $123, 291(%rax,%r14,8), %xmm22
// CHECK:  encoding: [0x62,0xb1,0x4d,0x00,0x71,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpsraw $123, 291(%rax,%r14,8), %xmm22

// CHECK: vpsraw $123, 2032(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xf1,0x4d,0x00,0x71,0x62,0x7f,0x7b]
          vpsraw $123, 2032(%rdx), %xmm22

// CHECK: vpsraw $123, 2048(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xf1,0x4d,0x00,0x71,0xa2,0x00,0x08,0x00,0x00,0x7b]
          vpsraw $123, 2048(%rdx), %xmm22

// CHECK: vpsraw $123, -2048(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xf1,0x4d,0x00,0x71,0x62,0x80,0x7b]
          vpsraw $123, -2048(%rdx), %xmm22

// CHECK: vpsraw $123, -2064(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xf1,0x4d,0x00,0x71,0xa2,0xf0,0xf7,0xff,0xff,0x7b]
          vpsraw $123, -2064(%rdx), %xmm22

// CHECK: vpsraw $171, %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xb1,0x65,0x20,0x71,0xe6,0xab]
          vpsraw $171, %ymm22, %ymm19

// CHECK: vpsraw $171, %ymm22, %ymm19 {%k7}
// CHECK:  encoding: [0x62,0xb1,0x65,0x27,0x71,0xe6,0xab]
          vpsraw $171, %ymm22, %ymm19 {%k7}

// CHECK: vpsraw $171, %ymm22, %ymm19 {%k7} {z}
// CHECK:  encoding: [0x62,0xb1,0x65,0xa7,0x71,0xe6,0xab]
          vpsraw $171, %ymm22, %ymm19 {%k7} {z}

// CHECK: vpsraw $123, %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xb1,0x65,0x20,0x71,0xe6,0x7b]
          vpsraw $123, %ymm22, %ymm19

// CHECK: vpsraw $123, (%rcx), %ymm19
// CHECK:  encoding: [0x62,0xf1,0x65,0x20,0x71,0x21,0x7b]
          vpsraw $123, (%rcx), %ymm19

// CHECK: vpsraw $123, 291(%rax,%r14,8), %ymm19
// CHECK:  encoding: [0x62,0xb1,0x65,0x20,0x71,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpsraw $123, 291(%rax,%r14,8), %ymm19

// CHECK: vpsraw $123, 4064(%rdx), %ymm19
// CHECK:  encoding: [0x62,0xf1,0x65,0x20,0x71,0x62,0x7f,0x7b]
          vpsraw $123, 4064(%rdx), %ymm19

// CHECK: vpsraw $123, 4096(%rdx), %ymm19
// CHECK:  encoding: [0x62,0xf1,0x65,0x20,0x71,0xa2,0x00,0x10,0x00,0x00,0x7b]
          vpsraw $123, 4096(%rdx), %ymm19

// CHECK: vpsraw $123, -4096(%rdx), %ymm19
// CHECK:  encoding: [0x62,0xf1,0x65,0x20,0x71,0x62,0x80,0x7b]
          vpsraw $123, -4096(%rdx), %ymm19

// CHECK: vpsraw $123, -4128(%rdx), %ymm19
// CHECK:  encoding: [0x62,0xf1,0x65,0x20,0x71,0xa2,0xe0,0xef,0xff,0xff,0x7b]
          vpsraw $123, -4128(%rdx), %ymm19

// CHECK: vpsrlvw %xmm19, %xmm22, %xmm30
// CHECK:  encoding: [0x62,0x22,0xcd,0x00,0x10,0xf3]
          vpsrlvw %xmm19, %xmm22, %xmm30

// CHECK: vpsrlvw %xmm19, %xmm22, %xmm30 {%k7}
// CHECK:  encoding: [0x62,0x22,0xcd,0x07,0x10,0xf3]
          vpsrlvw %xmm19, %xmm22, %xmm30 {%k7}

// CHECK: vpsrlvw %xmm19, %xmm22, %xmm30 {%k7} {z}
// CHECK:  encoding: [0x62,0x22,0xcd,0x87,0x10,0xf3]
          vpsrlvw %xmm19, %xmm22, %xmm30 {%k7} {z}

// CHECK: vpsrlvw (%rcx), %xmm22, %xmm30
// CHECK:  encoding: [0x62,0x62,0xcd,0x00,0x10,0x31]
          vpsrlvw (%rcx), %xmm22, %xmm30

// CHECK: vpsrlvw 291(%rax,%r14,8), %xmm22, %xmm30
// CHECK:  encoding: [0x62,0x22,0xcd,0x00,0x10,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpsrlvw 291(%rax,%r14,8), %xmm22, %xmm30

// CHECK: vpsrlvw 2032(%rdx), %xmm22, %xmm30
// CHECK:  encoding: [0x62,0x62,0xcd,0x00,0x10,0x72,0x7f]
          vpsrlvw 2032(%rdx), %xmm22, %xmm30

// CHECK: vpsrlvw 2048(%rdx), %xmm22, %xmm30
// CHECK:  encoding: [0x62,0x62,0xcd,0x00,0x10,0xb2,0x00,0x08,0x00,0x00]
          vpsrlvw 2048(%rdx), %xmm22, %xmm30

// CHECK: vpsrlvw -2048(%rdx), %xmm22, %xmm30
// CHECK:  encoding: [0x62,0x62,0xcd,0x00,0x10,0x72,0x80]
          vpsrlvw -2048(%rdx), %xmm22, %xmm30

// CHECK: vpsrlvw -2064(%rdx), %xmm22, %xmm30
// CHECK:  encoding: [0x62,0x62,0xcd,0x00,0x10,0xb2,0xf0,0xf7,0xff,0xff]
          vpsrlvw -2064(%rdx), %xmm22, %xmm30

// CHECK: vpsrlvw %ymm27, %ymm25, %ymm30
// CHECK:  encoding: [0x62,0x02,0xb5,0x20,0x10,0xf3]
          vpsrlvw %ymm27, %ymm25, %ymm30

// CHECK: vpsrlvw %ymm27, %ymm25, %ymm30 {%k1}
// CHECK:  encoding: [0x62,0x02,0xb5,0x21,0x10,0xf3]
          vpsrlvw %ymm27, %ymm25, %ymm30 {%k1}

// CHECK: vpsrlvw %ymm27, %ymm25, %ymm30 {%k1} {z}
// CHECK:  encoding: [0x62,0x02,0xb5,0xa1,0x10,0xf3]
          vpsrlvw %ymm27, %ymm25, %ymm30 {%k1} {z}

// CHECK: vpsrlvw (%rcx), %ymm25, %ymm30
// CHECK:  encoding: [0x62,0x62,0xb5,0x20,0x10,0x31]
          vpsrlvw (%rcx), %ymm25, %ymm30

// CHECK: vpsrlvw 291(%rax,%r14,8), %ymm25, %ymm30
// CHECK:  encoding: [0x62,0x22,0xb5,0x20,0x10,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpsrlvw 291(%rax,%r14,8), %ymm25, %ymm30

// CHECK: vpsrlvw 4064(%rdx), %ymm25, %ymm30
// CHECK:  encoding: [0x62,0x62,0xb5,0x20,0x10,0x72,0x7f]
          vpsrlvw 4064(%rdx), %ymm25, %ymm30

// CHECK: vpsrlvw 4096(%rdx), %ymm25, %ymm30
// CHECK:  encoding: [0x62,0x62,0xb5,0x20,0x10,0xb2,0x00,0x10,0x00,0x00]
          vpsrlvw 4096(%rdx), %ymm25, %ymm30

// CHECK: vpsrlvw -4096(%rdx), %ymm25, %ymm30
// CHECK:  encoding: [0x62,0x62,0xb5,0x20,0x10,0x72,0x80]
          vpsrlvw -4096(%rdx), %ymm25, %ymm30

// CHECK: vpsrlvw -4128(%rdx), %ymm25, %ymm30
// CHECK:  encoding: [0x62,0x62,0xb5,0x20,0x10,0xb2,0xe0,0xef,0xff,0xff]
          vpsrlvw -4128(%rdx), %ymm25, %ymm30

// CHECK: vpsravw %xmm27, %xmm28, %xmm28
// CHECK:  encoding: [0x62,0x02,0x9d,0x00,0x11,0xe3]
          vpsravw %xmm27, %xmm28, %xmm28

// CHECK: vpsravw %xmm27, %xmm28, %xmm28 {%k3}
// CHECK:  encoding: [0x62,0x02,0x9d,0x03,0x11,0xe3]
          vpsravw %xmm27, %xmm28, %xmm28 {%k3}

// CHECK: vpsravw %xmm27, %xmm28, %xmm28 {%k3} {z}
// CHECK:  encoding: [0x62,0x02,0x9d,0x83,0x11,0xe3]
          vpsravw %xmm27, %xmm28, %xmm28 {%k3} {z}

// CHECK: vpsravw (%rcx), %xmm28, %xmm28
// CHECK:  encoding: [0x62,0x62,0x9d,0x00,0x11,0x21]
          vpsravw (%rcx), %xmm28, %xmm28

// CHECK: vpsravw 291(%rax,%r14,8), %xmm28, %xmm28
// CHECK:  encoding: [0x62,0x22,0x9d,0x00,0x11,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpsravw 291(%rax,%r14,8), %xmm28, %xmm28

// CHECK: vpsravw 2032(%rdx), %xmm28, %xmm28
// CHECK:  encoding: [0x62,0x62,0x9d,0x00,0x11,0x62,0x7f]
          vpsravw 2032(%rdx), %xmm28, %xmm28

// CHECK: vpsravw 2048(%rdx), %xmm28, %xmm28
// CHECK:  encoding: [0x62,0x62,0x9d,0x00,0x11,0xa2,0x00,0x08,0x00,0x00]
          vpsravw 2048(%rdx), %xmm28, %xmm28

// CHECK: vpsravw -2048(%rdx), %xmm28, %xmm28
// CHECK:  encoding: [0x62,0x62,0x9d,0x00,0x11,0x62,0x80]
          vpsravw -2048(%rdx), %xmm28, %xmm28

// CHECK: vpsravw -2064(%rdx), %xmm28, %xmm28
// CHECK:  encoding: [0x62,0x62,0x9d,0x00,0x11,0xa2,0xf0,0xf7,0xff,0xff]
          vpsravw -2064(%rdx), %xmm28, %xmm28

// CHECK: vpsravw %ymm17, %ymm28, %ymm20
// CHECK:  encoding: [0x62,0xa2,0x9d,0x20,0x11,0xe1]
          vpsravw %ymm17, %ymm28, %ymm20

// CHECK: vpsravw %ymm17, %ymm28, %ymm20 {%k5}
// CHECK:  encoding: [0x62,0xa2,0x9d,0x25,0x11,0xe1]
          vpsravw %ymm17, %ymm28, %ymm20 {%k5}

// CHECK: vpsravw %ymm17, %ymm28, %ymm20 {%k5} {z}
// CHECK:  encoding: [0x62,0xa2,0x9d,0xa5,0x11,0xe1]
          vpsravw %ymm17, %ymm28, %ymm20 {%k5} {z}

// CHECK: vpsravw (%rcx), %ymm28, %ymm20
// CHECK:  encoding: [0x62,0xe2,0x9d,0x20,0x11,0x21]
          vpsravw (%rcx), %ymm28, %ymm20

// CHECK: vpsravw 291(%rax,%r14,8), %ymm28, %ymm20
// CHECK:  encoding: [0x62,0xa2,0x9d,0x20,0x11,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpsravw 291(%rax,%r14,8), %ymm28, %ymm20

// CHECK: vpsravw 4064(%rdx), %ymm28, %ymm20
// CHECK:  encoding: [0x62,0xe2,0x9d,0x20,0x11,0x62,0x7f]
          vpsravw 4064(%rdx), %ymm28, %ymm20

// CHECK: vpsravw 4096(%rdx), %ymm28, %ymm20
// CHECK:  encoding: [0x62,0xe2,0x9d,0x20,0x11,0xa2,0x00,0x10,0x00,0x00]
          vpsravw 4096(%rdx), %ymm28, %ymm20

// CHECK: vpsravw -4096(%rdx), %ymm28, %ymm20
// CHECK:  encoding: [0x62,0xe2,0x9d,0x20,0x11,0x62,0x80]
          vpsravw -4096(%rdx), %ymm28, %ymm20

// CHECK: vpsravw -4128(%rdx), %ymm28, %ymm20
// CHECK:  encoding: [0x62,0xe2,0x9d,0x20,0x11,0xa2,0xe0,0xef,0xff,0xff]
          vpsravw -4128(%rdx), %ymm28, %ymm20
