/*!
  \example scip_20_gd.cpp

  \brief GD R}hɂf[^擾

  \author Satofumi KAMIMURA

  $Id: scip_20_gd.cpp 1474 2009-11-01 05:33:08Z satofumi $
*/

#include "DetectOS.h"
#include "SerialDevice.h"
#include "ConnectionUtils.h"
#include "ScipUtils.h"
#include <cstring>
#include <cstdio>

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  // K؂Ƀ|[gύX邱
#if defined(WINDOWS_OS)
  const char device[] = "COM3";
#elif defined(LINUX_OS)
  const char device[] = "/dev/ttyACM0";
#else
  const char device[] = "/dev/tty.usbmodem1d11";
#endif

  SerialDevice con;
  if (! con.connect(device, 19200)) {
    printf("SerialDevice::connect: %s\n", con.what());
    exit(1);
  }

  // SCIP2.0 ̌ĂяoƁA̖
  enum { Timeout = 200 };
  con.send("SCIP2.0\n", 8);
  skip(&con, Timeout);

  // "BM"  URG _
  con.send("BM\n", 3);
  int ret = recvReply(&con, Timeout);
  if (ret < 0) {
    printf("BM fail: %d\n", ret);
    exit(1);
  }

  // "GD" R}h̑M
  /*
    GD    ܂́AGS
    0000  AMIN ̒lgׂ
    0768  AMAX ȉłȂ΂ȂȂ
    01    ܂Ƃ߂鐔
    ܂Ƃ߂鐔 X ɂƁA
    A X ̋f[^̂ŏ̋f[^Ԃ
    Mf[^邱Ƃł
  */
  con.send("GD0000076801\n", 13);

  // Mf[^̕\
  enum {
    LineMax = 64 + 1 + 1,
    URG_04LX_MAX = 768,
    PacketByte = 3,             // GD Ȃ̂ŁA3byte
  };
  char buffer[LineMax];
  char data_buffer[(URG_04LX_MAX + 1) * PacketByte];
  int filled = 0;
  int line_count = 0;
  int n;
  while ((n = readline(&con, buffer, LineMax, Timeout)) > 0) {
    printf("%s\n", buffer);

    // fR[hpɃf[^ۊ (Rsڈȍ~Af[^)
    // line_count 0: GR[obN
    //            1: Xe[^X
    //            2: ^CX^v
    if (line_count >= 3) {
      int copy_size = n - 1;   // Ō̃`FbNT͏O
      memmove(&data_buffer[filled], buffer, copy_size);
      filled += copy_size;
    }
    ++line_count;
  }
  printf("\n");

  // Mf[^̃fR[h
  // \Ȃ΁AsɃf[^̃fR[hsقAɂ₳
  for (int i = 0; i < URG_04LX_MAX; ++i) {
    // Lȋf[^́A[DMIN, DMAX] ݂̂ł邱Ƃɒ
    int length = decode(&data_buffer[i * PacketByte], PacketByte);
    printf("%d, ", length);
    if ((i % 10) == 00) {
      printf("\n");
    }
  }
  printf("\n");

  return 0;
}
