/*!
  \example intensity_sample.c

  \brief Of[^̎擾

  \author Satofumi KAMIMURA

  $Id: intensity_sample.c 1194 2009-07-31 13:45:24Z satofumi $
*/

#include "urg_ctrl.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>


static void urg_exit(urg_t *urg, const char *message)
{
  printf("%s: %s\n", message, urg_error(urg));
  urg_disconnect(urg);

#ifdef MSC
  getchar();
#endif
  exit(1);
}


static void printData(urg_t *urg, urg_parameter_t *parameter,
                      long data[], int data_size, long intensity[])
{
#if 1
  int timestamp = urg_recentTimestamp(urg);

  /* Őf[^݂̂\ */
  /* urg_minDistance() ȉ̋f[^́Al\ */
  printf("%d: %ld [mm] (%ld) %d [msec]\n", parameter->area_front_,
         data[parameter->area_front_],
         intensity[parameter->area_front_],
         timestamp);
#else
  /* Sf[^\ */
  int i;

  for (i = 0; i < data_size; ++i) {
    printf("%d: %ld [mm] (%ld)\n", i, data[i], intensity[i]);
  }
#endif
}


//! main
int main(int argc, char *argv[])
{
  enum {
    CaptureTimes = 10,           /* f[^擾 */
  };

  const char device[] = "COM3"; /* Windows ł̗ */
  //const char device[] = "/dev/ttyACM0"; /* Linux ł̗ */

  int data_max;
  long* data;
  long* intensity;
  int scan_msec;
  urg_parameter_t parameter;
  int ret;
  int n;
  int i;

  /* ڑ */
  urg_t urg;
  ret = urg_connect(&urg, device, 115200);
  if (ret < 0) {
    urg_exit(&urg, "urg_connect()");
  }

  /* Mobt@̊m */
  data_max = urg_dataMax(&urg);
  data = (long*)malloc(sizeof(long) * data_max);
  if (data == NULL) {
    perror("data buffer");
    exit(1);
  }
  intensity = (long*)malloc(sizeof(long) * data_max);
  if (intensity == NULL) {
    perror("data buffer");
    exit(1);
  }

  urg_parameters(&urg, &parameter);
  scan_msec = urg_scanMsec(&urg);

  if (strcmp("UTM-30LX", urg_model(&urg))) {
    /* Top-URG  GD ł̋xf[^͎擾łȂ */

    /* GD ł̃f[^vB擾񐔂 CaptureTimes  */
    printf("GD capture\n");
    for (i = 0; i < CaptureTimes; ++i) {
      /* f[^v */
      ret = urg_requestData(&urg, URG_GD_INTENSITY, URG_FIRST, URG_LAST);
      if (ret < 0) {
        urg_exit(&urg, "urg_requestData()");
      }

      /* M */
      n = urg_receiveDataWithIntensity(&urg, data, data_max, intensity);
      if (n < 0) {
        urg_exit(&urg, "urg_receiveData()");
      }
      printData(&urg, &parameter, data, n, intensity);
    }
    printf("\n");
  }

  /* MD ł̃f[^vB擾񐔂 CaptureTimes  */
  printf("MD(ME) capture\n");

  /* 100 ȏ̘Af[^擾ɂ́A擾񐔂𖳌ɐݒ肷邱 */
  /* urg_setCaptureTimes(&urg, UrgInfinityTimes); */
  assert(CaptureTimes < 100);
  urg_setCaptureTimes(&urg, CaptureTimes);

  /* f[^v */
  ret = urg_requestData(&urg, URG_MD_INTENSITY, URG_FIRST, URG_LAST);
  if (ret < 0) {
    urg_exit(&urg, "urg_requestData()");
  }

  /* f[^擾 */
  for (i = 0; i < CaptureTimes; ++i) {
    /* M */
    n = urg_receiveDataWithIntensity(&urg, data, data_max, intensity);
    if (n < 0) {
      urg_exit(&urg, "urg_receiveData()");
    }
    printData(&urg, &parameter, data, n, intensity);
  }

  if (CaptureTimes > 99) {
    // 99 ȏ̃f[^擾̏ꍇAIȃf[^擾̒~Kv
    urg_laserOff(&urg);
  }

  urg_disconnect(&urg);
  free(data);
  free(intensity);

#ifdef MSC
  getchar();
#endif

  return 0;
}
