/*!
  \example get_timestamp.c

  \brief ^CX^v̎擾Tv

  TM0, TM1, TM2 R}hpāA^CX^v擾

  \author Satofumi KAMIMURA

  $Id: get_timestamp.c 1194 2009-07-31 13:45:24Z satofumi $
*/

#include "urg_ctrl.h"
#include <stdio.h>
#include <stdlib.h>


static void urg_exit(urg_t *urg, const char *message)
{
  printf("%s: %s\n", message, urg_error(urg));
  urg_disconnect(urg);

#ifdef MSC
  getchar();
#endif
  exit(1);
}


//! main
int main(int argc, char *argv[])
{
  enum {
    CaptureTimes = 10,
  };

  const char device[] = "COM3"; /* Windows ł̗ */
  //const char device[] = "/dev/ttyACM0"; /* Linux ł̗ */

  long timestamp = 0;
  int ret = 0;
  int i;

  /* ڑ */
  urg_t urg;
  ret = urg_connect(&urg, device, 115200);
  if (ret < 0) {
    urg_exit(&urg, "urg_connect()");
  }

  /* ^CX^v[hɑJڂA^CX^v\ */
  urg_enableTimestampMode(&urg);
  for (i = 0; i < CaptureTimes; ++i) {
    timestamp = urg_currentTimestamp(&urg);
    printf("%02d: timestamp: %ld [msec]\n", i, timestamp);
  }
  urg_disableTimestampMode(&urg);

#ifdef MSC
  getchar();
#endif

  return 0;
}
