#if !defined( SSTPCLIENT_ )
#define SSTPCLIENT_

#include "TCPClient.h"
#include "ThreadControl.h"

// #pragma comment(linker, "/NODEFAULTLIB:libc")


class SSTPClient : public ThreadControl						// SSTP NCAgNX
{
protected:
	// ThreadControl I[o[Ch֐
	virtual DWORD Run();

public:	
	// RXgN^
	SSTPClient(LPCSTR szSender = "EZSSTP", LPCSTR szSakuraAddr = "localhost", int SSTPPort = 9801);
	virtual ~SSTPClient();									// fXgN^
	
	// SSTP ֐											// SSTP p[^
	void InitSSTP(LPCSTR szSender = "EZSSTP", LPCSTR szSakuraAddr = "localhost", int SSTPPort = 9801);
	
	int SSTP(LPCSTR szBuffer);								// v[eLXgM
	
	int SSTPSend(LPCSTR szScript, LPCSTR szOption = NULL);	// SEND SSTP/1.1
	int SSTPExecute(LPCSTR szCommand, LPCSTR szVer);		// EXECUTE SSTP
	int SSTPExGetName();									// EXECUTE SSTP/1.0
	int SSTPExSetCookie(LPCSTR szEntry, LPCSTR szValue);	// EXECUTE SSTP/1.1
	int SSTPExGetCookie(LPCSTR szEntry);					// EXECUTE SSTP/1.1
	int SSTPExGetVersion();									// EXECUTE SSTP/1.2
	int SSTPExQuiet();										// EXECUTE SSTP/1.3
	int SSTPExRestore();									// EXECUTE SSTP/1.3
	int SSTPGive(LPCSTR szDocument, LPCSTR szSongname);		// GIVE SSTP/1.1
	int SSTPCommunicate(LPCSTR szSentence, LPCSTR szOption = NULL);	// COMMUNICATE SSTP/1.1
	int SSTPCommunicate(int port, LPCSTR szSentence, LPCSTR szOption = NULL);	// COMMUNICATE SSTP/1.2
	
	// A߂l擾
	int IsSynchronized();								// SSTP ʐMIĂ邩H
	int Synchronize(DWORD dwTimeOut = INFINITE);		// 
	LPCSTR GetSendBuffer();								// ŌɑMXNvgԂ
	LPCSTR GetStatusCode();								// O SSTP ʐM̃Xe[^XR[hԂ
	int GetStatusCodeInt();								// O SSTP ʐM̃Xe[^XR[h int ^ŕԂ
	LPCSTR GetStatusToken(int n);						// O SSTP ʐM̃Xe[^XR[h߂lo

private:
	TCPClient cl;

	char	m_Sender[256];
	char	m_SakuraAddr[256];
	int		m_SSTPPort;
	
	char	m_SendText[2048];
	char	m_ReturnText[256];
	char	m_ReturnBuf[256];
	int		m_ErrorCode;
};

#endif // SSTPCLIENT_
