#!

@files	= <*.cpp>;
for(@files){
	$obj = $_;
	$obj =~ s/cpp$/exe/;
	$obj{$_}=$obj;
	$obj =~ /^(\w+)\./;
	push(@all,<<"EOS");

$1.exe: $1.o \$(STDLIB) \$(CRT)
	\$(LD) \$(LFLAGS) -o $1.elf $1.o \$(CRT) \$(STDLIB)
	\$(ELF2COM) $1.elf $1.com
	\$(BIM2BIN) -osacmp -tek1 BS:0 in:$1.com out:$1.tek
	\$(BINDCOM) tek ../tools/sfx64.bin $1.tek $1.exe

EOS
}

open(FILE,"gcc -MM -I ../include *.cpp |");
@lines = <FILE>;
close(FILE);
open(FILE,">Makefile");
binmode(FILE);
print FILE <<EOT;
include ../user/Makefile.inc

STDLIB	= ../lib/pekoe64.a
CRT	= ../lib/crt64.o
CFINCLUDE	= -I../include

.cpp.o:
	\$(CC) \$(CFLAGS) \$(CFINCLUDE) \$*.cpp

EOT
print FILE "all: " . join(" ",sort(values %obj)) . "\n\n";
print FILE "clean:\n\t-rm -f *.o *.elf *.com *.tek *.exe \n\n";
print FILE @lines;
print FILE @all;
close(FILE);
