
#include "win64.h"

HANDLE CreateFile(LPCTSTR lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,LPSECURITY_ATTRIBUTES lpSecurityAttributes,
	DWORD dwCreationDisposition,DWORD dwFlagsAndAttributes,HANDLE hTemplateFile){

	HFILE handle=-1;

	int access=0;
	if((dwDesiredAccess & GENERIC_ALL) || (dwDesiredAccess&(GENERIC_READ|GENERIC_WRITE))==(GENERIC_READ|GENERIC_WRITE) ){
		access = 2;
	}else if(dwDesiredAccess & (GENERIC_WRITE)){
		access = 1;
	}

	switch(dwCreationDisposition){
	case CREATE_NEW:
		handle=_dos_create_new(lpFileName,dwFlagsAndAttributes);
		break;
	case CREATE_ALWAYS:
		handle=_dos_create(lpFileName,dwFlagsAndAttributes);
		break;
	case OPEN_EXISTING:
		handle=_dos_open(access,lpFileName);
		break;
	case OPEN_ALWAYS:
		handle=_dos_open(access,lpFileName);
		if(handle<0){
			handle=_dos_create_new(lpFileName,dwFlagsAndAttributes);
		}
		break;
	case TRUNCATE_EXISTING:
		handle=_dos_open(access,lpFileName);
		if(handle>=0){
			;
		}
		break;
	}
	return (handle<0)?INVALID_HANDLE_VALUE:__DosHandleToWin64Handle(handle);
}
