//
//	64bit kernel
//
//  program:
//		Sakky
//
//  modified
//      bayside
//
//	platform:
//		AMD64
//
//	license:
//		BSD License
//

//#define	puts	__kputs
//#define	putchar	__kputchar
//#define	printf	__kprintf

#include <pekoe64.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <sys/errno.h>

struct __memstat {
	DWORD	acpiRecMemBase,acpiRecMemSize,acpiNVSMemBase,acpiNVSMemSize;
	DWORD	szMidMem,szHiMem;
	QWORD	szExtMem;
	WORD	szLowMem;
	WORD	_text_vram;
	WORD	_apm_ver;
	BYTE	_col,_row;
};

__memstat memstat;

void printf(char *str){
	for (int i = 0; i < strlen(str); i++) {
	switch(str[i]){
		case '\n':
			memstat._col=0;
			memstat._row++;
			break;
		default:
			char* vram=(char*)(intptr)(memstat._text_vram<<4);
			vram[memstat._col*2+memstat._row*160]=str[i];
			memstat._col++;
		}
	}
}

extern "C"
void start_kernel(const __memstat* m){
	memcpy(&memstat,m,sizeof(memstat));

	printf("OrangePekoe [Free version]\n(C)2004 The Open Source Software for OrangePekoe\n");
	printf("Memory: ");
	char num[18];
	ltoa((memstat.szMidMem+memstat.szHiMem+0x3FF)>>10, num, 10);
	printf(num);
	printf("KB\n\n");
	printf("Hello, 64bit world!\nok");

	for(;;){}
}
