/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.session;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;


/**
 * ZbṼ^CAEgoXbhĂяo
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class SessionUnbounder extends Thread {
	/** ĎԊu(msec) */
	private int interval;
	/** XbhItO */
	private boolean exitf = false; 
	/** ZbV}l[W[ */
	private SessionManager manager;

	/**
	 * RXgN^
	 */
	SessionUnbounder(SessionManager mngr, int itv) {
		interval = itv;
		manager = mngr;

		// ̃Xbh̒~҂Ȃ悤ɂ
		setDaemon(true);
	}
	/**
	 * XbhC
	 */
	public void run() {
		try {
			while(true) {
				if(exitf) {
					// IVOi
					throw new InterruptedException();
				}
				checkAllSessions();
				sleep(interval);
			}
		} catch(InterruptedException ie) {
			shutdown();
		}
	}
	/**
	 * Ď߂
	 */
	public void done() {
		exitf = true;
	}
	/**
	 * Is
	 */
	private void shutdown() {
		done();
		manager = null;
	}
	/**
	 * ZbṼ^CAEgĎ
	 * ^CAEgĂZbV΁C^CAEgCxg𔭐
	 */
	protected void checkAllSessions() {
		Map sessions = manager.getAllSessions();
		ArrayList inactives = new ArrayList();
		synchronized(sessions) {
			for(Iterator it = sessions.keySet().iterator(); it.hasNext();) {
				String sessionId = (String)it.next();
				Session session;
				try {
					session = manager.getSession(sessionId, false);
					if(session != null && session.isActive() == false) {
						inactives.add(session);
					}
				} catch (IllegalSessionStateException e) {
					// ZbVɖ̂Ŗ
				}
			}
			manager.removeAllSessions(inactives);
		}
	}
}
