/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.session;

import org.logical_paradox.common.util.AttributeChangeListener;
import org.logical_paradox.common.util.DateTime;
import org.logical_paradox.common.util.ObservableAttribute;

/**
 * ZbVIuWFNg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class Session implements ObservableAttribute {
	/** ZbVIuWFNg̃ftHg(20) */
	public static final long DEFAULT_SESSION_LIFETIME = 1000*20;

	/** ZbV̐Ɣj̃^C~OŌĂяo܂ */
	private SessionBindingListener listener;
	/** ̃ZbV̗L */
	private long expireDateTime;
	/** ZbV̐(msec) ftHg20 */
	private long lifetime = DEFAULT_SESSION_LIFETIME;
	/** ZbVID */
	private final String sessionId;
	/** ̃ZbVɌŗL̃ReLXg */
	private SessionContext context = new SessionContext();

	/** ݓǗ[eBeB */
	private DateTime datetime = DateTime.getInstance();
	
	/** ZbV̏ */
	private boolean available = true;

	/**
	 * RXgN^
	 * @param sid ZbVID
	 */
	Session(String sid) throws IllegalSessionStateException {
		sessionId = sid;
		touch();
	}
	/**
	 * RXgN^
	 * @param sid ZbVID
	 * @param itv ZbV̗L(msec)
	 */
	Session(String sid, long itv) throws IllegalSessionStateException {
		this(sid);
		lifetime = itv;
		touch();
	}
	/**
	 * ̃ZbṼZbVIDԂ
	 * @return ZbVID
	 */
	public String getSessionId() {
		return sessionId;
	}
	/**
	 * ZbVǉ/j̃Xi[o^
	 * @param lsnr Xi[
	 */
	public void setSessionBindingListener(SessionBindingListener lsnr) throws IllegalSessionStateException {
		checkSessionState();
		listener = lsnr;
	}
	/**
	 * ZbVǉ/j̃Xi[o^
	 */
	public void removeSessionBindingListener() throws IllegalSessionStateException {
		checkSessionState();
		listener = null;
	}
	/**
	 * ZbVZbV}l[W[AoEhꂽۂɌĂяo܂
	 */
	void unbound() {
		if(listener != null) {
			listener.onUnBound();
		}
		// ̃ZbV̏Ԃ𖳌ɂ
		available = false;
	}
	/**
	 * ZbV̏ԂLǂ
	 * @throws IllegalSessionStateException ZbVLłȂȂ
	 */
	private void checkSessionState() throws IllegalSessionStateException {
		if(available == false) {
			throw new IllegalSessionStateException("ZbV͊ɗLłȂȂ܂");
		}
	}
	/**
	 * ZbV̗LĂȂǂԂ
	 * @return true:  / false:؂
	 */
	public boolean isActive() {
		return datetime.currentTimeInMillis() <= expireDateTime;
	}
	/**
	 * ̃ZbV̗L
	 * ʏAZbVReLXgɑ΂ANZTĂ΂
	 */
	void touch() throws IllegalSessionStateException {
		checkSessionState();
		expireDateTime = datetime.currentTimeInMillis() + lifetime;
	}
	/**
	 * YZbVLǂݒ肷
	 * @param state true:L / false:
	 */
	void setSessionState(boolean state) throws IllegalSessionStateException {
		checkSessionState();
		available = state;
	}
	/**
	 * YZbVLǂԂ
	 * @return true:L / false:
	 */
	public boolean getSessionState() throws IllegalSessionStateException {
		checkSessionState();
		return available;
	}
	/**
	 * ̃ZbṼReLXgɑ΂đύXXi[o^
	 * @param key 
	 * @param lsnr ύXXi[
	 */
	public void setAttributeChangeListener(String key, AttributeChangeListener lsnr) {
		context.setAttribute(key, lsnr);
	}
	/**
	 * ̃ZbṼReLXg瑮ύXXi[폜
	 * @param key 
	 */
	public void removeAttributeChangeListener(String key) {
		context.removeAttributeChangeListener(key);
	}
	/**
	 * ̃ZbṼReLXg瑮l擾
	 * @param key 
	 * @return l
	 */
	public Object getAttribute(String key) throws IllegalSessionStateException {
		touch();
		return context.getAttribute(key);
	}
	/**
	 * ̃ZbṼReLXgɑ΂đlݒ肷
	 * @param key 
	 * @param o l
	 */
	public void setAttribute(String key, Object o) throws IllegalSessionStateException {
		touch();
		context.setAttribute(key, o);
	}
	/**
	 * ̃ZbṼReLXg瑮l菜
	 * @param  key 
	 */
	public void removeAttribute(String key) throws IllegalSessionStateException {
		touch();
		context.removeAttribute(key);
	}
}
