/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.queue;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jms.MessageListener;
import org.opengion.fukurou.queue.QueueInfo;
import org.opengion.fukurou.queue.QueueReceive;

public class QueueReceive_SQS
implements QueueReceive {
    private AmazonSQS client = null;
    private ReceiveMessageRequest request = null;
    private String sqsServer = "";
    private static final String GROUPID_ATTR = "MessageGroupId";

    @Override
    public void connect(String string, String string2, String string3) {
        Object object;
        this.sqsServer = string;
        if (StringUtils.isNullOrEmpty((String)string2)) {
            this.client = (AmazonSQS)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials((AWSCredentialsProvider)new InstanceProfileCredentialsProvider(false))).build();
        } else {
            object = new BasicAWSCredentials(string2, string3);
            this.client = (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)object))).withRegion(Regions.AP_NORTHEAST_1.getName())).build();
        }
        this.request = new ReceiveMessageRequest(string);
        object = new ArrayList();
        object.add(GROUPID_ATTR);
        this.request.setAttributeNames((Collection)object);
    }

    @Override
    public QueueInfo receive(String string) {
        QueueInfo queueInfo = null;
        List list = this.client.receiveMessage(this.request).getMessages();
        if (list.size() > 0) {
            Message message = (Message)list.get(0);
            Map map = message.getAttributes();
            String string2 = (String)map.get(GROUPID_ATTR);
            queueInfo = new QueueInfo();
            queueInfo.setMessage(message.getBody());
            queueInfo.setSqsFifoGroupId(string2);
            this.client.deleteMessage(new DeleteMessageRequest(this.sqsServer, message.getReceiptHandle()));
        }
        return queueInfo;
    }

    @Override
    public void close() {
    }

    @Override
    public void setListener(String string, MessageListener messageListener) {
        throw new RuntimeException("SQS\u3067\u306fsetListener\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
    }

    @Override
    public void closeListener() {
        throw new RuntimeException("SQS\u3067\u306fcloseListener\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
    }

    public static void main(String[] stringArray) {
        QueueReceive_SQS queueReceive_SQS = new QueueReceive_SQS();
        String string = System.getProperty("jmsServer");
        String string2 = System.getProperty("sqsAccessKey");
        String string3 = System.getProperty("sqsSecretKey");
        queueReceive_SQS.connect(string, string2, string3);
        QueueInfo queueInfo = queueReceive_SQS.receive(null);
        if (queueInfo != null) {
            System.out.println("groupId:" + queueInfo.getSqsFifoGroupId());
            System.out.println("message:" + queueInfo.getMessage());
        } else {
            System.out.println("\u30ad\u30e5\u30fc\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
    }

    @Override
    public void setBatchFlg(Boolean bl) {
    }
}

