/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.request.processor;

import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.reply.IReplyPartError;
import oracle.cloudstorage.api.reply.IReplyPartErrorContainer;

public class SimpleXMLResponseParser {
    private static final String ERRORS = "<errors>";
    private static final String NAME = "<name>";
    private static final String STATUS = "<status>";
    private final String body;
    int index;

    public SimpleXMLResponseParser(String body) {
        this.body = body;
    }

    public int find(String tag) {
        int length = tag.length();
        int start = this.body.indexOf(tag, this.index);
        if (start < 0) {
            this.index = this.body.length();
            return -1;
        }
        this.index = start += length;
        return this.index;
    }

    public String get(String tag) {
        int start = this.find(tag);
        if (start < 0) {
            this.index = this.body.length();
            return null;
        }
        int end = this.body.indexOf("</", start);
        this.index = end + tag.length() + 1;
        String value = this.body.substring(start, end);
        return value;
    }

    public int getInt(String tag) {
        String value = this.get(tag);
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value.trim());
    }

    public void parseErrors(IReplyPartErrorContainer reply, String containerId) {
        this.find(ERRORS);
        String path = null;
        String errorContainerId = containerId;
        while ((path = this.get(NAME)) != null) {
            int slash;
            String statusText = this.get(STATUS);
            int code = Integer.parseInt(statusText.replaceFirst("\\s+.*", ""));
            Status status = Status.fromStatusCode(code);
            String objectId = path;
            if (errorContainerId == null && (slash = path.indexOf(47)) > 0) {
                errorContainerId = path.substring(0, slash);
                objectId = path.substring(slash + 1);
            }
            Error error = new Error(errorContainerId, objectId, status);
            reply.add(error);
        }
    }

    public void parseErrors(IReplyPartErrorContainer reply) {
        this.find(ERRORS);
        String path = null;
        while ((path = this.get(NAME)) != null) {
            String statusText = this.get(STATUS);
            int code = Integer.parseInt(statusText.replaceFirst("\\s+.*", ""));
            Status status = Status.fromStatusCode(code);
            int slash = path.indexOf(47);
            String containerId = slash < 0 ? path : path.substring(0, slash);
            String objectId = slash < 0 ? null : path.substring(slash + 1);
            Error error = new Error(containerId, objectId, status);
            reply.add(error);
        }
    }

    public String toString() {
        return this.body;
    }

    static class Error
    implements IReplyPartError {
        private final String containerId;
        private final String objectId;
        private final Status status;

        private Error(String containerId, String objectId, Status status) {
            this.containerId = containerId;
            this.objectId = objectId;
            this.status = status;
        }

        @Override
        public String getContainerId() {
            return this.containerId;
        }

        @Override
        public String getObjectId() {
            return this.objectId;
        }

        @Override
        public Status getStatus() {
            return this.status;
        }

        public String toString() {
            return this.getContainerId() + (this.getObjectId() == null ? "" : "/" + this.getObjectId()) + ": " + this.getStatus().getStatusCode();
        }
    }
}

