/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.storage.object.options;

import com.google.common.collect.Maps;
import java.util.Map;
import org.openstack4j.openstack.storage.object.functions.MetadataToHeadersFunction;

public final class CreateUpdateContainerOptions {
    private Map<String, String> headers = Maps.newHashMap();

    private CreateUpdateContainerOptions() {
    }

    public static final CreateUpdateContainerOptions create() {
        return new CreateUpdateContainerOptions();
    }

    public CreateUpdateContainerOptions headers(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public CreateUpdateContainerOptions metadata(Map<String, String> metadata) {
        this.headers.putAll(MetadataToHeadersFunction.create("X-Container-Meta-").apply(metadata));
        return this;
    }

    public CreateUpdateContainerOptions versionsLocation(String containerName) {
        this.add("X-Versions-Location", containerName);
        return this;
    }

    public CreateUpdateContainerOptions accessAnybodyRead() {
        this.add("X-Container-Read", ".r:*,.rlistings");
        return this;
    }

    public CreateUpdateContainerOptions accessRead(String acl) {
        this.add("X-Container-Read", acl);
        return this;
    }

    public CreateUpdateContainerOptions accessWrite(String acl) {
        this.add("X-Container-Write", acl);
        return this;
    }

    public Map<String, String> getOptions() {
        return this.headers;
    }

    private void add(String key, String value) {
        this.headers.put(key, value);
    }
}

